"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = handler;
const client_cloudformation_1 = require("@aws-sdk/client-cloudformation");
const cloudFormationClient = new client_cloudformation_1.CloudFormationClient({});
async function handler() {
    const res = [];
    let nextToken;
    let finished = false;
    while (!finished) {
        const response = await cloudFormationClient.send(new client_cloudformation_1.DescribeStacksCommand({ NextToken: nextToken }));
        for (const stack of (response.Stacks ?? [])) {
            if (stack.StackName) {
                res.push(stack.StackName);
            }
        }
        nextToken = response.NextToken;
        if (nextToken === undefined) {
            finished = true;
        }
    }
    return res;
}
//# sourceMappingURL=data:application/json;base64,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