"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = handler;
const client_cloudformation_1 = require("@aws-sdk/client-cloudformation");
const cloudFormationClient = new client_cloudformation_1.CloudFormationClient({});
async function handler(stackName) {
    const template = await cloudFormationClient.send(new client_cloudformation_1.GetTemplateCommand({
        StackName: stackName,
    }));
    if (!template.TemplateBody) {
        return [];
    }
    if (!process.env.DOCKER_IMAGE_ASSET_HASH) {
        throw new Error('Missing DOCKER_IMAGE_ASSET_HASH environment variable');
    }
    const dockerTagPrefix = findDockerTagPrefix(process.env.DOCKER_IMAGE_ASSET_HASH);
    const regexp = new RegExp(`(${dockerTagPrefix})?[a-f0-9]{64}`, 'g');
    const hashes = template.TemplateBody.match(regexp);
    return [...new Set(hashes)];
}
function findDockerTagPrefix(hash) {
    if (hash.length === 64) {
        return '';
    }
    return hash.substring(0, hash.length - 64);
}
//# sourceMappingURL=data:application/json;base64,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