import * as cloudfront from 'aws-cdk-lib/aws-cloudfront';
import * as route53 from 'aws-cdk-lib/aws-route53';
import * as s3 from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
/**
 * Properties for a StaticWebsite
 */
export interface StaticWebsiteProps {
    /**
     * The domain name for this static website
     *
     * @example www.my-static-website.com
     */
    readonly domainName: string;
    /**
     * The hosted zone where records should be added
     */
    readonly hostedZone: route53.IHostedZone;
    /**
     * A backend configuration that will be saved as `config.json`
     * in the S3 bucket of the static website.
     *
     * The frontend can query this config by doing `fetch('/config.json')`.
     *
     * @example { userPoolId: '1234', apiEndoint: 'https://www.my-api.com/api' }
     */
    readonly backendConfiguration?: any;
    /**
     * A list of domain names that should redirect to `domainName`
     *
     * @default - the domain name of the hosted zone
     */
    readonly redirects?: string[];
    /**
     * Response headers policy for the default behavior
     *
     * @default - a new policy is created with best practice security headers
     */
    readonly responseHeadersPolicy?: cloudfront.ResponseHeadersPolicy;
    /**
     * Cache policy for the default behavior
     *
     * @default CachePolicy.CACHING_OPTIMIZED
     */
    readonly cachePolicy?: cloudfront.ICachePolicy;
    /**
     * The Lambda@Edge functions to invoke before serving the contents.
     *
     * @default - an origin request function that redirects all requests for a path to /index.html
     */
    readonly edgeLambdas?: cloudfront.EdgeLambda[];
}
/**
 * A CloudFront static website hosted on S3
 */
export declare class StaticWebsite extends Construct {
    /**
    * Best practice security headers used as default
    */
    static defaultSecurityHeadersBehavior: cloudfront.ResponseSecurityHeadersBehavior;
    /**
     * The CloudFront distribution of this static website
     */
    readonly distribution: cloudfront.Distribution;
    /**
     * The S3 bucket of this static website
     */
    readonly bucket: s3.Bucket;
    constructor(scope: Construct, id: string, props: StaticWebsiteProps);
}
