"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SslServerTest = exports.SslServerTestGrade = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_events_1 = require("aws-cdk-lib/aws-events");
const aws_events_targets_1 = require("aws-cdk-lib/aws-events-targets");
const aws_sns_1 = require("aws-cdk-lib/aws-sns");
const aws_stepfunctions_1 = require("aws-cdk-lib/aws-stepfunctions");
const aws_stepfunctions_tasks_1 = require("aws-cdk-lib/aws-stepfunctions-tasks");
const constructs_1 = require("constructs");
const analyze_function_1 = require("./analyze-function");
const extract_grade_function_1 = require("./extract-grade-function");
/**
 * SSL Server test grade
 */
var SslServerTestGrade;
(function (SslServerTestGrade) {
    SslServerTestGrade["A_PLUS"] = "A+";
    SslServerTestGrade["A"] = "A";
    SslServerTestGrade["A_MINUS"] = "A-";
    SslServerTestGrade["B"] = "B";
    SslServerTestGrade["C"] = "C";
    SslServerTestGrade["D"] = "D";
    SslServerTestGrade["E"] = "E";
    SslServerTestGrade["F"] = "F";
})(SslServerTestGrade || (exports.SslServerTestGrade = SslServerTestGrade = {}));
/**
 * Perform SSL server test for a hostname
 */
class SslServerTest extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.alarmTopic = props.alarmTopic ?? new aws_sns_1.Topic(this, 'AlarmTopic');
        const stateMachine = SslServerTestStateMachine.getOrCreate(this);
        this.alarmTopic.grantPublish(stateMachine);
        const rule = new aws_events_1.Rule(this, 'Rule', {
            schedule: props.schedule ?? aws_events_1.Schedule.rate(aws_cdk_lib_1.Duration.days(1)),
        });
        rule.addTarget(new aws_events_targets_1.SfnStateMachine(stateMachine, {
            input: aws_events_1.RuleTargetInput.fromObject({
                host: props.host,
                minimumGrade: props.minimumGrade ?? SslServerTestGrade.A_PLUS,
                alarmTopicArn: this.alarmTopic.topicArn,
            }),
        }));
    }
}
exports.SslServerTest = SslServerTest;
_a = JSII_RTTI_SYMBOL_1;
SslServerTest[_a] = { fqn: "cloudstructs.SslServerTest", version: "0.9.14" };
class SslServerTestStateMachine extends constructs_1.Construct {
    static getOrCreate(scope) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const uid = 'cloudstructs/ssl-server-test.StateMachine';
        const construct = stack.node.tryFindChild(uid) ?? new SslServerTestStateMachine(stack, uid);
        return construct.stateMachine;
    }
    constructor(scope, id) {
        super(scope, id);
        const analyzeFunction = new analyze_function_1.AnalyzeFunction(this, 'AnalyzeFunction', {
            timeout: aws_cdk_lib_1.Duration.seconds(30),
        });
        const startAnalysis = new aws_stepfunctions_tasks_1.LambdaInvoke(this, 'Start Analysis', {
            lambdaFunction: analyzeFunction,
            payload: aws_stepfunctions_1.TaskInput.fromObject({
                host: aws_stepfunctions_1.JsonPath.stringAt('$.host'),
                startNew: 'on',
            }),
            payloadResponseOnly: true,
        }).addRetry({
            interval: aws_cdk_lib_1.Duration.seconds(2),
            errors: ['Lambda.Unknown'],
        });
        const wait = new aws_stepfunctions_1.Wait(this, 'Wait', {
            time: aws_stepfunctions_1.WaitTime.duration(aws_cdk_lib_1.Duration.seconds(30)),
        });
        const pollAnalysis = new aws_stepfunctions_tasks_1.LambdaInvoke(this, 'Poll Analysis', {
            lambdaFunction: analyzeFunction,
            payload: aws_stepfunctions_1.TaskInput.fromObject({
                host: aws_stepfunctions_1.JsonPath.stringAt('$.host'),
            }),
            payloadResponseOnly: true,
        }).addRetry({
            interval: aws_cdk_lib_1.Duration.seconds(2),
            errors: ['Lambda.Unknown'],
        });
        ;
        const extractGradeFunction = new extract_grade_function_1.ExtractGradeFunction(this, 'ExtractGradeFunction');
        const extractGrade = new aws_stepfunctions_tasks_1.LambdaInvoke(this, 'Extract Grade', {
            lambdaFunction: extractGradeFunction,
            payloadResponseOnly: true,
            resultPath: '$.grade',
        });
        const notify = new SnsPublishToTopicAtPath(this, 'Notify', {
            path: '$$.Execution.Input.alarmTopicArn',
            message: aws_stepfunctions_1.TaskInput.fromJsonPathAt('States.JsonToString($)'),
            subject: aws_stepfunctions_1.JsonPath.stringAt("States.Format('SSL grade for {} is below minimum grade ({} < {})', $.host, $.grade, $$.Execution.Input.minimumGrade)"),
        });
        const fail = new aws_stepfunctions_1.Fail(this, 'Fail');
        this.stateMachine = new aws_stepfunctions_1.StateMachine(this, 'StateMachine', {
            definitionBody: aws_stepfunctions_1.DefinitionBody.fromChainable(startAnalysis
                .next(wait)
                .next(pollAnalysis)
                .next(new aws_stepfunctions_1.Choice(this, 'Is Ready ?')
                .when(aws_stepfunctions_1.Condition.stringEquals('$.status', 'READY'), extractGrade.next(new aws_stepfunctions_1.Choice(this, 'Is Grade Below Minimum?')
                .when(aws_stepfunctions_1.Condition.stringLessThanJsonPath('$$.Execution.Input.minimumGrade', '$.grade'), notify)
                .otherwise(new aws_stepfunctions_1.Pass(this, 'Pass'))))
                .when(aws_stepfunctions_1.Condition.stringEquals('$.status', 'ERROR'), fail)
                .otherwise(wait))),
            timeout: aws_cdk_lib_1.Duration.hours(1),
        });
    }
}
class SnsPublishToTopicAtPath extends aws_stepfunctions_1.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
    }
    _renderTask() {
        return {
            Resource: `arn:${aws_cdk_lib_1.Stack.of(this).partition}:states:::sns:publish`,
            Parameters: aws_stepfunctions_1.FieldUtils.renderObject({
                TopicArn: aws_stepfunctions_1.JsonPath.stringAt(this.props.path),
                Message: this.props.message.value,
                Subject: this.props.subject,
            }),
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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