"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = handler;
/* eslint-disable no-console */
const client_textract_1 = require("@aws-sdk/client-textract");
const web_api_1 = require("@slack/web-api");
const got_1 = require("got");
const textractClient = new client_textract_1.TextractClient({});
async function handler(event) {
    console.log('Event: %j', event);
    const slackClient = new web_api_1.WebClient(process.env.SLACK_TOKEN);
    // Get file info
    const info = await slackClient.files.info({
        file: event.file_id,
    });
    console.log('File info: %j', info);
    if (!info.file) {
        console.log('No file');
        return;
    }
    if (!info.file.mimetype?.startsWith('image')) {
        console.log('Not an image');
        return;
    }
    if (!info.file.url_private) {
        console.log('No private URL');
        return;
    }
    // Get file
    const file = await (0, got_1.default)(info.file.url_private, {
        headers: {
            Authorization: `Bearer ${process.env.SLACK_TOKEN}`,
        },
    }).buffer();
    // Detect text with Textract
    const data = await textractClient.send(new client_textract_1.DetectDocumentTextCommand({
        Document: { Bytes: file },
    }));
    if (!data.Blocks) {
        console.log('No text detected');
        return;
    }
    // Add detected text in image thread
    const postMessage = await slackClient.chat.postMessage({
        channel: event.channel_id,
        text: data.Blocks.filter((b) => b.BlockType === 'LINE').map((b) => b.Text).join('\n'),
        thread_ts: info.file.shares?.public?.[event.channel_id][0].ts,
    });
    console.log('Post message: %j', postMessage);
}
//# sourceMappingURL=data:application/json;base64,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