"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.verifyRequestSignature = verifyRequestSignature;
const crypto = require("crypto");
function verifyRequestSignature(options) {
    const fiveMinutesAgo = Math.floor(Date.now() / 1000) - (60 * 5);
    if (options.requestTimestamp < fiveMinutesAgo) {
        console.error('Slack request signing verification outdated');
        return false;
    }
    const hmac = crypto.createHmac('sha256', options.signingSecret);
    const [version, hash] = options.requestSignature.split('=');
    hmac.update(`${version}:${options.requestTimestamp}:${options.body}`);
    const hex = hmac.digest('hex');
    if (hash.length !== hex.length ||
        !crypto.timingSafeEqual(Buffer.from(hash), Buffer.from(hex))) {
        console.error('Slack request signing verification failed');
        return false;
    }
    return true;
}
//# sourceMappingURL=data:application/json;base64,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