"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SlackEvents = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const apigatewayv2 = require("aws-cdk-lib/aws-apigatewayv2");
const integrations = require("aws-cdk-lib/aws-apigatewayv2-integrations");
const events = require("aws-cdk-lib/aws-events");
const logs = require("aws-cdk-lib/aws-logs");
const constructs_1 = require("constructs");
const events_function_1 = require("./events-function");
/**
 * Send Slack events to Amazon EventBridge
 */
class SlackEvents extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        if (props.customEventBus) {
            this.eventBus = new events.EventBus(this, 'EventBus');
        }
        // Send event to the event bus
        const handler = new events_function_1.EventsFunction(this, 'handler', {
            logRetention: logs.RetentionDays.ONE_MONTH,
            environment: {
                SLACK_SIGNING_SECRET: props.signingSecret.toString(),
            },
        });
        if (this.eventBus) {
            handler.addEnvironment('EVENT_BUS_NAME', this.eventBus.eventBusName);
        }
        events.EventBus.grantAllPutEvents(handler);
        // HTTP API
        const httpApi = new apigatewayv2.HttpApi(this, 'SlackEventsApi', {
            defaultIntegration: new integrations.HttpLambdaIntegration('Integration', handler),
            apiName: props.apiName,
        });
        new cdk.CfnOutput(this, 'ApiEndpoint', {
            value: httpApi.apiEndpoint,
        });
    }
}
exports.SlackEvents = SlackEvents;
_a = JSII_RTTI_SYMBOL_1;
SlackEvents[_a] = { fqn: "cloudstructs.SlackEvents", version: "0.9.14" };
//# sourceMappingURL=data:application/json;base64,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