"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = handler;
/* eslint-disable no-console */
const client_eventbridge_1 = require("@aws-sdk/client-eventbridge");
const signature_1 = require("./signature");
const eventBridgeClient = new client_eventbridge_1.EventBridgeClient({});
/**
 * Handle Slack events
 */
async function handler(event) {
    console.log('Event: %j', event);
    // Base API gateway response
    const response = {
        statusCode: 200,
        body: '',
    };
    try {
        if (!process.env.SLACK_SIGNING_SECRET)
            throw new Error('The environment variable SLACK_SIGNING_SECRET is not defined');
        if (!event.body)
            throw new Error('Missing body');
        if (!event.headers['X-Slack-Signature'])
            throw new Error('Missing X-Slack-Signature');
        if (!event.headers['X-Slack-Request-Timestamp'])
            throw new Error('Missing X-Slack-Request-Timestamp');
        if (!(0, signature_1.verifyRequestSignature)({
            body: event.body,
            requestSignature: event.headers['X-Slack-Signature'],
            requestTimestamp: parseInt(event.headers['X-Slack-Request-Timestamp'], 10),
            signingSecret: process.env.SLACK_SIGNING_SECRET,
        })) {
            response.statusCode = 403;
            return response;
        }
        const body = JSON.parse(event.body);
        console.log('Body: %j', body);
        if (body.type === 'url_verification') { // Slack URL verification, respond with challenge
            console.log('URL verification');
            response.body = JSON.stringify({ challenge: body.challenge });
            return response;
        }
        const putEvents = await eventBridgeClient.send(new client_eventbridge_1.PutEventsCommand({
            Entries: [{
                    Detail: event.body,
                    DetailType: 'Slack Event',
                    Source: 'slack',
                    Resources: [body.api_app_id],
                    EventBusName: process.env.EVENT_BUS_NAME,
                    Time: new Date(body.event_time),
                }],
        }));
        console.log('Put events: %j', putEvents);
        return response;
    }
    catch (err) {
        console.log(err);
        response.statusCode = 500;
        return response;
    }
}
//# sourceMappingURL=data:application/json;base64,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