import { Construct } from 'constructs';
/**
 * Properties for a MjmlTemplate
 */
export interface MjmlTemplateProps {
    /**
     * The name of the template
     *
     * @default - a CloudFormation generated name
     */
    readonly templateName?: string;
    /**
     * The subject line of the email
     */
    readonly subject: string;
    /**
     * The MJML for the email
     */
    readonly mjml: string;
}
/**
 * SES email template from [MJML](https://mjml.io/)
 */
export declare class MjmlTemplate extends Construct {
    /**
     * The name of the template
     */
    readonly templateName: string;
    constructor(scope: Construct, id: string, props: MjmlTemplateProps);
}
