"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = handler;
/* eslint-disable no-console */
async function handler(event) {
    console.log('Event: %j', event);
    const sesNotification = event.Records[0].ses;
    if (!process.env.SOURCE_WHITELIST) {
        console.log('Missing SOURCE_WHITELIST');
        return { disposition: 'STOP_RULE' };
    }
    if (!new RegExp(process.env.SOURCE_WHITELIST).test(sesNotification.mail.source)) {
        console.log(`${sesNotification.mail.source} does not match /${process.env.SOURCE_WHITELIST}/`);
        return { disposition: 'STOP_RULE' };
    }
    return { disposition: 'CONTINUE' };
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoid2hpdGVsaXN0LmxhbWJkYS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9lbWFpbC1yZWNlaXZlci93aGl0ZWxpc3QubGFtYmRhLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQ0EsMEJBZ0JDO0FBakJELCtCQUErQjtBQUN4QixLQUFLLFVBQVUsT0FBTyxDQUFDLEtBQXlCO0lBQ3JELE9BQU8sQ0FBQyxHQUFHLENBQUMsV0FBVyxFQUFFLEtBQUssQ0FBQyxDQUFDO0lBRWhDLE1BQU0sZUFBZSxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDO0lBRTdDLElBQUksQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGdCQUFnQixFQUFFLENBQUM7UUFDbEMsT0FBTyxDQUFDLEdBQUcsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO1FBQ3hDLE9BQU8sRUFBRSxXQUFXLEVBQUUsV0FBVyxFQUFFLENBQUM7SUFDdEMsQ0FBQztJQUVELElBQUksQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGdCQUFnQixDQUFDLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLEVBQUUsQ0FBQztRQUNoRixPQUFPLENBQUMsR0FBRyxDQUFDLEdBQUcsZUFBZSxDQUFDLElBQUksQ0FBQyxNQUFNLG9CQUFvQixPQUFPLENBQUMsR0FBRyxDQUFDLGdCQUFnQixHQUFHLENBQUMsQ0FBQztRQUMvRixPQUFPLEVBQUUsV0FBVyxFQUFFLFdBQVcsRUFBRSxDQUFDO0lBQ3RDLENBQUM7SUFFRCxPQUFPLEVBQUUsV0FBVyxFQUFFLFVBQVUsRUFBRSxDQUFDO0FBQ3JDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKiBlc2xpbnQtZGlzYWJsZSBuby1jb25zb2xlICovXG5leHBvcnQgYXN5bmMgZnVuY3Rpb24gaGFuZGxlcihldmVudDogQVdTTGFtYmRhLlNFU0V2ZW50KTogUHJvbWlzZTx7IGRpc3Bvc2l0aW9uOiBzdHJpbmcgfT4ge1xuICBjb25zb2xlLmxvZygnRXZlbnQ6ICVqJywgZXZlbnQpO1xuXG4gIGNvbnN0IHNlc05vdGlmaWNhdGlvbiA9IGV2ZW50LlJlY29yZHNbMF0uc2VzO1xuXG4gIGlmICghcHJvY2Vzcy5lbnYuU09VUkNFX1dISVRFTElTVCkge1xuICAgIGNvbnNvbGUubG9nKCdNaXNzaW5nIFNPVVJDRV9XSElURUxJU1QnKTtcbiAgICByZXR1cm4geyBkaXNwb3NpdGlvbjogJ1NUT1BfUlVMRScgfTtcbiAgfVxuXG4gIGlmICghbmV3IFJlZ0V4cChwcm9jZXNzLmVudi5TT1VSQ0VfV0hJVEVMSVNUKS50ZXN0KHNlc05vdGlmaWNhdGlvbi5tYWlsLnNvdXJjZSkpIHtcbiAgICBjb25zb2xlLmxvZyhgJHtzZXNOb3RpZmljYXRpb24ubWFpbC5zb3VyY2V9IGRvZXMgbm90IG1hdGNoIC8ke3Byb2Nlc3MuZW52LlNPVVJDRV9XSElURUxJU1R9L2ApO1xuICAgIHJldHVybiB7IGRpc3Bvc2l0aW9uOiAnU1RPUF9SVUxFJyB9O1xuICB9XG5cbiAgcmV0dXJuIHsgZGlzcG9zaXRpb246ICdDT05USU5VRScgfTtcbn1cbiJdfQ==