"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailReceiver = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const logs = require("aws-cdk-lib/aws-logs");
const s3 = require("aws-cdk-lib/aws-s3");
const ses = require("aws-cdk-lib/aws-ses");
const actions = require("aws-cdk-lib/aws-ses-actions");
const sns = require("aws-cdk-lib/aws-sns");
const subscriptions = require("aws-cdk-lib/aws-sns-subscriptions");
const constructs_1 = require("constructs");
const whitelist_function_1 = require("./whitelist-function");
/**
 * Receive emails through SES, save them to S3 and invokes a
 * Lambda function
 */
class EmailReceiver extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const receiptRule = new ses.ReceiptRule(this, 'ReceiptRule', {
            ruleSet: props.receiptRuleSet,
            recipients: props.recipients,
            after: props.afterRule,
            enabled: props.enabled,
        });
        const bucket = new s3.Bucket(this, 'Bucket', {
            blockPublicAccess: s3.BlockPublicAccess.BLOCK_ALL,
            encryption: s3.BucketEncryption.S3_MANAGED,
            lifecycleRules: [{ expiration: aws_cdk_lib_1.Duration.days(1) }],
        });
        bucket.grantRead(props.function); // Download email
        const topic = new sns.Topic(this, 'Topic');
        // Actions
        if (props.sourceWhitelist) {
            const whitelistHandler = new whitelist_function_1.WhitelistFunction(this, 'whitelist', {
                environment: {
                    SOURCE_WHITELIST: props.sourceWhitelist,
                },
                logRetention: logs.RetentionDays.ONE_MONTH,
            });
            receiptRule.addAction(new actions.Lambda({
                function: whitelistHandler,
                invocationType: actions.LambdaInvocationType.REQUEST_RESPONSE,
            }));
        }
        receiptRule.addAction(new actions.S3({
            bucket,
            topic,
        }));
        topic.addSubscription(new subscriptions.LambdaSubscription(props.function)); // Notify
    }
}
exports.EmailReceiver = EmailReceiver;
_a = JSII_RTTI_SYMBOL_1;
EmailReceiver[_a] = { fqn: "cloudstructs.EmailReceiver", version: "0.9.14" };
//# sourceMappingURL=data:application/json;base64,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