"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/url-shortener/redirect.edge-lambda.ts
var redirect_edge_lambda_exports = {};
__export(redirect_edge_lambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(redirect_edge_lambda_exports);
var import_client_s3 = require("@aws-sdk/client-s3");
async function handler(event) {
  const request = event.Records[0].cf.request;
  try {
    const s3Origin = request.origin?.s3;
    if (!s3Origin) {
      throw new Error("No S3 origin");
    }
    const s3Client = new import_client_s3.S3Client({ region: s3Origin.region });
    const bucket = s3Origin.domainName.replace(new RegExp(`.s3.${s3Origin.region}.amazonaws.com$`), "");
    const key = request.uri.substring(1);
    const data = await s3Client.send(new import_client_s3.GetObjectCommand({
      Bucket: bucket,
      Key: key
    }));
    if (!data.Body) {
      throw new Error("No body");
    }
    const redirect = JSON.parse(await data.Body.transformToString());
    return {
      status: "301",
      statusDescription: "Moved Permanently",
      headers: {
        location: [{
          key: "Location",
          value: redirect.url
        }]
      }
    };
  } catch (err) {
    console.log(err);
    return {
      status: "404",
      statusDescription: "Not Found"
    };
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
