from __future__ import annotations
from dataclasses import dataclass, field
from typing import List, Optional
from resqml201.abstract_integer_array import AbstractIntegerArray
from resqml201.data_object_reference import DataObjectReference

__NAMESPACE__ = "http://www.energistics.org/energyml/data/resqmlv2"


@dataclass
class StreamlineWellbores:
    """
    The information that allows you to locate, on one or several grids
    (existing or planned), the intersection of volume (cells) and surface
    (faces) elements with a wellbore trajectory (existing or planned).

    :ivar injector_per_line: Size of array = LineCount. Null values of
        -1 signify that that line does not initiate at a injector, e.g.,
        it may come from fluid expansion or an aquifer.
    :ivar producer_per_line: Size of array = LineCount. Null values of
        -1 signify that that line does not terminate at a producer,
        e.g., it may approach a stagnation area. BUSINESS RULE: The cell
        count must equal the number of non-null entries in this array.
    :ivar wellbore_trajectory_representation:
    """
    injector_per_line: Optional[AbstractIntegerArray] = field(
        default=None,
        metadata={
            "name": "InjectorPerLine",
            "type": "Element",
            "namespace": "http://www.energistics.org/energyml/data/resqmlv2",
            "required": True,
        }
    )
    producer_per_line: Optional[AbstractIntegerArray] = field(
        default=None,
        metadata={
            "name": "ProducerPerLine",
            "type": "Element",
            "namespace": "http://www.energistics.org/energyml/data/resqmlv2",
            "required": True,
        }
    )
    wellbore_trajectory_representation: List[DataObjectReference] = field(
        default_factory=list,
        metadata={
            "name": "WellboreTrajectoryRepresentation",
            "type": "Element",
            "namespace": "http://www.energistics.org/energyml/data/resqmlv2",
            "min_occurs": 1,
        }
    )
