from __future__ import annotations
from dataclasses import dataclass, field
from typing import Optional
from resqml201.second_defining_parameter_1 import SecondDefiningParameter1

__NAMESPACE__ = "http://www.opengis.net/gml/3.2"


@dataclass
class SecondDefiningParameter2:
    """gml:secondDefiningParameter is a property containing the definition of
    the second parameter that defines the shape of an ellipsoid.

    An ellipsoid requires two defining parameters: semi-major axis and
    inverse flattening or semi-major axis and semi-minor axis. When the
    reference body is a sphere rather than an ellipsoid, only a single
    defining parameter is required, namely the radius of the sphere; in
    that case, the semi-major axis "degenerates" into the radius of the
    sphere. The inverseFlattening element contains the inverse
    flattening value of the ellipsoid. This value is a scale factor (or
    ratio). It uses gml:LengthType with the restriction that the unit of
    measure referenced by the uom attribute must be suitable for a scale
    factor, such as percent, permil, or parts-per-million. The
    semiMinorAxis element contains the length of the semi-minor axis of
    the ellipsoid. When the isSphere element is included, the ellipsoid
    is degenerate and is actually a sphere. The sphere is completely
    defined by the semi-major axis, which is the radius of the sphere.
    """
    class Meta:
        name = "secondDefiningParameter"
        namespace = "http://www.opengis.net/gml/3.2"

    second_defining_parameter: Optional[SecondDefiningParameter1] = field(
        default=None,
        metadata={
            "name": "SecondDefiningParameter",
            "type": "Element",
            "required": True,
        }
    )
