# auto generated by update_py.py

import time
import queue
import threading
from typing import Set
from datetime import datetime, timedelta

from tlclient.linker.timer import Timer


class TimerHelper:

    class PQueueItemWrapper():
        def __init__(self, timer_id, tp, func):
            self._timer_id = timer_id
            self._tp = tp
            self._func = func

        def __lt__(self, other):
            return self._tp < other._tp

    def __init__(self, logger, time_switchday: str = '17:30:00', time_morning_load: str = '08:36:00'):
        self._logger = logger
        self._time_switchday: str = time_switchday
        self._time_morning_load: str = time_morning_load
        self._timer_id_base: int = 1
        self._timer_q = queue.PriorityQueue()
        self._timer_cancelled: Set[int] = set()
        self._timer_lock = threading.Lock()
        self._timer_t = threading.Thread(
            target=self._timer_func, name='timer', daemon=True)
        self._timer_t.start()

    def _timer_func(self):
        is_switched = False
        while not self.is_stopped():
            now = datetime.now()
            if not self._timer_q.empty():
                item = self._timer_q.get()
                with self._timer_lock:
                    if item._timer_id in self._timer_cancelled:
                        self._logger.info(f'timer {item._timer_id} cancelled by user')
                        self._timer_cancelled.remove(item._timer_id)
                        self._timer_q.task_done()
                        continue

                if now >= item._tp:
                    self._logger.info(f'process {item._func} at {item._tp} (timer_id){item._timer_id}')
                    item._func()
                    self._timer_q.task_done()
                else:
                    self._timer_q.put(item)
                    self._timer_q.task_done()
                    time.sleep(0.05)
            else:
                time.sleep(0.2)

            now = now.strftime('%H:%M:%S')
            if now < self._time_switchday:
                if is_switched and now >= self._time_morning_load:
                    is_switched = False
            else:
                if not is_switched:
                    self.on_switch_day()
                    is_switched = True

    @staticmethod
    def parse_nano(nano, format='%Y-%m-%d %H:%M:%S'):
        return Timer.nano_to_datetime(nano).strftime(format)

    def insert_func_at_next(self, tp, func) -> int:
        tp = datetime.strptime(tp, '%H:%M:%S')
        now = datetime.now()
        tp = datetime(year=now.year, month=now.month, day=now.day, hour=tp.hour, minute=tp.minute, second=tp.second)
        if now > tp:
            tp += timedelta(days=1)
        with self._timer_lock:
            timer_id = self._timer_id_base
            self._timer_id_base += 1
        self._logger.info(f'got a job {func} at {tp} (timer_id){timer_id}')
        self._timer_q.put(self.PQueueItemWrapper(timer_id, tp, func))
        return timer_id

    def insert_func_after(self, elapsed, func) -> int:
        tp = datetime.now() + timedelta(seconds=elapsed)
        with self._timer_lock:
            timer_id = self._timer_id_base
            self._timer_id_base += 1
        self._logger.info(f'got a job {func} after {elapsed} seconds, at {tp} (timer_id){timer_id}')
        self._timer_q.put(self.PQueueItemWrapper(timer_id, tp, func))
        return timer_id

    def cancel_a_timer(self, timer_id: int):
        with self._timer_lock:
            self._timer_cancelled.add(timer_id)

    # should be overrided
    def on_switch_day(self):
        pass
