# auto generated by update_py.py

import enum
from tlclient.linker.constant import ReadableEnum, MsgType as LinkerMsgType
from tlclient.trader.pb_msg import message_pb

MODULE_TICKER_LENGTH = 20
MODULE_SOURCE_LENGTH = 20
MODULE_ACCOUNT_LENGTH = 20
MODULE_GATEWAY_LENGTH = 10
MODULE_ORDERREF_LENGTH = 50
MODULE_ERR_MSG_LENGTH = 81
MODULE_TRADEID_LENGTH = 50
MODULE_TRADINGDAY_LENGTH = 9

ORDER_BOOK_SIZE = 10

USER_RSA_KEY_DIR = '/shared/key/'
CURVE_KEY_DIR = '/shared/curve_key/'

class MsgType(LinkerMsgType, enum.IntEnum):
    # trading msg types
    REQ_ORDER_INSERT = 200
    REQ_ORDER_INSERT_NEED_RM = 201
    REQ_ORDER_INSERT_PASS_RM = 202
    REQ_ORDER_INSERT_FAIL_RM = 203
    REQ_ORDER_INSERT_BASKET = 204
    REQ_ORDER_INSERT_J = 205

    REQ_ORDER_CANCEL = 210
    REQ_ORDER_STATUS = 220
    REQ_POSITION = 230
    REQ_ACCOUNT = 240
    REQ_ORDER_INFO = 250
    REQ_ACTIVE_ORDERS = 260
    REQ_HISTORY_TRADES = 270
    REQ_CANCEL_ACTIVE_ORDERS = 261
    RSP_ORDER_INSERT = 300
    RSP_ORDER_INSERT_BASKET = 303
    RSP_ORDER_CANCEL = 310
    RSP_ORDER_STATUS = 320
    RSP_POSITION = 330
    RSP_ACCOUNT = 340
    RSP_ORDER_INFO = 350
    RSP_ACTIVE_ORDERS = 360
    RSP_CANCEL_ACTIVE_ORDERS = 361
    RSP_HISTORY_TRADES = 370
    RTN_ORDER = 400
    RTN_TRADE = 410

    # market msg types
    MKT_DATA_TYPE = 500
    MKT_SUBSCRIBE = 500
    MKT_SNAP = 510
    MKT_SNAP_PLUS = 511
    MKT_SNAP_FUT = 512
    MKT_SNAP_OPT = 513
    MKT_SNAP_AGG = 519
    MKT_BAR = 520
    MKT_BAR_GEN = 521
    MKT_VOL = 522
    MKT_INDEX = 530
    MKT_ORDER = 540
    MKT_TRADE = 550
    MKT_DATA_END = 599

    # risk manager related
    RMS_STATUS = 800
    RMS_UPDATE_RULE = 801
    RMS_DELETE_RULE = 802
    RMS_APPLY_RULE = 803
    RMS_UNAPPLY_RULE = 804
    RMS_ACTIVATE_RULE = 805
    RMS_DEACTIVATE_RULE = 806
    RMS_RISK_RULE_VIOLATED_WARNING = 810
    RMS_UPDATE_RULE_HELPER = 850

    # system status msg types
    SYSTEM_STATUS_TYPE = 900
    GTW_CONNECTION = 900
    SYSTEM_STATUS_END = 999

    @staticmethod
    def is_market_data_type(msg_type):
        return msg_type >= MsgType.MKT_DATA_TYPE and msg_type <= MsgType.MKT_DATA_END

    @staticmethod
    def is_trading_data_type(msg_type):
        return msg_type >= MsgType.REQ_ORDER_INSERT and msg_type < MsgType.MKT_DATA_TYPE

    @staticmethod
    def is_system_status_data_type(msg_type):
        return msg_type >= MsgType.SYSTEM_STATUS_TYPE and msg_type <= MsgType.SYSTEM_STATUS_END


class ExchangeID(ReadableEnum):
    NOT_AVAILABLE = message_pb.EXCHANGE_UNSPECIFIED
    SSE = message_pb.EXCHANGE_SSE
    SZE = message_pb.EXCHANGE_SZE
    HK = message_pb.EXCHANGE_HK
    CFFEX = message_pb.EXCHANGE_CFFEX
    DCE = message_pb.EXCHANGE_DCE
    SHFE = message_pb.EXCHANGE_SHFE
    CZCE = message_pb.EXCHANGE_CZCE

    APEX = message_pb.EXCHANGE_APEX
    BMD = message_pb.EXCHANGE_BMD
    CBOE = message_pb.EXCHANGE_CBOE
    CME_CBT = message_pb.EXCHANGE_CME_CBT
    CME = message_pb.EXCHANGE_CME
    DGCX = message_pb.EXCHANGE_DGCX
    DL_DCE = message_pb.EXCHANGE_DL_DCE
    DME = message_pb.EXCHANGE_DME
    ECBOT = message_pb.EXCHANGE_ECBOT
    HKEX = message_pb.EXCHANGE_HKEX
    ICE_SG = message_pb.EXCHANGE_ICE_SG
    ICE = message_pb.EXCHANGE_ICE
    INE = message_pb.EXCHANGE_INE
    JPX = message_pb.EXCHANGE_JPX
    KRX = message_pb.EXCHANGE_KRX
    LIFFE = message_pb.EXCHANGE_LIFFE
    LME = message_pb.EXCHANGE_LME
    NYBOT = message_pb.EXCHANGE_NYBOT
    NY_INE = message_pb.EXCHANGE_NY_INE
    SFE = message_pb.EXCHANGE_SFE
    SGXQ = message_pb.EXCHANGE_SGXQ
    TAIFEX = message_pb.EXCHANGE_TAIFEX
    TFEX = message_pb.EXCHANGE_TFEX
    TOCOM = message_pb.EXCHANGE_TOCOM
    XEUREX = message_pb.EXCHANGE_XEUREX

    CRYPTO = message_pb.EXCHANGE_CRYPTO
    HUOBI = message_pb.EXCHANGE_HUOBI
    OKEX = message_pb.EXCHANGE_OKEX
    BINANCE = message_pb.EXCHANGE_BINANCE
    BITMEX = message_pb.EXCHANGE_BITMEX
    BITSTAMP = message_pb.EXCHANGE_BITSTAMP
    COINBASE = message_pb.EXCHANGE_COINBASE
    KRAKEN = message_pb.EXCHANGE_KRAKEN
    BYBIT = message_pb.EXCHANGE_BYBIT
    DERIBIT = message_pb.EXCHANGE_DERIBIT


class Side(ReadableEnum):
    NOT_AVAILABLE = message_pb.SIDE_UNSPECIFIED
    BUY = message_pb.SIDE_BUY
    SELL = message_pb.SIDE_SELL


class Direction(ReadableEnum):
    NOT_AVAILABLE = message_pb.DIRECTION_UNSPECIFIED
    NET = message_pb.DIRECTION_NET
    LONG = message_pb.DIRECTION_LONG
    SHORT = message_pb.DIRECTION_SHORT

    BUY = message_pb.SIDE_BUY # deprecated, should use Side.BUY
    SELL = message_pb.SIDE_SELL # deprecated, should use Side.SELL


# deprecated, should use Direction.NET/LONG/SHORT
class PosiDirection(ReadableEnum):
    NOT_AVAILABLE = message_pb.DIRECTION_UNSPECIFIED
    NET = message_pb.DIRECTION_NET
    LONG = message_pb.DIRECTION_LONG
    SHORT = message_pb.DIRECTION_SHORT


class OrderType(ReadableEnum):
    NOT_AVAILABLE = message_pb.ORDER_TYPE_UNSPECIFIED
    PLAIN_ORDER_PREFIX = message_pb.ORDER_TYPE_PLAIN_ORDER_PREFIX
    BASKET_ORDER_PREFIX = message_pb.ORDER_TYPE_BASKET_ORDER_PREFIX
    ALGO_ORDER_PREFIX = message_pb.ORDER_TYPE_ALGO_ORDER_PREFIX
    # PLAIN
    PLAIN_ORDER = message_pb.ORDER_TYPE_PLAIN
    LIMIT = message_pb.ORDER_TYPE_LIMIT
    MARKET = message_pb.ORDER_TYPE_MARKET
    FAK = message_pb.ORDER_TYPE_FAK
    FOK = message_pb.ORDER_TYPE_FOK
    ANY = message_pb.ORDER_TYPE_ANY
    FAK_BEST_5 = message_pb.ORDER_TYPE_FAK_BEST_5
    FORWARD_BEST = message_pb.ORDER_TYPE_FORWARD_BEST
    REVERSE_BEST = message_pb.ORDER_TYPE_REVERSE_BEST
    # BASKET
    BASKET_ORDER = message_pb.ORDER_TYPE_BASKET
    SINGLE_DAY_BASKET = message_pb.ORDER_TYPE_SINGLE_DAY_BASKET
    # ALGO
    ALGO_ORDER = message_pb.ORDER_TYPE_ALGO
    TWAP = message_pb.ORDER_TYPE_TWAP


class OffsetFlag(ReadableEnum):
    NOT_AVAILABLE = message_pb.OFFSET_FLAG_UNSPECIFIED
    OPEN = message_pb.OFFSET_FLAG_OPEN
    CLOSE = message_pb.OFFSET_FLAG_CLOSE
    FORCE_CLOSE = message_pb.OFFSET_FLAG_FORCE_CLOSE
    CLOSE_TODAY = message_pb.OFFSET_FLAG_CLOSE_TODAY
    CLOSE_YESTERDAY = message_pb.OFFSET_FLAG_CLOSE_YESTERDAY


class OrderStatus(ReadableEnum):
    NOT_AVAILABLE = message_pb.ORDER_STATUS_UNSPECIFIED
    UNKNOWN = message_pb.ORDER_STATUS_UNKNOWN
    PROPOSED = message_pb.ORDER_STATUS_PROPOSED
    RESPONDED = message_pb.ORDER_STATUS_RESPONDED
    QUEUEING = message_pb.ORDER_STATUS_QUEUEING
    NO_TRADE_QUEUEING = message_pb.ORDER_STATUS_NO_TRADE_QUEUEING
    PART_TRADE_QUEUEING = message_pb.ORDER_STATUS_PART_TRADE_QUEUEING
    PENDING_MAX = message_pb.ORDER_STATUS_PENDING_MAX
    # // if status >= 40, it is not pending
    REJECTED = message_pb.ORDER_STATUS_REJECTED  # // router / gateway / exchange reject
    REJECT_BY_ROUTER = message_pb.ORDER_STATUS_REJECT_BY_ROUTER
    REJECT_BY_GATEWAY = message_pb.ORDER_STATUS_REJECT_BY_GATEWAY
    REJECT_BY_EXCHANGE = message_pb.ORDER_STATUS_REJECT_BY_EXCHANGE
    REJECT_BY_RISK_MGR = message_pb.ORDER_STATUS_REJECT_BY_RISK_MGR
    CANCELED = message_pb.ORDER_STATUS_CANCELED  # // cancelled, no mater all traded or partly traded
    NO_TRADE_CANCELED = message_pb.ORDER_STATUS_NO_TRADE_CANCELED
    PART_TRADE_CANCELED = message_pb.ORDER_STATUS_PART_TRADE_CANCELED
    ALL_TRADED = message_pb.ORDER_STATUS_ALL_TRADED
    # // some other middle status...
    TO_CANCEL = message_pb.ORDER_STATUS_TO_CANCEL


class TradingStyle(ReadableEnum):
    NOT_AVAILABLE = 0
    AGGRESSIVE = 1
    NEUTRAL = 2
    CONSERVATIVE = 3


class BarType(ReadableEnum):
    NOT_AVAILABLE = 0
    MIN_1 = 1
    MIN_3 = 2
    MIN_5 = 3
    MIN_15 = 4
    MIN_30 = 5
    HOUR_1 = 10
    HOUR_2 = 11
    HOUR_4 = 12
    HOUR_6 = 13
    HOUR_12 = 14
    DAY_1 = 20
    WEEK_1 = 30
    MONTH_1 = 40
    YEAR_1 = 50

    _type_secs_cache = None

    @classmethod
    def get_seconds(cls, bar_type):
        if cls._type_secs_cache is None:
            cls._type_secs_cache = {
                cls.MIN_1: 1 * 60,
                cls.MIN_3: 3 * 60,
                cls.MIN_5: 5 * 60,
                cls.MIN_15: 15 * 60,
                cls.MIN_30: 30 * 60,
                cls.HOUR_1: 1 * 60 * 60,
                cls.HOUR_2: 2 * 60 * 60,
                cls.HOUR_4: 4 * 60 * 60,
                cls.HOUR_6: 6 * 60 * 60,
                cls.HOUR_12: 12 * 60 * 60,
                cls.DAY_1: 1 * 24 * 60 * 60,
                cls.WEEK_1: 1 * 7 * 24 * 60 * 60,
                cls.MONTH_1: 1 * 30 * 24 * 60 * 60,  # not accurate
                cls.YEAR_1: 1 * 365 * 24 * 60 * 60,  # not accurate
            }
        return cls._type_secs_cache.get(bar_type, -1)


class AssetType(ReadableEnum):
    NOT_AVAILABLE = message_pb.SECURITY_TYPE_UNSPECIFIED
    #
    TRADITIONAL_ASSET = message_pb.SECURITY_TYPE_TRADITIONAL  # 传统金融
    STOCK = message_pb.SECURITY_TYPE_STOCK              # 股票
    FUTURES = message_pb.SECURITY_TYPE_FUTURE            # 期货(合约)
    BOND = message_pb.SECURITY_TYPE_BOND                 # 债券
    OPTION = message_pb.SECURITY_TYPE_STOCK_OPTION             # 期权
    FUND = message_pb.SECURITY_TYPE_FUND                 # 基金
    TECH_STOCK = message_pb.SECURITY_TYPE_TECH_STOCK     # 科创板
    INDEX = message_pb.SECURITY_TYPE_INDEX               # 指数
    REPO = message_pb.SECURITY_TYPE_REPO                 # 逆回购
    IPO = message_pb.SECURITY_TYPE_IPO                   # 新股申购
    #
    CRYPTO_ASSET = message_pb.SECURITY_TYPE_CRYPTO       # 数字货币
    CRYPTO_SPOT = message_pb.SECURITY_TYPE_C_SPOT        # 现货
    CRYPTO_CONTRACT = 22   # 合约(弃用)
    CRYPTO_MARGIN = message_pb.SECURITY_TYPE_C_MARGIN      # 现货杠杆
    CRYPTO_FUTURES = message_pb.SECURITY_TYPE_C_FUTURE     # 交割合约
    CRYPTO_SWAP = message_pb.SECURITY_TYPE_C_SWAP        # 永续合约
    CRYPTO_OPTION = message_pb.SECURITY_TYPE_C_OPTION    # 期权


class ExecRole(ReadableEnum):
    NOT_AVAILABLE = message_pb.EXEC_ROLE_UNSPECIFIED
    MAKER = message_pb.EXEC_ROLE_MAKER
    TAKER = message_pb.EXEC_ROLE_TAKER


class MarginMode(ReadableEnum):
    NOT_AVAILABLE = message_pb.MARGIN_MODE_UNSPECIFIED
    CROSSED = message_pb.MARGIN_MODE_CROSSED
    FIXED = message_pb.MARGIN_MODE_FIXED


class FundTransType(ReadableEnum):
    NOT_AVAILABLE = message_pb.FUND_TRANS_TYPE_UNSPECIFIED
    OUT = message_pb.FUND_TRANS_TYPE_OUT  # 转出 转出到柜台
    IN = message_pb.FUND_TRANS_TYPE_IN  # 转入 从柜台转入
    INTER_OUT = message_pb.FUND_TRANS_TYPE_INTER_OUT  # 跨节点转出 从本节点1，转出到对端节点2，服务器之间划拨，只能跨账户用户使用
    INTER_IN = message_pb.FUND_TRANS_TYPE_INTER_IN  # 跨节点转入 从对端节点2，转入到本节点1，服务器之间划拨，只能跨账户用户使用


class FundOperStatus(ReadableEnum):
    NOT_AVAILABLE = message_pb.FUND_OPER_STATUS_UNSPECIFIED  # 未知
    PROCESSING = message_pb.FUND_OPER_STATUS_PROCESSING  # 已收到，正在处理中
    SUCCESS = message_pb.FUND_OPER_STATUS_SUCCESS  # 成功
    FAILED = message_pb.FUND_OPER_STATUS_FAILED  # 失败
    SUBMITTED = message_pb.FUND_OPER_STATUS_SUBMITTED  # 已提交到集中柜台处理
