"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const core_2 = require("@aws-solutions-constructs/core");
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, core_2.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for aws-apigateway-kinesis';
// Definitions
const props = {
    apiGatewayProps: {
        restApiName: 'my-api',
        deployOptions: {
            methodOptions: {
                '/*/*': {
                    throttlingRateLimit: 100,
                    throttlingBurstLimit: 25
                }
            }
        }
    },
    kinesisStreamProps: {
        shardCount: 1,
        retentionPeriod: core_1.Duration.days(4)
    },
    putRecordRequestTemplate: `{ "StreamName": "\${StreamName}", "Data": "$util.base64Encode($input.json('$.foo'))", "PartitionKey": "$input.path('$.bar')" }`,
    putRecordRequestModel: { schema: {} },
    putRecordsRequestTemplate: `{ "StreamName": "\${StreamName}", "Records": [ #foreach($elem in $input.path('$.records')) { "Data": "$util.base64Encode($elem.foo)", "PartitionKey": "$elem.bar"}#if($foreach.hasNext),#end #end ] }`,
    putRecordsRequestModel: { schema: {} }
};
new lib_1.ApiGatewayToKinesisStreams(stack, 'test-apigateway-kinesis-overwrite', props);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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