var spec2 = {
  "$schema": "https://vega.github.io/schema/vega/v5.json",
  "background": "white",
  "padding": 5,
  "height": 300,
  "data": [
    {"name": "selector014_store"},
    {"name": "selector015_store"},
    {
      "name": "data-34161eebc7e6103e8e00b60ac821ba4b",
      "values": [
        {
          "x_axis": -1.2535821199417114,
          "y_axis": 3.586676597595215,
          "name": "prince",
          "original": "prince"
        },
        {
          "x_axis": -0.9741005897521973,
          "y_axis": 3.7290642261505127,
          "name": "princess",
          "original": "princess"
        },
        {
          "x_axis": -1.0501278638839722,
          "y_axis": -2.0268447399139404,
          "name": "nurse",
          "original": "nurse"
        },
        {
          "x_axis": -0.9151343703269958,
          "y_axis": -2.0640790462493896,
          "name": "doctor",
          "original": "doctor"
        },
        {
          "x_axis": 0.8430215716362,
          "y_axis": -0.06272825598716736,
          "name": "banker",
          "original": "banker"
        },
        {
          "x_axis": -0.43132147192955017,
          "y_axis": -1.5975831747055054,
          "name": "man",
          "original": "man"
        },
        {
          "x_axis": -1.073258876800537,
          "y_axis": -1.6417843103408813,
          "name": "woman",
          "original": "woman"
        },
        {
          "x_axis": -3.006711006164551,
          "y_axis": 0.08844566345214844,
          "name": "cousin",
          "original": "cousin"
        },
        {
          "x_axis": -3.256138563156128,
          "y_axis": -0.2640823423862457,
          "name": "neice",
          "original": "neice"
        },
        {
          "x_axis": -0.8844128251075745,
          "y_axis": 4.284396648406982,
          "name": "king",
          "original": "king"
        },
        {
          "x_axis": -0.9637596607208252,
          "y_axis": 3.8633878231048584,
          "name": "queen",
          "original": "queen"
        },
        {
          "x_axis": -0.37136709690093994,
          "y_axis": -1.4314926862716675,
          "name": "dude",
          "original": "dude"
        },
        {
          "x_axis": -0.33022043108940125,
          "y_axis": -2.0039174556732178,
          "name": "guy",
          "original": "guy"
        },
        {
          "x_axis": 0.005235184449702501,
          "y_axis": -1.1506175994873047,
          "name": "gal",
          "original": "gal"
        },
        {
          "x_axis": 2.1890616416931152,
          "y_axis": -0.3874746263027191,
          "name": "fire",
          "original": "fire"
        },
        {
          "x_axis": 0.8451134562492371,
          "y_axis": -1.5011231899261475,
          "name": "dog",
          "original": "dog"
        },
        {
          "x_axis": 0.9290971755981445,
          "y_axis": -0.6315348148345947,
          "name": "cat",
          "original": "cat"
        },
        {
          "x_axis": 1.9717415571212769,
          "y_axis": 0.1653272807598114,
          "name": "mouse",
          "original": "mouse"
        },
        {
          "x_axis": 3.6464710235595703,
          "y_axis": 0.8340242505073547,
          "name": "red",
          "original": "red"
        },
        {
          "x_axis": 0.6217125654220581,
          "y_axis": -0.011615407653152943,
          "name": "blue",
          "original": "blue"
        },
        {
          "x_axis": 4.070711135864258,
          "y_axis": 0.8428587913513184,
          "name": "green",
          "original": "green"
        },
        {
          "x_axis": 3.9739019870758057,
          "y_axis": 0.8420842289924622,
          "name": "yellow",
          "original": "yellow"
        },
        {
          "x_axis": 3.1992409229278564,
          "y_axis": -0.76308274269104,
          "name": "water",
          "original": "water"
        },
        {
          "x_axis": -0.4370383024215698,
          "y_axis": -1.8055583238601685,
          "name": "person",
          "original": "person"
        },
        {
          "x_axis": -1.5232115983963013,
          "y_axis": -0.6766523718833923,
          "name": "family",
          "original": "family"
        },
        {
          "x_axis": -2.889375925064087,
          "y_axis": -0.0504235103726387,
          "name": "brother",
          "original": "brother"
        },
        {
          "x_axis": -2.935547351837158,
          "y_axis": -0.16567137837409973,
          "name": "sister",
          "original": "sister"
        }
      ]
    },
    {
      "name": "data-52c1f752db2a63c001d356078f606383",
      "values": [
        {
          "x_axis": -3.5124354362487793,
          "y_axis": 4.162352561950684,
          "name": "prince",
          "original": "prince"
        },
        {
          "x_axis": -4.112173080444336,
          "y_axis": 3.8549747467041016,
          "name": "princess",
          "original": "princess"
        },
        {
          "x_axis": -2.517472982406616,
          "y_axis": 3.284545421600342,
          "name": "nurse",
          "original": "nurse"
        },
        {
          "x_axis": -2.7008538246154785,
          "y_axis": 2.768869161605835,
          "name": "doctor",
          "original": "doctor"
        },
        {
          "x_axis": -5.004579067230225,
          "y_axis": 1.7548115253448486,
          "name": "banker",
          "original": "banker"
        },
        {
          "x_axis": -4.107402801513672,
          "y_axis": 1.0861294269561768,
          "name": "man",
          "original": "man"
        },
        {
          "x_axis": -3.2791190147399902,
          "y_axis": 2.9917562007904053,
          "name": "woman",
          "original": "woman"
        },
        {
          "x_axis": -4.7013444900512695,
          "y_axis": 2.9227752685546875,
          "name": "cousin",
          "original": "cousin"
        },
        {
          "x_axis": -4.299141883850098,
          "y_axis": 3.142744541168213,
          "name": "neice",
          "original": "neice"
        },
        {
          "x_axis": -3.8987667560577393,
          "y_axis": 4.549572944641113,
          "name": "king",
          "original": "king"
        },
        {
          "x_axis": -4.172970771789551,
          "y_axis": 4.277510166168213,
          "name": "queen",
          "original": "queen"
        },
        {
          "x_axis": -3.4013280868530273,
          "y_axis": 1.4507380723953247,
          "name": "dude",
          "original": "dude"
        },
        {
          "x_axis": -3.7617805004119873,
          "y_axis": 1.7864001989364624,
          "name": "guy",
          "original": "guy"
        },
        {
          "x_axis": -4.434903144836426,
          "y_axis": 2.3134303092956543,
          "name": "gal",
          "original": "gal"
        },
        {
          "x_axis": -4.485660552978516,
          "y_axis": 0.5962796211242676,
          "name": "fire",
          "original": "fire"
        },
        {
          "x_axis": -2.884521007537842,
          "y_axis": 2.0245754718780518,
          "name": "dog",
          "original": "dog"
        },
        {
          "x_axis": -2.6612389087677,
          "y_axis": 1.595794677734375,
          "name": "cat",
          "original": "cat"
        },
        {
          "x_axis": -2.7900476455688477,
          "y_axis": 1.0407456159591675,
          "name": "mouse",
          "original": "mouse"
        },
        {
          "x_axis": -3.018948793411255,
          "y_axis": 0.13132251799106598,
          "name": "red",
          "original": "red"
        },
        {
          "x_axis": -4.6628098487854,
          "y_axis": 1.299612283706665,
          "name": "blue",
          "original": "blue"
        },
        {
          "x_axis": -3.5633227825164795,
          "y_axis": 0.1778898686170578,
          "name": "green",
          "original": "green"
        },
        {
          "x_axis": -3.127549409866333,
          "y_axis": 0.4946957230567932,
          "name": "yellow",
          "original": "yellow"
        },
        {
          "x_axis": -4.0959014892578125,
          "y_axis": 0.3415285348892212,
          "name": "water",
          "original": "water"
        },
        {
          "x_axis": -4.049440383911133,
          "y_axis": 1.783280611038208,
          "name": "person",
          "original": "person"
        },
        {
          "x_axis": -3.8789079189300537,
          "y_axis": 2.7418227195739746,
          "name": "family",
          "original": "family"
        },
        {
          "x_axis": -3.6723387241363525,
          "y_axis": 2.3849875926971436,
          "name": "brother",
          "original": "brother"
        },
        {
          "x_axis": -3.6647908687591553,
          "y_axis": 3.161151647567749,
          "name": "sister",
          "original": "sister"
        }
      ]
    },
    {
      "name": "data_0",
      "source": "data-34161eebc7e6103e8e00b60ac821ba4b",
      "transform": [
        {
          "type": "filter",
          "expr": "isValid(datum[\"x_axis\"]) && isFinite(+datum[\"x_axis\"]) && isValid(datum[\"y_axis\"]) && isFinite(+datum[\"y_axis\"])"
        }
      ]
    },
    {
      "name": "data_1",
      "source": "data-52c1f752db2a63c001d356078f606383",
      "transform": [
        {
          "type": "filter",
          "expr": "isValid(datum[\"x_axis\"]) && isFinite(+datum[\"x_axis\"]) && isValid(datum[\"y_axis\"]) && isFinite(+datum[\"y_axis\"])"
        }
      ]
    }
  ],
  "signals": [
    {"name": "concat_0_width", "value": 300},
    {"name": "concat_1_width", "value": 300},
    {
      "name": "unit",
      "value": {},
      "on": [
        {"events": "mousemove", "update": "isTuple(group()) ? group() : unit"}
      ]
    },
    {
      "name": "selector014",
      "update": "{\"x_axis\": selector014_x_axis, \"y_axis\": selector014_y_axis}"
    },
    {"name": "selector014_x_axis"},
    {"name": "selector014_y_axis"},
    {
      "name": "selector015",
      "update": "{\"x_axis\": selector015_x_axis, \"y_axis\": selector015_y_axis}"
    },
    {"name": "selector015_x_axis"},
    {"name": "selector015_y_axis"}
  ],
  "layout": {"padding": 20, "bounds": "full", "align": "each"},
  "marks": [
    {
      "type": "group",
      "name": "concat_0_group",
      "title": {"text": "Dimension 0 vs. Dimension 1", "frame": "group"},
      "style": "cell",
      "encode": {
        "update": {
          "width": {"signal": "concat_0_width"},
          "height": {"signal": "height"}
        }
      },
      "signals": [
        {
          "name": "selector014_x_axis",
          "on": [
            {
              "events": {"signal": "selector014_translate_delta"},
              "update": "panLinear(selector014_translate_anchor.extent_x, -selector014_translate_delta.x / concat_0_width)"
            },
            {
              "events": {"signal": "selector014_zoom_delta"},
              "update": "zoomLinear(domain(\"concat_0_x\"), selector014_zoom_anchor.x, selector014_zoom_delta)"
            },
            {
              "events": [{"source": "scope", "type": "dblclick"}],
              "update": "null"
            }
          ],
          "push": "outer"
        },
        {
          "name": "selector014_y_axis",
          "on": [
            {
              "events": {"signal": "selector014_translate_delta"},
              "update": "panLinear(selector014_translate_anchor.extent_y, selector014_translate_delta.y / height)"
            },
            {
              "events": {"signal": "selector014_zoom_delta"},
              "update": "zoomLinear(domain(\"concat_0_y\"), selector014_zoom_anchor.y, selector014_zoom_delta)"
            },
            {
              "events": [{"source": "scope", "type": "dblclick"}],
              "update": "null"
            }
          ],
          "push": "outer"
        },
        {
          "name": "selector014_tuple",
          "on": [
            {
              "events": [
                {"signal": "selector014_x_axis || selector014_y_axis"}
              ],
              "update": "selector014_x_axis && selector014_y_axis ? {unit: \"concat_0_layer_0\", fields: selector014_tuple_fields, values: [selector014_x_axis,selector014_y_axis]} : null"
            }
          ]
        },
        {
          "name": "selector014_tuple_fields",
          "value": [
            {"field": "x_axis", "channel": "x", "type": "R"},
            {"field": "y_axis", "channel": "y", "type": "R"}
          ]
        },
        {
          "name": "selector014_translate_anchor",
          "value": {},
          "on": [
            {
              "events": [{"source": "scope", "type": "mousedown"}],
              "update": "{x: x(unit), y: y(unit), extent_x: domain(\"concat_0_x\"), extent_y: domain(\"concat_0_y\")}"
            }
          ]
        },
        {
          "name": "selector014_translate_delta",
          "value": {},
          "on": [
            {
              "events": [
                {
                  "source": "window",
                  "type": "mousemove",
                  "consume": true,
                  "between": [
                    {"source": "scope", "type": "mousedown"},
                    {"source": "window", "type": "mouseup"}
                  ]
                }
              ],
              "update": "{x: selector014_translate_anchor.x - x(unit), y: selector014_translate_anchor.y - y(unit)}"
            }
          ]
        },
        {
          "name": "selector014_zoom_anchor",
          "on": [
            {
              "events": [{"source": "scope", "type": "wheel", "consume": true}],
              "update": "{x: invert(\"concat_0_x\", x(unit)), y: invert(\"concat_0_y\", y(unit))}"
            }
          ]
        },
        {
          "name": "selector014_zoom_delta",
          "on": [
            {
              "events": [{"source": "scope", "type": "wheel", "consume": true}],
              "force": true,
              "update": "pow(1.001, event.deltaY * pow(16, event.deltaMode))"
            }
          ]
        },
        {
          "name": "selector014_modify",
          "on": [
            {
              "events": {"signal": "selector014_tuple"},
              "update": "modify(\"selector014_store\", selector014_tuple, true)"
            }
          ]
        }
      ],
      "marks": [
        {
          "name": "concat_0_layer_0_marks",
          "type": "symbol",
          "clip": true,
          "style": ["circle"],
          "interactive": true,
          "from": {"data": "data_0"},
          "encode": {
            "update": {
              "opacity": {"value": 0.7},
              "size": {"value": 60},
              "fill": {"value": "#4c78a8"},
              "tooltip": {
                "signal": "{\"name\": ''+datum[\"name\"], \"original\": ''+datum[\"original\"]}"
              },
              "x": {"scale": "concat_0_x", "field": "x_axis"},
              "y": {"scale": "concat_0_y", "field": "y_axis"},
              "shape": {"value": "circle"}
            }
          }
        },
        {
          "name": "concat_0_layer_1_marks",
          "type": "text",
          "clip": true,
          "style": ["text"],
          "interactive": false,
          "from": {"data": "data_0"},
          "encode": {
            "update": {
              "dx": {"value": -15},
              "dy": {"value": 3},
              "fill": {"value": "black"},
              "x": {"scale": "concat_0_x", "field": "x_axis"},
              "y": {"scale": "concat_0_y", "field": "y_axis"},
              "text": {"signal": "''+datum[\"original\"]"},
              "align": {"value": "center"},
              "baseline": {"value": "middle"}
            }
          }
        }
      ],
      "axes": [
        {
          "scale": "concat_0_x",
          "orient": "bottom",
          "gridScale": "concat_0_y",
          "grid": true,
          "tickCount": {"signal": "ceil(concat_0_width/40)"},
          "domain": false,
          "labels": false,
          "maxExtent": 0,
          "minExtent": 0,
          "ticks": false,
          "zindex": 0
        },
        {
          "scale": "concat_0_y",
          "orient": "left",
          "gridScale": "concat_0_x",
          "grid": true,
          "tickCount": {"signal": "ceil(height/40)"},
          "domain": false,
          "labels": false,
          "maxExtent": 0,
          "minExtent": 0,
          "ticks": false,
          "zindex": 0
        },
        {
          "scale": "concat_0_x",
          "orient": "bottom",
          "grid": false,
          "title": "Dimension 0",
          "labelFlush": true,
          "labelOverlap": true,
          "tickCount": {"signal": "ceil(concat_0_width/40)"},
          "zindex": 0
        },
        {
          "scale": "concat_0_y",
          "orient": "left",
          "grid": false,
          "title": "Dimension 1",
          "labelOverlap": true,
          "tickCount": {"signal": "ceil(height/40)"},
          "zindex": 0
        }
      ]
    },
    {
      "type": "group",
      "name": "concat_1_group",
      "title": {"text": "Dimension 0 vs. Dimension 1", "frame": "group"},
      "style": "cell",
      "encode": {
        "update": {
          "width": {"signal": "concat_1_width"},
          "height": {"signal": "height"}
        }
      },
      "signals": [
        {
          "name": "selector015_x_axis",
          "on": [
            {
              "events": {"signal": "selector015_translate_delta"},
              "update": "panLinear(selector015_translate_anchor.extent_x, -selector015_translate_delta.x / concat_1_width)"
            },
            {
              "events": {"signal": "selector015_zoom_delta"},
              "update": "zoomLinear(domain(\"concat_1_x\"), selector015_zoom_anchor.x, selector015_zoom_delta)"
            },
            {
              "events": [{"source": "scope", "type": "dblclick"}],
              "update": "null"
            }
          ],
          "push": "outer"
        },
        {
          "name": "selector015_y_axis",
          "on": [
            {
              "events": {"signal": "selector015_translate_delta"},
              "update": "panLinear(selector015_translate_anchor.extent_y, selector015_translate_delta.y / height)"
            },
            {
              "events": {"signal": "selector015_zoom_delta"},
              "update": "zoomLinear(domain(\"concat_1_y\"), selector015_zoom_anchor.y, selector015_zoom_delta)"
            },
            {
              "events": [{"source": "scope", "type": "dblclick"}],
              "update": "null"
            }
          ],
          "push": "outer"
        },
        {
          "name": "selector015_tuple",
          "on": [
            {
              "events": [
                {"signal": "selector015_x_axis || selector015_y_axis"}
              ],
              "update": "selector015_x_axis && selector015_y_axis ? {unit: \"concat_1_layer_0\", fields: selector015_tuple_fields, values: [selector015_x_axis,selector015_y_axis]} : null"
            }
          ]
        },
        {
          "name": "selector015_tuple_fields",
          "value": [
            {"field": "x_axis", "channel": "x", "type": "R"},
            {"field": "y_axis", "channel": "y", "type": "R"}
          ]
        },
        {
          "name": "selector015_translate_anchor",
          "value": {},
          "on": [
            {
              "events": [{"source": "scope", "type": "mousedown"}],
              "update": "{x: x(unit), y: y(unit), extent_x: domain(\"concat_1_x\"), extent_y: domain(\"concat_1_y\")}"
            }
          ]
        },
        {
          "name": "selector015_translate_delta",
          "value": {},
          "on": [
            {
              "events": [
                {
                  "source": "window",
                  "type": "mousemove",
                  "consume": true,
                  "between": [
                    {"source": "scope", "type": "mousedown"},
                    {"source": "window", "type": "mouseup"}
                  ]
                }
              ],
              "update": "{x: selector015_translate_anchor.x - x(unit), y: selector015_translate_anchor.y - y(unit)}"
            }
          ]
        },
        {
          "name": "selector015_zoom_anchor",
          "on": [
            {
              "events": [{"source": "scope", "type": "wheel", "consume": true}],
              "update": "{x: invert(\"concat_1_x\", x(unit)), y: invert(\"concat_1_y\", y(unit))}"
            }
          ]
        },
        {
          "name": "selector015_zoom_delta",
          "on": [
            {
              "events": [{"source": "scope", "type": "wheel", "consume": true}],
              "force": true,
              "update": "pow(1.001, event.deltaY * pow(16, event.deltaMode))"
            }
          ]
        },
        {
          "name": "selector015_modify",
          "on": [
            {
              "events": {"signal": "selector015_tuple"},
              "update": "modify(\"selector015_store\", selector015_tuple, true)"
            }
          ]
        }
      ],
      "marks": [
        {
          "name": "concat_1_layer_0_marks",
          "type": "symbol",
          "clip": true,
          "style": ["circle"],
          "interactive": true,
          "from": {"data": "data_1"},
          "encode": {
            "update": {
              "opacity": {"value": 0.7},
              "size": {"value": 60},
              "fill": {"value": "#4c78a8"},
              "tooltip": {
                "signal": "{\"name\": ''+datum[\"name\"], \"original\": ''+datum[\"original\"]}"
              },
              "x": {"scale": "concat_1_x", "field": "x_axis"},
              "y": {"scale": "concat_1_y", "field": "y_axis"},
              "shape": {"value": "circle"}
            }
          }
        },
        {
          "name": "concat_1_layer_1_marks",
          "type": "text",
          "clip": true,
          "style": ["text"],
          "interactive": false,
          "from": {"data": "data_1"},
          "encode": {
            "update": {
              "dx": {"value": -15},
              "dy": {"value": 3},
              "fill": {"value": "black"},
              "x": {"scale": "concat_1_x", "field": "x_axis"},
              "y": {"scale": "concat_1_y", "field": "y_axis"},
              "text": {"signal": "''+datum[\"original\"]"},
              "align": {"value": "center"},
              "baseline": {"value": "middle"}
            }
          }
        }
      ],
      "axes": [
        {
          "scale": "concat_1_x",
          "orient": "bottom",
          "gridScale": "concat_1_y",
          "grid": true,
          "tickCount": {"signal": "ceil(concat_1_width/40)"},
          "domain": false,
          "labels": false,
          "maxExtent": 0,
          "minExtent": 0,
          "ticks": false,
          "zindex": 0
        },
        {
          "scale": "concat_1_y",
          "orient": "left",
          "gridScale": "concat_1_x",
          "grid": true,
          "tickCount": {"signal": "ceil(height/40)"},
          "domain": false,
          "labels": false,
          "maxExtent": 0,
          "minExtent": 0,
          "ticks": false,
          "zindex": 0
        },
        {
          "scale": "concat_1_x",
          "orient": "bottom",
          "grid": false,
          "title": "Dimension 0",
          "labelFlush": true,
          "labelOverlap": true,
          "tickCount": {"signal": "ceil(concat_1_width/40)"},
          "zindex": 0
        },
        {
          "scale": "concat_1_y",
          "orient": "left",
          "grid": false,
          "title": "Dimension 1",
          "labelOverlap": true,
          "tickCount": {"signal": "ceil(height/40)"},
          "zindex": 0
        }
      ]
    }
  ],
  "scales": [
    {
      "name": "concat_0_x",
      "type": "linear",
      "domain": {"data": "data_0", "field": "x_axis"},
      "domainRaw": {"signal": "selector014[\"x_axis\"]"},
      "range": [0, {"signal": "concat_0_width"}],
      "nice": true,
      "zero": true
    },
    {
      "name": "concat_0_y",
      "type": "linear",
      "domain": {"data": "data_0", "field": "y_axis"},
      "domainRaw": {"signal": "selector014[\"y_axis\"]"},
      "range": [{"signal": "height"}, 0],
      "nice": true,
      "zero": true
    },
    {
      "name": "concat_1_x",
      "type": "linear",
      "domain": {"data": "data_1", "field": "x_axis"},
      "domainRaw": {"signal": "selector015[\"x_axis\"]"},
      "range": [0, {"signal": "concat_1_width"}],
      "nice": true,
      "zero": true
    },
    {
      "name": "concat_1_y",
      "type": "linear",
      "domain": {"data": "data_1", "field": "y_axis"},
      "domainRaw": {"signal": "selector015[\"y_axis\"]"},
      "range": [{"signal": "height"}, 0],
      "nice": true,
      "zero": true
    }
  ]
}

vegaEmbed('#vis2', spec2);