/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.Cluster;
import com.sas.services.connection.FailoverCluster;
import com.sas.services.connection.HostPortPair;
import com.sas.services.connection.HostPortSet;
import com.sas.services.connection.Server;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class MetadataClusterUtil {
    private static final Logger logger = Logger.getLogger(MetadataClusterUtil.class);
    private static Properties applicationProperties = null;
    public static final String OPTION_ENCRYPT = "encrypt";
    public static final String OPTION_SSPI_PACKAGE = "sspipackage";
    public static final String OPTION_SSPI_PACKAGE_LIST = "sspipackagelist";
    public static final String OPTION_SSPI_SPN = "sspispn";
    public static final String OPTION_USE_CLUSTER_PROPERTIES = "useclusterproperties";
    private static final String APP_PROPERTY_HOST = "omr_host";
    private static final String APP_PROPERTY_PORT = "omr_port";
    private static final String APP_PROPERTY_HOSTS = "omr_cluster_hosts";
    private static final String APP_PROPERTY_PORTS = "omr_cluster_ports";
    private static final String USE_CLUSTER_PROPERTIES = "sas.metadata.use.cluster.properties";
    private static final boolean useClusterProperties = Boolean.parseBoolean(System.getProperty("sas.metadata.use.cluster.properties"));
    private static final String APP_TABLE_QUERY = "select PROPERTY_NM, PROPERTY_VALUE_TXT from SAS_APPLICATION_PROPERTY where PROPERTYSET_NM= ?";
    private static final String[] DATA_SOURCE_NAMES = new String[]{"java:comp/env/jdbc/SASAPP", "java:comp/env/jdbc/SharedServices", "java:comp/env/sas/jdbc/SharedServices"};

    public static Cluster createCluster(String hosts, String ports, Map<String, String> options) {
        return MetadataClusterUtil.createCluster(HostPortSet.newInstance(hosts, ports), options);
    }

    public static Cluster createCluster(HostPortSet clusterNodes, Map<String, String> options) {
        if (options == null) {
            options = Collections.emptyMap();
        }
        boolean usePropertiesTable = useClusterProperties;
        if (options.containsKey(OPTION_USE_CLUSTER_PROPERTIES)) {
            usePropertiesTable = Boolean.parseBoolean(options.get(OPTION_USE_CLUSTER_PROPERTIES));
        }
        if (usePropertiesTable) {
            if (applicationProperties == null) {
                MetadataClusterUtil.refreshApplicationProperties();
            }
            if (applicationProperties.containsKey(APP_PROPERTY_HOSTS) && applicationProperties.containsKey(APP_PROPERTY_PORTS)) {
                String hosts = applicationProperties.getProperty(APP_PROPERTY_HOSTS);
                String ports = applicationProperties.getProperty(APP_PROPERTY_PORTS);
                HostPortSet nodes = HostPortSet.newInstance(hosts, ports);
                if (clusterNodes == null || clusterNodes.isEmpty() || nodes.intersects(clusterNodes)) {
                    clusterNodes = nodes;
                }
            }
        }
        boolean encrypt = Boolean.parseBoolean(options.get(OPTION_ENCRYPT));
        String sspiSecurityPackage = options.get(OPTION_SSPI_PACKAGE);
        String sspiSecurityPackageList = options.get(OPTION_SSPI_PACKAGE_LIST);
        String sspiSPN = options.get(OPTION_SSPI_SPN);
        Server[] servers = new BridgeServer[clusterNodes.size()];
        int i = 0;
        for (HostPortPair node : clusterNodes) {
            servers[i] = new BridgeServer("0217e202-b560-11db-ad91-001083ff6836", node.getHost(), node.getPort());
            if (encrypt) {
                ((BridgeServer)servers[i]).setEncryptionPolicy("required");
                ((BridgeServer)servers[i]).setEncryptionContent("all");
            }
            servers[i].setAuthService("Host");
            if (sspiSecurityPackage != null && sspiSecurityPackage.length() > 0) {
                servers[i].setSecurityPackage(sspiSecurityPackage);
            } else {
                servers[i].setSecurityPackage("Negotiate");
            }
            if (sspiSecurityPackageList != null && sspiSecurityPackageList.length() > 0) {
                servers[i].setSecurityPackageList(sspiSecurityPackageList);
            }
            if (sspiSPN != null && sspiSPN.length() > 0) {
                servers[i].setSPN(sspiSPN);
            }
            ++i;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating cluster for " + clusterNodes.toString()));
        }
        return new FailoverCluster(servers);
    }

    private static void refreshApplicationProperties() {
        Properties newApplicationProperties = new Properties();
        try {
            InitialContext ic = new InitialContext();
            DataSource dataSource = null;
            for (String dataSourceName : DATA_SOURCE_NAMES) {
                try {
                    dataSource = (DataSource)ic.lookup(dataSourceName);
                    break;
                }
                catch (NamingException e) {
                }
            }
            if (dataSource == null) {
                logger.error((Object)"No data source found for SAS_APPLICATION_PROPERTY table.");
                return;
            }
            Connection connection = dataSource.getConnection();
            PreparedStatement statement = connection.prepareStatement(APP_TABLE_QUERY);
            statement.setString(1, "Environment.Properties");
            ResultSet results = statement.executeQuery();
            while (results.next()) {
                newApplicationProperties.put(results.getString(1), results.getString(2));
            }
            results.close();
            statement.close();
            connection.close();
            ic.close();
            applicationProperties = newApplicationProperties;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Loaded " + Integer.toString(applicationProperties.size()) + " application properties"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error reading SAS_APPLICATION_PROPERTY table.");
            logger.error((Object)("  " + e.getMessage()));
            return;
        }
    }

    public static HostPortSet getClusterHostPortSet() {
        if (!useClusterProperties) {
            return null;
        }
        if (applicationProperties == null) {
            MetadataClusterUtil.refreshApplicationProperties();
        }
        if (applicationProperties == null) {
            return null;
        }
        String hosts = applicationProperties.containsKey(APP_PROPERTY_HOSTS) ? applicationProperties.getProperty(APP_PROPERTY_HOSTS) : applicationProperties.getProperty(APP_PROPERTY_HOST);
        String ports = applicationProperties.containsKey(APP_PROPERTY_PORTS) ? applicationProperties.getProperty(APP_PROPERTY_PORTS) : applicationProperties.getProperty(APP_PROPERTY_PORT);
        return HostPortSet.newInstance(hosts, ports);
    }
}

