/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryKernel;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionFactoryRequest;
import java.util.logging.Logger;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.SystemException;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public abstract class ConnectionFactoryConfiguration
implements Cloneable {
    private boolean _noRedirect;
    private boolean _resolved;

    @SASScope
    public ConnectionFactoryConfiguration() {
        this(false);
    }

    @SASScope
    public ConnectionFactoryConfiguration(boolean noRedirect) {
        this._noRedirect = noRedirect;
    }

    @SASScope
    public boolean isNoRedirect() {
        return this._noRedirect;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || !this.getClass().getName().equals(that.getClass().getName())) {
            return false;
        }
        ConnectionFactoryConfiguration thatConfig = (ConnectionFactoryConfiguration)that;
        boolean thatNoRedirect = thatConfig.isNoRedirect();
        return this._noRedirect == thatNoRedirect;
    }

    public int hashCode() {
        int hc = this.getClass().getName().hashCode();
        if (this._noRedirect) {
            ++hc;
        }
        return hc;
    }

    protected static ConnectionFactoryKernel getKernelFromDelegate(ConnectionFactoryManager manager, ConnectionFactoryConfiguration original, Logger logger, ConnectionFactoryConfiguration delegate) throws ConnectionFactoryException {
        ConnectionFactoryRequest cxfReq = ConnectionFactoryRequest.wrap(manager, original);
        ConnectionFactoryKernel kernel = delegate.getKernel(cxfReq);
        return kernel;
    }

    protected ConnectionFactoryKernel getKernel(ConnectionFactoryManager manager, Logger logger) throws ConnectionFactoryException {
        ConnectionFactoryKernel kernel = ConnectionFactoryConfiguration.getKernelFromDelegate(manager, this, logger, this);
        return kernel;
    }

    @SASScope
    protected final ConnectionFactoryKernel getKernel(ConnectionFactoryRequest cxfReq) throws ConnectionFactoryException {
        try {
            ConnectionFactoryKernel kernel = this.doGetKernel(cxfReq);
            this._resolved = true;
            return kernel;
        }
        catch (SystemException se) {
            throw new ConnectionFactoryException(se);
        }
    }

    @SASScope
    protected ConnectionFactoryKernel doGetKernel(ConnectionFactoryRequest cxfReq) throws ConnectionFactoryException {
        ConnectionFactoryManager manager = cxfReq.getManager();
        ConnectionFactoryConfiguration cxfConfig = cxfReq.getOriginalConfiguration();
        if (cxfConfig == null) {
            cxfConfig = this;
        }
        ConnectionFactoryKernel kernel = this.getKernel(manager, cxfConfig, null);
        return kernel;
    }

    protected ConnectionFactoryKernel getKernel(ConnectionFactoryManager manager, ConnectionFactoryConfiguration cxfConfig, Logger logger) throws ConnectionFactoryException {
        NO_IMPLEMENT no_implement = new NO_IMPLEMENT();
        throw new ConnectionFactoryException(no_implement);
    }

    protected void kernelDestroyed(ConnectionFactoryKernel kernel) {
    }

    @SASScope
    protected final String getLogicalServerName() {
        if (!this._resolved) {
            throw new IllegalStateException();
        }
        String serverName = this.doGetLogicalServerName();
        return serverName;
    }

    @SASScope
    protected String doGetLogicalServerName() {
        String serverName = this.toString();
        return serverName;
    }
}

