/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rio;

import com.sas.rio.IRowCache;
import com.sas.rio.MVARow;
import com.sas.rio.MVARowCache;
import com.sas.rio.MVASQLException;
import com.sas.rio.MVAStatement;
import com.sas.rio.MessageCode;
import com.sas.rio.RIOUtil;
import java.sql.SQLException;

class MVAForwardRowCache
extends MVARowCache
implements IRowCache {
    boolean _useOffsetPositioning = false;

    public MVAForwardRowCache(int hashCode, RIOUtil rioUtil) throws SQLException {
        super(hashCode, rioUtil);
    }

    public MVAForwardRowCache(MVAStatement mvaStatement, String libref, String tableName, String[] password, String options, int bindKey) throws SQLException {
        super(mvaStatement, libref, tableName, password, options, bindKey);
    }

    @Override
    public boolean next() throws SQLException {
        this.moveToCurrentRow();
        if (this._position == MVARowCache.Position.AFTER_LAST) {
            return false;
        }
        if (this.m_maxRows > 0 && this._rowNumber + 1 > this.m_maxRows) {
            this._rowNumber = this.m_maxRows + 1;
            this._position = MVARowCache.Position.AFTER_LAST;
            return false;
        }
        if (this._cacheIndex >= 0 && this._cacheIndex < this.m_rows.size() - 1) {
            ++this._cacheIndex;
            ++this._rowNumber;
            this._position = MVARowCache.Position.VALID_ROW;
            return true;
        }
        if (this._cacheIndex > this.m_rows.size() - 1) {
            this._cacheIndex = this.m_rows.size() - 1;
        }
        if (this._useOffsetPositioning) {
            int offset;
            this._useOffsetPositioning = false;
            int n = offset = this._rowNumber == -1 ? 0 : this._rowNumber;
            if (this.readRecordsWithOffset(this.m_bindKey, this.m_cacheSize, offset)) {
                this._position = MVARowCache.Position.VALID_ROW;
                this._cacheIndex = 0;
                ++this._rowNumber;
                return true;
            }
            this._position = MVARowCache.Position.AFTER_LAST;
            return false;
        }
        if (this.readRecordsWithNfp(this.m_bindKey, this.m_cacheSize)) {
            this._position = MVARowCache.Position.VALID_ROW;
            this._cacheIndex = 0;
            ++this._rowNumber;
            return true;
        }
        this._position = MVARowCache.Position.AFTER_LAST;
        return false;
    }

    @Override
    public void setFetchSize(int size) throws SQLException {
        this.m_cacheSize = size;
        if (this._position == MVARowCache.Position.BEFORE_FIRST || this._position == MVARowCache.Position.AFTER_LAST) {
            this.m_rows.setSize(size);
            return;
        }
        this.m_cacheChangeFlag = true;
        this.m_newCache = size;
    }

    @Override
    public synchronized void insertRow() throws SQLException {
        if (this._updateRow == null) {
            throw new MVASQLException(MessageCode.MVAResultSet_notOnInsertRowError, new Object[0]);
        }
        if (this._updateType == MVARowCache.UpdateType.UPDATE) {
            throw new MVASQLException(MessageCode.MVAResultSet_notOnInsertRowError, new Object[0]);
        }
        this._rioUtil.insertRow(this.m_hashCode, this._columns, this._updateRow);
        this._updateRow = null;
        this._updateType = MVARowCache.UpdateType.NONE;
        this._useOffsetPositioning = true;
    }

    @Override
    public synchronized void deleteRow() throws SQLException {
        if (this._position != MVARowCache.Position.VALID_ROW || this._updateRow != null) {
            throw new MVASQLException(MessageCode.MVAResultSet_invalidRowPosition, new Object[0]);
        }
        MVARow r = (MVARow)this.m_rows.get(this._cacheIndex);
        byte[] bookmarksDelete = r.getBookmark();
        this._rioUtil.deleteRow(this.m_hashCode, bookmarksDelete);
        this._cacheIndex = 0;
        this._position = this.readRecordsWithNfp(this.m_bindKey, this.m_cacheSize) ? MVARowCache.Position.VALID_ROW : MVARowCache.Position.AFTER_LAST;
    }
}

