/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb;

import com.sas.codepolicy.SASScope;
import java.util.Locale;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

@SASScope
public class LoggerFactory {
    private static final LogRecord _severeRecord = new LogRecord(Level.SEVERE, null);
    private static final LogRecord _fineRecord = new LogRecord(Level.FINE, null);
    private static final LogRecord _finerRecord = new LogRecord(Level.FINER, null);
    private static final LogRecord _finestRecord = new LogRecord(Level.FINEST, null);
    private static final char _lParen = '(';
    private static final char _rParen = ')';
    private static final char _comma = ',';
    private static final char _blank = ' ';
    private Logger _logger;

    public LoggerFactory() {
    }

    public LoggerFactory(Logger logger) {
        this._logger = logger;
    }

    public Logger getLogger(String loggerName) {
        Logger logger = this._logger == null ? Logger.getLogger(loggerName) : this._logger;
        return logger;
    }

    public static boolean isLoggable(Logger logger, Level level) {
        LogRecord record = null;
        record = Level.SEVERE.equals(level) ? _severeRecord : (Level.FINE.equals(level) ? _fineRecord : (Level.FINER.equals(level) ? _finerRecord : (Level.FINEST.equals(level) ? _finestRecord : new LogRecord(level, null))));
        boolean result = LoggerFactory.isLoggableRecord(logger, record);
        return result;
    }

    public static boolean isLoggableRecord(Logger logger, LogRecord record) {
        if (logger == null) {
            return false;
        }
        Level level = record.getLevel();
        if (!logger.isLoggable(level)) {
            return false;
        }
        do {
            Handler[] handlerArr = logger.getHandlers();
            for (int i = 0; i < handlerArr.length; ++i) {
                Handler handler = handlerArr[i];
                if (!handler.isLoggable(record)) continue;
                return true;
            }
        } while (logger.getUseParentHandlers() && (logger = logger.getParent()) != null);
        return false;
    }

    public static boolean isLoggableSEVERE(Logger logger) {
        boolean loggable = LoggerFactory.isLoggableRecord(logger, _severeRecord);
        return loggable;
    }

    public static boolean isLoggableFINE(Logger logger) {
        boolean loggable = LoggerFactory.isLoggableRecord(logger, _fineRecord);
        return loggable;
    }

    public static boolean isLoggableFINER(Logger logger) {
        boolean loggable = LoggerFactory.isLoggableRecord(logger, _finerRecord);
        return loggable;
    }

    public static boolean isLoggableFINEST(Logger logger) {
        boolean loggable = LoggerFactory.isLoggableRecord(logger, _finestRecord);
        return loggable;
    }

    public static String formatOrderedPair(char p1, long l1, char p2, long l2) {
        String s1 = Long.toHexString(l1).toUpperCase(Locale.US);
        int s1L = s1.length();
        String s2 = Long.toHexString(l2).toUpperCase(Locale.US);
        int s2L = s2.length();
        int bufL = s1L + s2L + 6;
        StringBuffer buf = new StringBuffer(bufL);
        buf.append('(').append(p1).append(s1).append(',');
        buf.append(p2).append(s2).append(')').append(' ');
        String pair = buf.toString();
        return pair;
    }
}

