/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.MissingValues;
import com.sas.PublicClonable;
import com.sas.SpecialValues;
import com.sas.codepolicy.SASScope;

@SASScope
public class SupportedSpecialValues
implements PublicClonable {
    boolean missingValuesSupported;
    private boolean missingValuesHiddenIfSupported;
    boolean allSupported;
    boolean noneSupported;
    boolean otherSupported;

    public static final SupportedSpecialValues newAllSupported() {
        SupportedSpecialValues specialValues = new SupportedSpecialValues();
        specialValues.setAllSupported(true);
        return specialValues;
    }

    public static final SupportedSpecialValues newMissingValuesSupported() {
        SupportedSpecialValues specialValues = new SupportedSpecialValues();
        specialValues.setMissingValuesSupported(true);
        return specialValues;
    }

    public static final SupportedSpecialValues newOtherSupported() {
        SupportedSpecialValues specialValues = new SupportedSpecialValues();
        specialValues.setOtherSupported(true);
        return specialValues;
    }

    public static final SupportedSpecialValues newNoneSupported() {
        SupportedSpecialValues specialValues = new SupportedSpecialValues();
        specialValues.setNoneSupported(true);
        return specialValues;
    }

    public boolean isAllSupported() {
        return this.allSupported;
    }

    public void setAllSupported(boolean allSupported) {
        this.allSupported = allSupported;
    }

    public boolean isMissingValuesSupported() {
        return this.missingValuesSupported;
    }

    public void setMissingValuesSupported(boolean missingValuesSupported) {
        this.missingValuesSupported = missingValuesSupported;
    }

    public boolean isMissingValuesHiddenIfSupported() {
        return this.missingValuesHiddenIfSupported;
    }

    public void setMissingValuesHiddenIfSupported(boolean missingValuesHiddenIfSupported) {
        this.missingValuesHiddenIfSupported = missingValuesHiddenIfSupported;
    }

    public boolean isOtherSupported() {
        return this.otherSupported;
    }

    public void setOtherSupported(boolean otherSupported) {
        this.otherSupported = otherSupported;
    }

    public boolean isNoneSupported() {
        return this.noneSupported;
    }

    public void setNoneSupported(boolean noneSupported) {
        this.noneSupported = noneSupported;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            IllegalStateException ise = new IllegalStateException();
            ise.initCause(e);
            throw ise;
        }
    }

    public boolean isValueNotSupported(Object value) {
        if (value instanceof MissingValues && !this.isMissingValuesSupported()) {
            return true;
        }
        if (value == SpecialValues.ALL && !this.isAllSupported()) {
            return true;
        }
        return value == SpecialValues.OTHER && !this.isOtherSupported();
    }

    public boolean isValueSupported(Object value) {
        if (value instanceof MissingValues && this.isMissingValuesSupported()) {
            return true;
        }
        if (value == SpecialValues.ALL && this.isAllSupported()) {
            return true;
        }
        return value == SpecialValues.OTHER && this.isOtherSupported();
    }
}

