/*
 * Decompiled with CFR 0.152.
 */
package com.sas.print;

import com.sas.print.RB;
import com.sas.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PrinterUtil {
    public static final String RB_KEY = "PrinterUtil.";
    public static final String PAPER_SIZE_LETTER = "Letter";
    public static final String PAPER_SIZE_A4 = "A4";
    public static final String[] PAPER_SIZE_KEYS = new String[]{"Letter", "A4"};
    private static Map paperSizeToCountriesMap = null;

    private PrinterUtil() {
    }

    public static final synchronized String getDefaultPaperSize(Locale locale, String defaultPaperSize) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String countryCode = locale.getCountry();
        if (paperSizeToCountriesMap == null) {
            paperSizeToCountriesMap = new HashMap();
            for (int i = 0; i < PAPER_SIZE_KEYS.length; ++i) {
                String countries = RB.getStringResource(RB_KEY, PAPER_SIZE_KEYS[i] + ".notrans");
                paperSizeToCountriesMap.put(PAPER_SIZE_KEYS[i], countries);
            }
        }
        if (countryCode == null || countryCode.length() == 0) {
            List possibleCountries = PrinterUtil.getCountriesForLanguage(locale.getLanguage());
            if (possibleCountries.size() == 0) {
                countryCode = locale.getCountry();
            } else if (possibleCountries.size() == 1) {
                countryCode = (String)possibleCountries.get(0);
            } else {
                String firstPaperSize = PrinterUtil.getPaperSize((String)possibleCountries.get(0), null);
                int n = possibleCountries.size();
                for (int i = 1; i < n; ++i) {
                    String paperSize = (String)possibleCountries.get(i);
                    if (Util.equal(firstPaperSize, paperSize)) continue;
                    return defaultPaperSize;
                }
                return firstPaperSize;
            }
        }
        return PrinterUtil.getPaperSize(countryCode, defaultPaperSize);
    }

    private static String getPaperSize(String countryCode, String defaultPaperSize) {
        for (String paperSizeKey : paperSizeToCountriesMap.keySet()) {
            String countries = (String)paperSizeToCountriesMap.get(paperSizeKey);
            if (countries.indexOf(countryCode) == -1) continue;
            return paperSizeKey;
        }
        return defaultPaperSize;
    }

    public static String getPaperSizeLabel(String paperSize, Locale locale) {
        return RB.getStringResource(RB_KEY, paperSize + ".Label.txt", locale);
    }

    private static List getCountriesForLanguage(String language) {
        ArrayList<String> countries = new ArrayList<String>();
        Locale[] allLocales = Locale.getAvailableLocales();
        for (int i = 0; i < allLocales.length; ++i) {
            if (allLocales[i].getCountry() == null || allLocales[i].getCountry().length() == 0 || !language.equals(allLocales[i].getLanguage())) continue;
            countries.add(allLocales[i].getCountry());
        }
        return countries;
    }
}

