/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.crypto;

import java.io.IOException;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SealedObject;

public class SealedString {
    private final SealedObject sealedObject;
    private final Key key;

    public SealedString(String str) {
        this(str.toCharArray());
    }

    public SealedString(char[] str) {
        SealedObject obj = null;
        Key k = null;
        try {
            Cipher cipher = Cipher.getInstance("AES");
            k = SealedString.generateKey();
            cipher.init(1, k);
            obj = new SealedObject((Serializable)str, cipher);
        }
        catch (NoSuchAlgorithmException e) {
            SealedString.handleError(e);
        }
        catch (NoSuchPaddingException e) {
            SealedString.handleError(e);
        }
        catch (InvalidKeyException e) {
            SealedString.handleError(e);
        }
        catch (IllegalBlockSizeException e) {
            SealedString.handleError(e);
        }
        catch (IOException e) {
            SealedString.handleError(e);
        }
        this.key = k;
        this.sealedObject = obj;
    }

    private static void handleError(Throwable t) {
        throw new RuntimeException(t);
    }

    private static Key generateKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(128);
        return keyGenerator.generateKey();
    }

    public char[] getCharacters() {
        try {
            return (char[])this.sealedObject.getObject(this.key);
        }
        catch (InvalidKeyException e) {
            SealedString.handleError(e);
        }
        catch (NoSuchAlgorithmException e) {
            SealedString.handleError(e);
        }
        catch (IOException e) {
            SealedString.handleError(e);
        }
        catch (ClassNotFoundException e) {
            SealedString.handleError(e);
        }
        throw new IllegalStateException("Dead code");
    }
}

