/*
 * Decompiled with CFR 0.152.
 */
package com.sas.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertyChangeSupport
extends java.beans.PropertyChangeSupport {
    protected transient List listeners;
    protected Map children;
    protected Object source;
    static final long serialVersionUID = -6042039294865660725L;

    public PropertyChangeSupport(Object sourceBean) {
        super(sourceBean);
        if (sourceBean == null) {
            throw new IllegalArgumentException();
        }
        this.source = sourceBean;
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    @Override
    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PropertyChangeSupport child;
        if (this.children == null) {
            this.children = new HashMap();
        }
        if ((child = (PropertyChangeSupport)this.children.get(propertyName)) == null) {
            child = new PropertyChangeSupport(this.source);
            this.children.put(propertyName, child);
        }
        child.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.children == null) {
            return;
        }
        PropertyChangeSupport child = (PropertyChangeSupport)this.children.get(propertyName);
        if (child == null) {
            return;
        }
        child.removePropertyChangeListener(listener);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this.source, propertyName, oldValue, newValue);
        this.processPropertyChange(evt);
    }

    @Override
    public void firePropertyChange(PropertyChangeEvent evt) {
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.processPropertyChange(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPropertyChange(PropertyChangeEvent evt) {
        ArrayList targets = null;
        PropertyChangeSupport child = null;
        PropertyChangeSupport propertyChangeSupport = this;
        synchronized (propertyChangeSupport) {
            if (this.listeners != null) {
                targets = new ArrayList(this.listeners.size());
                targets.addAll(this.listeners);
            }
            String propertyName = evt.getPropertyName();
            if (this.children != null && propertyName != null) {
                child = (PropertyChangeSupport)this.children.get(propertyName);
            }
        }
        if (targets != null) {
            for (int i = 0; i < targets.size(); ++i) {
                PropertyChangeListener target = (PropertyChangeListener)targets.get(i);
                target.propertyChange(evt);
            }
        }
        if (child != null) {
            child.processPropertyChange(evt);
        }
    }

    @Override
    public synchronized boolean hasListeners(String propertyName) {
        PropertyChangeSupport child;
        if (this.listeners != null && !this.listeners.isEmpty()) {
            return true;
        }
        if (this.children != null && (child = (PropertyChangeSupport)this.children.get(propertyName)) != null) {
            return child.hasListeners(propertyName);
        }
        return false;
    }

    public synchronized EventListener[] getListeners() {
        if ((this.listeners == null || this.listeners.isEmpty()) && (this.children == null || this.children.isEmpty())) {
            return new EventListener[0];
        }
        int listenerSize = 0;
        if (this.listeners != null) {
            listenerSize = this.listeners.size();
        }
        int childrenSize = 0;
        if (this.children != null) {
            childrenSize = this.children.size();
        }
        ArrayList<EventListener> listenerList = new ArrayList<EventListener>(listenerSize + childrenSize);
        if (this.listeners != null && !this.listeners.isEmpty()) {
            listenerList.addAll(this.listeners);
        }
        if (this.children != null && !this.children.isEmpty()) {
            Collection childrenList = this.children.values();
            for (PropertyChangeSupport child : this.children.values()) {
                listenerList.addAll(Arrays.asList(child.getListeners()));
            }
        }
        EventListener[] listenerArray = new EventListener[listenerList.size()];
        this.listeners.toArray(listenerArray);
        return listenerArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        ArrayList v = null;
        PropertyChangeSupport propertyChangeSupport = this;
        synchronized (propertyChangeSupport) {
            if (this.listeners != null) {
                v = new ArrayList();
                v.addAll(this.listeners);
            }
        }
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                PropertyChangeListener l = (PropertyChangeListener)v.get(i);
                if (!(l instanceof Serializable)) continue;
                s.writeObject(l);
            }
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        Object listenerOrNull;
        s.defaultReadObject();
        while (null != (listenerOrNull = s.readObject())) {
            this.addPropertyChangeListener((PropertyChangeListener)listenerOrNull);
        }
    }
}

