"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthenticateCognitoAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
/**
 * A Listener Action to authenticate with Cognito
 */
class AuthenticateCognitoAction extends elbv2.ListenerAction {
    /**
     * Authenticate using an identity provide (IdP) that is compliant with OpenID Connect (OIDC)
     */
    constructor(options) {
        var _b;
        super({
            type: 'authenticate-cognito',
            authenticateCognitoConfig: {
                userPoolArn: options.userPool.userPoolArn,
                userPoolClientId: options.userPoolClient.userPoolClientId,
                userPoolDomain: options.userPoolDomain.domainName,
                authenticationRequestExtraParams: options.authenticationRequestExtraParams,
                onUnauthenticatedRequest: options.onUnauthenticatedRequest,
                scope: options.scope,
                sessionCookieName: options.sessionCookieName,
                sessionTimeout: (_b = options.sessionTimeout) === null || _b === void 0 ? void 0 : _b.toSeconds().toString(),
            },
        }, options.next);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_elasticloadbalancingv2_actions_AuthenticateCognitoActionProps(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
}
exports.AuthenticateCognitoAction = AuthenticateCognitoAction;
_a = JSII_RTTI_SYMBOL_1;
AuthenticateCognitoAction[_a] = { fqn: "@aws-cdk/aws-elasticloadbalancingv2-actions.AuthenticateCognitoAction", version: "1.155.0" };
//# sourceMappingURL=data:application/json;base64,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