[![Downloads](https://static.pepy.tech/personalized-badge/find-primes?period=total&units=international_system&left_color=lightgrey&right_color=yellowgreen&left_text=Downloads)](https://pepy.tech/project/find-primes)

Find Primes is a library to find all kinds of primes.

**Install**
```shell
pip install --pre --upgrade find-primes
```
**[Twin Primes](https://en.wikipedia.org/wiki/Twin_prime)**

A twin prime is a prime number that is either 2 less or 2 more than another prime number.

Example: Find all twin primes below 1000.
```python
from find_primes import find_twins
print(find_twins(1000))
```

**[Palindrome Primes](https://en.wikipedia.org/wiki/Palindromic_prime)**

A palindrome prime is a prime number that is also a palindrome number.

Example: Find all palindrome primes below 1000.
```python
from find_primes import find_palindromes
print(find_palindromes(1000))
```

Example: Find all palindrome primes below 1000 in base 2.
```python
from find_primes import find_palindromes_base_2
print(find_palindromes(8200)) #return in base 10
```

**[Emirps](https://en.wikipedia.org/wiki/Emirp)**

An emirp is a prime number that results in a different prime when its decimal digits are reversed.

Example: Find all emirps below 1000.
```python
from find_primes import find_reverses
print(find_reverses(1000))
```

**[Primes in Arithmetic Progression](https://en.wikipedia.org/wiki/Primes_in_arithmetic_progression)**

Primes in arithmetic progression are any sequence of at least three prime numbers that are consecutive terms in an arithmetic progression.

Example: Find all primes in arithmetic progression below 1000.
```python
from find_primes import find_arithmetic_prime_progressions
print(find_arithmetic_prime_progressions(100))
```

**[Mersenne Primes](https://en.wikipedia.org/wiki/Mersenne_prime)**

A mersenne prime is a prime number that is one less than a power of two.

Example: Find all mersenne primes below 600000.
```python
from find_primes import find_mersenne
print(find_mersenne(600000))
```

**[Double Mersenne Primes](https://en.wikipedia.org/wiki/Double_Mersenne_number#Double_Mersenne_primes)**

A double mersenne prime is a double mersenne number that is prime.

Example: Find all double mersenne primes below 130.
```python
from find_primes import find_double_mersennes
print(find_double_mersennes(130))
```

**[Fermat Pseudoprimes](https://en.wikipedia.org/wiki/Fermat_pseudoprime)**

A fermat pseudoprime is a pseudoprime that satisfies fermat's little theorem.

Example: Find all fermat pseudoprimes below 1000.
```python
from find_primes import find_fermat_pseudoprimes
print(find_fermat_pseudoprimes(1000))
```

**[Balence Primes](https://en.wikipedia.org/wiki/Balanced_prime)**

A balence prime is a prime number which is equal to the arithmetic mean of the nearest primes above and below.

Example: Find all balence primes below 1000.
```python
from find_primes import find_balences
print(find_balences(1000))
```

**[Carol Primes](https://en.wikipedia.org/wiki/Carol_number#Primes_and_modular_relations)**

A carol prime is a carol number that is prime.

Example: Find all carol primes below 4000.
```python
from find_primes import find_carols
print(find_carols(4000))
```

**[Fibonacci Primes](https://en.wikipedia.org/wiki/Fibonacci_prime)**

A fibonacci prime is a fibonacci number that is prime.

Example: Find all fibonacci primes below 1000.
```python
from find_primes import find_fibonaccis
print(find_fibonaccis(1000))
```

**[Truncatable Primes](https://en.wikipedia.org/wiki/Truncatable_prime)**

A left-truncatable prime is a prime number which remains prime when the leading digit is successively removed.

Example: Find all left-truncatable primes below 140.
```python
from find_primes import find_truncates
print(find_truncates(140, LEFT))
```

A right-truncatable prime is a prime number which remains prime when the last digit is successively removed.

Example: Find all right-truncatable primes below 295.
```python
from find_primes import find_truncates
print(find_truncates(295, RIGHT))
```

A left-and-right-truncatable prime is a prime number which remains prime when the leading and last digits are simultaneously successively removed.

Example: Find all left-and-right-truncatable primes below 3800.
```python
from find_primes import find_truncates
print(find_truncates(3800, BOTH))
```

**[Cuban Primes](https://en.wikipedia.org/wiki/Cuban_prime)**

A cuban prime is a prime number that is a solution to a specific equation involving third powers of x and y.

Example: Find all cuban primes below 440.
```python
from find_primes import find_cubans
print(find_cubans(440))
```

**[Center Polygonal Primes](https://en.wikipedia.org/wiki/Centered_polygonal_number)**

A centered triangular prime is a prime number and a centered figurate number that represents a triangle with a dot in the center and all other dots surrounding the center in successive triangular layers.

Example: Find all centered triangular primes below 1000.
```python
from find_primes import find_center_polygons
print(find_center_polygons(1000, TRIANGLE))
```

A centered square prime is a prime number and a centered figurate number that represents a square with a dot in the center and all other dots surrounding the center in successive square layers.

Example: Find all centered square primes below 1000.
```python
from find_primes import find_center_polygons
print(find_center_polygons(1000, SQUARE))
```

A centered pentagonal prime is a prime number and a centered figurate number that represents a pentagon with a dot in the center and all other dots surrounding the center in successive pentagonal layers.

Example: Find all centered pentagonal primes below 1000.
```python
from find_primes import find_center_polygons
print(find_center_polygons(1000, PENTAGON))
```

A centered hexagonal prime is a prime number and a centered figurate number that represents a hexagon with a dot in the center and all other dots surrounding the center in successive hexagonal layers.

Example: Find all centered hexagonal primes below 1000.
```python
from find_primes import find_center_polygons
print(find_center_polygons(1000, HEXAGON))
```

A centered heptagonal number is a prime number and a centered figurate number that represents a heptagon with a dot in the center and all other dots surrounding the center in successive heptagonal layers.

Example: Find all centered heptagon primes below 1000.
```python
from find_primes import find_center_polygons
print(find_center_polygons(1000, HEPTAGON))
```

**[Wieferich Primes](https://en.wikipedia.org/wiki/Wieferich_prime)**

A wieferich prime is a prime p that <img src="https://latex.vimsky.com/test.image.latex.php?fmt=png&val=%255Cdpi%257B150%257D%2520%255Clarge%2520p%2520%255E%257B2%257D&dl=0" width = "13.5" height = "15"> divides <img src="https://latex.vimsky.com/test.image.latex.php?fmt=png&val=%255Cdpi%257B150%257D%2520%255Clarge%25202%255E%257Bp-1%257D-1&dl=0" height = "15">.

Example: Find all wieferich primes below 4000.
```python
from find_primes import find_wieferiches
print(find_wieferiches(3515))
```

**[Wilson Primes](https://en.wikipedia.org/wiki/Wilson_prime)**

A wilson prime is a prime p that <img src="https://latex.vimsky.com/test.image.latex.php?fmt=png&val=%255Cdpi%257B150%257D%2520%255Clarge%2520p%2520%255E%257B2%257D&dl=0" width = "13.5" height = "15"> divides <img src="https://latex.vimsky.com/test.image.latex.php?fmt=png&val=%255Cdpi%257B150%257D%2520%255Clarge%2520%2528p-1%2529%2521%26plus%3B1&dl=0" width = "80" height = "15">.

Example: Find all wilson primes below 565.
```python
from find_primes import find_wilsons
print(find_wilsons(565))
```

**[Happy Primes](https://en.wikipedia.org/wiki/Happy_number#Happy_primes)**

A happy prime is a prime that is a happy number.

Example: Find all happy primes in base 10 below 195.
```python
from find_primes import find_happys
print(find_happys(195))
```

**[Pierpont Primes](https://en.wikipedia.org/wiki/Pierpont_prime)**

A Pierpont prime is a prime of the form <img src="https://latex.vimsky.com/test.image.latex.php?fmt=png&val=%255Cdpi%257B150%257D%2520%255Clarge%25202%257B%255Eu%257D%255Ccdot3%257B%255Ev%257D%26plus%3B1&dl=0" width = "80" height = "15">.

Example: Find all pierpont primes below 770.
```python
from find_primes import find_pierponts
print(find_pierponts(770))
```

**[Leyland Primes](https://en.wikipedia.org/wiki/Leyland_number#Leyland_primes)**

A leyland prime is a leyland number that is a prime.

Example: Find all leyland primes below 33000.
```python
from find_primes import find_leylands
print(find_leylands(33000))
```

**[Leyland Primes of a Second Kind](https://en.wikipedia.org/wiki/Leyland_number#Leyland_number_of_the_second_kind)**

A leyland prime of a second kind is a leyland number of a second kind that is a prime.

Example: Find all leyland primes of a second kind below 58050.
```python
from find_primes import find_leylands_second_kind
print(find_leylands_second_kind(58050))
```

**[MPQS Method](https://www.rieselprime.de/ziki/Multiple_polynomial_quadratic_sieve)**

The Multiple Polynomial Quadratic Sieve (MPQS) method is a factorization method.

Example: Factor a big number.
```python
from find_primes import factor_mpqs
print(factor_mpqs(2776889953055853600532696901))
```