#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#
#    A simple converter of MISP warning lists to asciidoctor format
#    Copyright (C) 2018 Alexandre Dulaunoy
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.


import os
import json
import argparse

thisDir = os.path.dirname(__file__)

lists = []

pathLists = os.path.join(thisDir, '../lists')

for f in os.listdir(pathLists):
	filename = "{}/{}".format(f,"list.json")
	lists.append(filename)

lists.sort()
for warninglist in lists:
    fullPathLists = os.path.join(pathLists, warninglist)
    with open(fullPathLists) as fp:
        c = json.load(fp)
    title = c['name']
    description = c['description']
    print("- [{}](./lists/{}) - **{}** - _{}_".format(warninglist, warninglist,title,
                                          description))

