#!/usr/bin/env python
# -*- coding: UTF-8 -*-
##############################################################################
#
# PDFgui            by DANSE Diffraction group
#                   Simon J. L. Billinge
#                   (c) 2007 trustees of the Michigan State University.
#                   All rights reserved.
#
# File coded by:    Jiwu Liu, Chris Farrow
#
# See AUTHORS.txt for a list of people who contributed.
# See LICENSE.txt for license information.
#
##############################################################################

# generated by wxGlade 0.9.3 on Fri Jul 19 16:04:33 2019

import wx
from diffpy.pdfgui.gui.pdfpanel import PDFPanel

class OutputPanel(wx.Panel,PDFPanel):
    def __init__(self, *args, **kwds):
        # begin wxGlade: OutputPanel.__init__
        kwds["style"] = kwds.get("style", 0) | wx.TAB_TRAVERSAL
        wx.Panel.__init__(self, *args, **kwds)
        self.outputTextCtrl = wx.TextCtrl(self, wx.ID_ANY, "", style=wx.HSCROLL | wx.TE_MULTILINE | wx.TE_READONLY)

        self.__set_properties()
        self.__do_layout()
        # end wxGlade
        self.__customProperties()

    def __set_properties(self):
        # begin wxGlade: OutputPanel.__set_properties
        pass
        # end wxGlade
        return

    def __do_layout(self):
        # begin wxGlade: OutputPanel.__do_layout
        sizer_1 = wx.BoxSizer(wx.VERTICAL)
        sizer_1.Add(self.outputTextCtrl, 1, wx.ALL | wx.EXPAND, 0)
        self.SetSizer(sizer_1)
        sizer_1.Fit(self)
        self.Layout()
        # end wxGlade

    def __customProperties(self):
        """Set the custom properties."""
        # Set the font to monospace
        ftxt = self.outputTextCtrl.GetFont()
        font = wx.Font(ftxt.GetPointSize(), wx.FONTFAMILY_TELETYPE,
                       ftxt.GetStyle(), ftxt.GetWeight())
        self.outputTextCtrl.SetFont(font)
        return

    def clearText(self):
        """Clear the text from the output control."""
        self.outputTextCtrl.Clear()
        return

    def updateText(self, text):
        """Update the text in the window."""
        self.outputTextCtrl.AppendText(text)
        return

    def refresh(self):
        pass

# end of class OutputPanel
