#
#  Video Editor
#  Video editor with a Python API.
#  Copyright Patrick Huang 2021
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <https://www.gnu.org/licenses/>.
#

from . import types


def save_project(scene: types.Scene, path: str) -> None:
    """
    Saves scene as binary file.
    :param scene: Scene to save. Save the current scene by passing vpy.context.scene
    :param path: Path to save scene.
    """
    with open(path, "wb") as file:
        file.write(b"test")


def open_project(path: str) -> types.Scene:
    """
    Opens binary file as a vpy.types.Scene
    :param path: Path to scene file.
    """
    with open(path, "rb") as file:
        return types.Scene()
