# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['licensecheck']

package_data = \
{'': ['*'], 'licensecheck': ['pypi_licenses/*']}

install_requires = \
['fhconfparser>=2022,<2024',
 'requests>=2.27.1,<3',
 'requirements-parser>=0.5.0,<2',
 'tomli>=2.0.0,<3']

extras_require = \
{'full': ['metprint>=2021,<2023']}

entry_points = \
{'console_scripts': ['licensecheck = licensecheck:cli']}

setup_kwargs = {
    'name': 'licensecheck',
    'version': '2022.0.1',
    'description': 'Output the licenses used by dependencies and check if these are compatible with the project license',
    'long_description': '[![GitHub top language](https://img.shields.io/github/languages/top/FHPythonUtils/LicenseCheck.svg?style=for-the-badge)](../../)\n[![Repository size](https://img.shields.io/github/repo-size/FHPythonUtils/LicenseCheck.svg?style=for-the-badge)](../../)\n[![Issues](https://img.shields.io/github/issues/FHPythonUtils/LicenseCheck.svg?style=for-the-badge)](../../issues)\n[![License](https://img.shields.io/github/license/FHPythonUtils/LicenseCheck.svg?style=for-the-badge)](/LICENSE.md)\n[![Commit activity](https://img.shields.io/github/commit-activity/m/FHPythonUtils/LicenseCheck.svg?style=for-the-badge)](../../commits/master)\n[![Last commit](https://img.shields.io/github/last-commit/FHPythonUtils/LicenseCheck.svg?style=for-the-badge)](../../commits/master)\n[![PyPI Downloads](https://img.shields.io/pypi/dm/licensecheck.svg?style=for-the-badge)](https://pypistats.org/packages/licensecheck)\n[![PyPI Total Downloads](https://img.shields.io/badge/dynamic/json?style=for-the-badge&label=total%20downloads&query=%24.total_downloads&url=https%3A%2F%2Fapi.pepy.tech%2Fapi%2Fprojects%2Flicensecheck)](https://pepy.tech/project/licensecheck)\n[![PyPI Version](https://img.shields.io/pypi/v/licensecheck.svg?style=for-the-badge)](https://pypi.org/project/licensecheck)\n\n<!-- omit in toc -->\n# LicenseCheck\n\n<img src="readme-assets/icons/name.png" alt="Project Icon" width="750">\n\nOutput the licences used by dependencies and check if these are compatible with\nthe project license\n\n<!-- omit in toc -->\n## Table of Contents\n\n- [Examples from the command-line](#examples-from-the-command-line)\n\t- [Without metprint](#without-metprint)\n\t- [With metprint](#with-metprint)\n\t- [Using requirements](#using-requirements)\n\t- [Failing on packages under MIT license](#failing-on-packages-under-mit-license)\n\t- [Custom requirements.txt in json format](#custom-requirementstxt-in-json-format)\n\t- [Poetry with dev requirements](#poetry-with-dev-requirements)\n- [Help](#help)\n- [Configuration Example](#configuration-example)\n\t- [Example 1: pyproject.toml](#example-1-pyprojecttoml)\n\t- [Example 2: licensecheck.json](#example-2-licensecheckjson)\n\t- [Example 3: licensecheck.ini](#example-3-licensecheckini)\n- [Documentation](#documentation)\n- [Install With PIP](#install-with-pip)\n- [Language information](#language-information)\n\t- [Built for](#built-for)\n- [Install Python on Windows](#install-python-on-windows)\n\t- [Chocolatey](#chocolatey)\n\t- [Windows - Python.org](#windows---pythonorg)\n- [Install Python on Linux](#install-python-on-linux)\n\t- [Apt](#apt)\n\t- [Dnf](#dnf)\n- [Install Python on MacOS](#install-python-on-macos)\n\t- [Homebrew](#homebrew)\n\t- [MacOS - Python.org](#macos---pythonorg)\n- [How to run](#how-to-run)\n\t- [Windows](#windows)\n\t- [Linux/ MacOS](#linux-macos)\n- [Download Project](#download-project)\n\t- [Clone](#clone)\n\t\t- [Using The Command Line](#using-the-command-line)\n\t\t- [Using GitHub Desktop](#using-github-desktop)\n\t- [Download Zip File](#download-zip-file)\n- [Community Files](#community-files)\n\t- [Licence](#licence)\n\t- [Changelog](#changelog)\n\t- [Code of Conduct](#code-of-conduct)\n\t- [Contributing](#contributing)\n\t- [Security](#security)\n\t- [Support](#support)\n\t- [Rationale](#rationale)\n\n## Examples from the command-line\n\nSee below for the output if you run `licensecheck` in this directory\n\n### Without metprint\n\n```txt\n>> licensecheck\n┌──────────┬────────────────────┬────────────────────┐\n│Compatible│Package             │License             │\n├──────────┼────────────────────┼────────────────────┤\n│True      │attrs               │MIT License         │\n│True      │certifi             │Mozilla Public Licen│\n│True      │charset-normalizer  │MIT License         │\n│True      │fhconfparser        │MIT License         │\n│True      │idna                │BSD License         │\n│True      │metprint            │MIT License         │\n│True      │requests            │Apache Software Lice│\n│True      │requirements-parser │BSD License         │\n│True      │tomlkit             │MIT License         │\n│True      │urllib3             │MIT License         │\n└──────────┴────────────────────┴────────────────────┘\n```\n\n### With metprint\n\nIf `metprint` is installed the tables look slightly different (note that the\nleftmost symbols are coloured in the terminal)\n\n```txt\n>> licensecheck\n    ┌────────────────────┬──────────────────────────────┐\n    │Package             │License                       │\n    ├────────────────────┼──────────────────────────────┤\n[+] │attrs               │MIT License                   │\n[+] │certifi             │Mozilla Public License 2.0 (MP│\n[+] │charset-normalizer  │MIT License                   │\n[+] │idna                │BSD License                   │\n[+] │metprint            │MIT License                   │\n[+] │requests            │Apache Software License       │\n[+] │requirements-parser │BSD License                   │\n[+] │tomlkit             │MIT License                   │\n[+] │urllib3             │MIT License                   │\n    └────────────────────┴──────────────────────────────┘\n```\n\n### Using requirements\n\n```txt\n>> licensecheck -u requirements\n    ┌────────────────────┬──────────────────────────────┐\n    │Package             │License                       │\n    ├────────────────────┼──────────────────────────────┤\n[+] │fhconfparser        │MIT License                   │\n[+] │metprint            │MIT License                   │\n[+] │pip                 │MIT License                   │\n[+] │requests            │Apache Software License       │\n[+] │requirements-parser │BSD License                   │\n[+] │tomlkit             │MIT License                   │\n    └────────────────────┴──────────────────────────────┘\n```\n\n### Failing on packages under MIT license\n\n```txt\n>> licensecheck --fail-licenses mit\n    ┌────────────────────┬──────────────────────────────┐\n    │Package             │License                       │\n    ├────────────────────┼──────────────────────────────┤\n[-] │attrs               │MIT License                   │\n[+] │certifi             │Mozilla Public License 2.0 (MP│\n[-] │charset-normalizer  │MIT License                   │\n[-] │fhconfparser        │MIT License                   │\n[+] │idna                │BSD License                   │\n[-] │metprint            │MIT License                   │\n[+] │requests            │Apache Software License       │\n[+] │requirements-parser │BSD License                   │\n[-] │tomlkit             │MIT License                   │\n[-] │urllib3             │MIT License                   │\n    └────────────────────┴──────────────────────────────┘\n```\n\n### Custom requirements.txt in json format\n\nAdd optional path to requirements.txt as outlined in https://github.com/FHPythonUtils/LicenseCheck/issues/9#issuecomment-898878228. Eg. `licensecheck --using requirements:c:/path/to/reqs.txt;path/to/other/reqs.txt`\n\n```txt\n>> licensecheck -u \'requirements:requirements.txt;requirements_optional.txt\' -f json\n{\n\t"heading": "# Packages - Find a list of packages below",\n\t"packages": [\n\t\t\t{\n\t\t\t\t\t"name": "fhconfparser",\n\t\t\t\t\t"version": "2021.1.1",\n\t\t\t\t\t"namever": "fhconfparser 2021.1.1",\n\t\t\t\t\t"home_page": "https://github.com/FHPythonUtils/FHConfParser",\n\t\t\t\t\t"author": "FredHappyface",\n\t\t\t\t\t"size": 9241,\n\t\t\t\t\t"license": "MIT License",\n\t\t\t\t\t"license_compat": true\n\t\t\t},\n\t\t\t...\n\t\t\t{\n\t\t\t\t\t"name": "tomlkit",\n\t\t\t\t\t"version": "0.7.2",\n\t\t\t\t\t"namever": "tomlkit 0.7.2",\n\t\t\t\t\t"home_page": "https://github.com/sdispater/tomlkit",\n\t\t\t\t\t"author": "S\\u00e9bastien Eustace",\n\t\t\t\t\t"size": 11653,\n\t\t\t\t\t"license": "MIT License",\n\t\t\t\t\t"license_compat": true\n\t\t\t}\n\t]\n}\n```\n\n### Poetry with dev requirements\n\nAdd `-u poetry:dev` to command-line to include dev packages (excluded by default)\n\n```txt\n>> licensecheck -u poetry:dev\n    ┌────────────────────┬──────────────────────────────┐\n    │Package             │License                       │\n    ├────────────────────┼──────────────────────────────┤\n[+] │attrs               │MIT License                   │\n[+] │certifi             │Mozilla Public License 2.0 (MP│\n[+] │charset-normalizer  │MIT License                   │\n[+] │idna                │BSD License                   │\n[+] │metprint            │MIT License                   │\n[+] │requests            │Apache Software License       │\n[+] │requirements-parser │BSD License                   │\n[+] │tomlkit             │MIT License                   │\n[+] │urllib3             │MIT License                   │\n    └────────────────────┴──────────────────────────────┘\n```\n\n## Help\n\n```txt\nusage: __main__.py [-h] [--format FORMAT] [--file FILE] [--using USING]\n                   [--ignore-packages IGNORE_PACKAGES [IGNORE_PACKAGES ...]]\n                   [--fail-packages FAIL_PACKAGES [FAIL_PACKAGES ...]]\n                   [--ignore-licenses IGNORE_LICENSES [IGNORE_LICENSES ...]]\n                   [--fail-licenses FAIL_LICENSES [FAIL_LICENSES ...]] [--zero]\n\nOutput the licenses used by dependencies and check if these are compatible with the project license.\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --format FORMAT, -f FORMAT\n                        Output format. one of: json, markdown, csv, ansi, simple. default=simple\n  --file FILE, -o FILE  Filename to write to (omit for stdout)\n  --using USING, -u USING\n                        Environment to use e.g. requirements.txt. one of: requirements, poetry. default=poetry\n  --ignore-packages IGNORE_PACKAGES [IGNORE_PACKAGES ...]\n                        a list of packages to ignore (compat=True)\n  --fail-packages FAIL_PACKAGES [FAIL_PACKAGES ...]\n                        a list of packages to fail (compat=False)\n  --ignore-licenses IGNORE_LICENSES [IGNORE_LICENSES ...]\n                        a list of licenses to ignore (skipped, compat may still be False)\n  --fail-licenses FAIL_LICENSES [FAIL_LICENSES ...]\n                        a list of licenses to fail (compat=False)\n  --zero, -0            Return non zero exit code if an incompatible license is found\n```\n\nYou can also import this into your own project and use any of the functions\nin the DOCS\n\n## Configuration Example\n\nConfiguration files are parsed in the following order: `pyproject.toml`,\n`setup.cfg`, `licensecheck.toml`, `licensecheck.json`, `licensecheck.ini`,\n`~/licensecheck.toml`, `~/licensecheck.json`, `~/licensecheck.ini`\n\n- ⚠ All config files are parsed, however configuration defined in previous files takes precedent\n\nAdd optional path to requirements.txt as outlined in\nhttps://github.com/FHPythonUtils/LicenseCheck/issues/9#issuecomment-898878228\nfor example: `licensecheck --using requirements:c:/path/to/reqs.txt;path/to/other/reqs.txt`\n\n### Example 1: pyproject.toml\n\nThe following config is equivalent to `licensecheck -u \'requirements:requirements.txt;requirements_optional.txt\' -f json`\n\n```toml\n[tool.licensecheck]\nusing = "requirements:requirements.txt;requirements_optional.txt"\nformat = "json"\n```\n\n### Example 2: licensecheck.json\n\nThe following config is equivalent to `licensecheck -u \'requirements:requirements.txt;requirements_optional.txt\' -f json`\n\n```json\n{\n\t"tool": {\n\t\t"licensecheck": {\n\t\t\t"using": "requirements:requirements.txt;requirements_optional.txt",\n\t\t\t"format": "json"\n\t\t}\n\t}\n}\n```\n\n### Example 3: licensecheck.ini\n\nThe following config is equivalent to `licensecheck -u \'requirements:requirements.txt;requirements_optional.txt\' -f json`\n\n```ini\n[licensecheck]\nusing = "requirements:requirements.txt;requirements_optional.txt"\nformat = "json"\n```\n\n## Documentation\n\nSee the [Docs](/DOCS/) for more information.\n\n## Install With PIP\n\n```python\npip install licensecheck\n```\n\nHead to https://pypi.org/project/licensecheck/ for more info\n\n## Language information\n\n### Built for\n\nThis program has been written for Python versions 3.7 - 3.10 and has been tested with both 3.7 and\n3.10\n\n## Install Python on Windows\n\n### Chocolatey\n\n```powershell\nchoco install python\n```\n\n### Windows - Python.org\n\nTo install Python, go to https://www.python.org/downloads/windows/ and download the latest\nversion.\n\n## Install Python on Linux\n\n### Apt\n\n```bash\nsudo apt install python3.x\n```\n\n### Dnf\n\n```bash\nsudo dnf install python3.x\n```\n\n## Install Python on MacOS\n\n### Homebrew\n\n```bash\nbrew install python@3.x\n```\n\n### MacOS - Python.org\n\nTo install Python, go to https://www.python.org/downloads/macos/ and download the latest\nversion.\n\n## How to run\n\n### Windows\n\n- Module\n\t`py -3.x -m [module]` or `[module]` (if module installs a script)\n\n- File\n\t`py -3.x [file]` or `./[file]`\n\n### Linux/ MacOS\n\n- Module\n\t`python3.x -m [module]` or `[module]` (if module installs a script)\n\n- File\n\t`python3.x [file]` or `./[file]`\n\n## Download Project\n\n### Clone\n\n#### Using The Command Line\n\n1. Press the Clone or download button in the top right\n2. Copy the URL (link)\n3. Open the command line and change directory to where you wish to\nclone to\n4. Type \'git clone\' followed by URL in step 2\n\t```bash\n\tgit clone https://github.com/FHPythonUtils/LicenseCheck\n\t```\n\nMore information can be found at\nhttps://help.github.com/en/articles/cloning-a-repository\n\n#### Using GitHub Desktop\n\n1. Press the Clone or download button in the top right\n2. Click open in desktop\n3. Choose the path for where you want and click Clone\n\nMore information can be found at\nhttps://help.github.com/en/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop\n\n### Download Zip File\n\n1. Download this GitHub repository\n2. Extract the zip archive\n3. Copy/ move to the desired location\n\n## Community Files\n\n### Licence\n\nMIT License\nCopyright (c) FredHappyface\n(See the [LICENSE](/LICENSE.md) for more information.)\n\n### Changelog\n\nSee the [Changelog](/CHANGELOG.md) for more information.\n\n### Code of Conduct\n\nOnline communities include people from many backgrounds. The *Project*\ncontributors are committed to providing a friendly, safe and welcoming\nenvironment for all. Please see the\n[Code of Conduct](https://github.com/FHPythonUtils/.github/blob/master/CODE_OF_CONDUCT.md)\n for more information.\n\n### Contributing\n\nContributions are welcome, please see the\n[Contributing Guidelines](https://github.com/FHPythonUtils/.github/blob/master/CONTRIBUTING.md)\nfor more information.\n\n### Security\n\nThank you for improving the security of the project, please see the\n[Security Policy](https://github.com/FHPythonUtils/.github/blob/master/SECURITY.md)\nfor more information.\n\n### Support\n\nThank you for using this project, I hope it is of use to you. Please be aware that\nthose involved with the project often do so for fun along with other commitments\n(such as work, family, etc). Please see the\n[Support Policy](https://github.com/FHPythonUtils/.github/blob/master/SUPPORT.md)\nfor more information.\n\n### Rationale\n\nThe rationale acts as a guide to various processes regarding projects such as\nthe versioning scheme and the programming styles used. Please see the\n[Rationale](https://github.com/FHPythonUtils/.github/blob/master/RATIONALE.md)\nfor more information.\n',
    'author': 'FredHappyface',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/FHPythonUtils/LicenseCheck',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
