# Generated by Django 2.2 on 2019-07-09 17:35

import django.contrib.gis.db.models.fields
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("anss", "0004_auto_20190709_0943"),
    ]

    operations = [
        migrations.AlterField(
            model_name="feedearthquake",
            name="alert",
            field=models.CharField(
                blank=True,
                help_text="The alert level from the PAGER earthquake impact scale",
                max_length=5000,
                verbose_name="alert level",
            ),
        ),
        migrations.AlterField(
            model_name="feedearthquake",
            name="cdi",
            field=models.FloatField(
                help_text="The maximum reported intensity for the event. Computed by DYFI. While typically reported as a roman numeral, for the purposes of this API, intensity is expected as the decimal equivalent of the roman numeral",
                null=True,
                verbose_name="community decimal intensity",
            ),
        ),
        migrations.AlterField(
            model_name="feedearthquake",
            name="code",
            field=models.CharField(
                blank=True,
                help_text="An identifying code assigned by - and unique from - the corresponding source for the event.",
                max_length=5000,
                verbose_name="unique ID",
            ),
        ),
        migrations.AlterField(
            model_name="feedearthquake",
            name="depth",
            field=models.FloatField(
                help_text="Depth of the event in kilometers", null=True
            ),
        ),
        migrations.AlterField(
            model_name="feedearthquake",
            name="dmin",
            field=models.FloatField(
                help_text="Horizontal distance from the epicenter to the nearest station (in degrees). 1 degree is approximately 111.2 kilometers. In general, the smaller this number, the more reliable is the calculated depth of the earthquake.",
                null=True,
                verbose_name="nearest seismic station",
            ),
        ),
        migrations.AlterField(
            model_name="feedearthquake",
            name="feed",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="anss.Feed",
                verbose_name="archived source",
            ),
        ),
        migrations.AlterField(
            model_name="feedearthquake",
            name="felt",
            field=models.IntegerField(
                help_text="The total number of felt reports submitted to the DYFI? system",
                null=True,
                verbose_name="how many felt it?",
            ),
        ),
        migrations.AlterField(
            model_name="feedearthquake",
            name="gap",
            field=models.FloatField(
                help_text="The largest azimuthal gap between azimuthally adjacent stations (in degrees). In general, the smaller this number, the more reliable is the calculated horizontal position of the earthquake. Earthquake locations in which the azimuthal gap exceeds 180 degrees typically have large location and depth uncertainties.",
                null=True,
                verbose_name="largest azimuthal gap",
            ),
        ),
        migrations.AlterField(
            model_name="feedearthquake",
            name="ids",
            field=models.CharField(
                blank=True,
                help_text="A comma-separated list of event ids that are associated to an event.",
                max_length=5000,
                verbose_name="identifiers",
            ),
        ),
        migrations.AlterField(
            model_name="feedearthquake",
            name="mag",
            field=models.FloatField(null=True, verbose_name="magnitude"),
        ),
        migrations.AlterField(
            model_name="feedearthquake",
            name="magType",
            field=models.CharField(
                blank=True,
                help_text="The method or algorithm used to calculate the preferred magnitude for the event.",
                max_length=5000,
                verbose_name="magnitude type",
            ),
        ),
        migrations.AlterField(
            model_name="feedearthquake",
            name="mmi",
            field=models.FloatField(
                help_text="The maximum estimated instrumental intensity for the event. Computed by ShakeMap. While typically reported as a roman numeral, for the purposes of this API, intensity is expected as the decimal equivalent of the roman numeral.",
                null=True,
                verbose_name="Maximum Modified Mercalli Intensity",
            ),
        ),
        migrations.AlterField(
            model_name="feedearthquake",
            name="net",
            field=models.CharField(
                blank=True,
                help_text="The ID of a data contributor. Identifies the network considered to be the preferred source of information for this event.",
                max_length=5000,
                verbose_name="network ID",
            ),
        ),
        migrations.AlterField(
            model_name="feedearthquake",
            name="nst",
            field=models.IntegerField(
                help_text="The total number of seismic stations used to determine earthquake location",
                null=True,
                verbose_name="seismic stations",
            ),
        ),
        migrations.AlterField(
            model_name="feedearthquake",
            name="place",
            field=models.CharField(
                blank=True, help_text="Description of the epicenter", max_length=5000
            ),
        ),
        migrations.AlterField(
            model_name="feedearthquake",
            name="point",
            field=django.contrib.gis.db.models.fields.PointField(
                null=True, srid=4326, verbose_name="epicenter"
            ),
        ),
        migrations.AlterField(
            model_name="feedearthquake",
            name="rms",
            field=models.FloatField(
                help_text="The root-mean-square (RMS) travel time residual, in sec, using all weights. This parameter provides a measure of the fit of the observed arrival times to the predicted arrival times for this location. Smaller numbers reflect a better fit of the data. The value is dependent on the accuracy of the velocity model used to compute the earthquake location, the quality weights assigned to the arrival time data, and the procedure used to locate the earthquake.",
                null=True,
                verbose_name="root mean squared",
            ),
        ),
        migrations.AlterField(
            model_name="feedearthquake",
            name="sig",
            field=models.IntegerField(
                help_text="A number describing how significant the event is. Larger numbers indicate a more significant event. This value is determined on a number of factors, including: magnitude, maximum MMI, felt reports, and estimated impact.",
                null=True,
                verbose_name="significance",
            ),
        ),
        migrations.AlterField(
            model_name="feedearthquake",
            name="sources",
            field=models.CharField(
                blank=True,
                help_text="A comma-separated list of network contributors",
                max_length=5000,
                verbose_name="network sources",
            ),
        ),
        migrations.AlterField(
            model_name="feedearthquake",
            name="status",
            field=models.CharField(
                blank=True,
                help_text="Indicates whether the event has been reviewed by a human. Status is either automatic or reviewed. Automatic events are directly posted by automatic processing systems and have not been verified or altered by a human. Reviewed events have been looked at by a human. The level of review can range from a quick validity check to a careful reanalysis of the eventself.",
                max_length=5000,
            ),
        ),
        migrations.AlterField(
            model_name="feedearthquake",
            name="time",
            field=models.BigIntegerField(
                help_text="Time when the event occurred. Times are reported in milliseconds since the epoch.",
                null=True,
                verbose_name="occurred at (UNIX)",
            ),
        ),
        migrations.AlterField(
            model_name="feedearthquake",
            name="title",
            field=models.CharField(
                blank=True,
                help_text="a summary of the event",
                max_length=5000,
                verbose_name="description",
            ),
        ),
        migrations.AlterField(
            model_name="feedearthquake",
            name="tsunami",
            field=models.IntegerField(
                help_text="This flag is set to 1 for large events in oceanic regions and 0 otherwise. The existence or value of this flag does not indicate if a tsunami actually did or will exist.",
                null=True,
                verbose_name="tsunami warning",
            ),
        ),
        migrations.AlterField(
            model_name="feedearthquake",
            name="type",
            field=models.CharField(
                blank=True,
                help_text="Type of seismic event",
                max_length=5000,
                verbose_name="event type",
            ),
        ),
        migrations.AlterField(
            model_name="feedearthquake",
            name="types",
            field=models.CharField(
                blank=True,
                help_text="A comma-separated list of product types associated to this event",
                max_length=5000,
                verbose_name="product types",
            ),
        ),
        migrations.AlterField(
            model_name="feedearthquake",
            name="tz",
            field=models.IntegerField(
                help_text="Timezone offset from UTC in minutes at the event epicenter",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="feedearthquake",
            name="updated",
            field=models.BigIntegerField(
                help_text="Time when the event was most recently updated. Times are reported in milliseconds since the epoch.",
                null=True,
                verbose_name="updated at (UNIX)",
            ),
        ),
        migrations.AlterField(
            model_name="feedearthquake",
            name="usgs_id",
            field=models.CharField(
                blank=True,
                help_text="A composite identifier that combines the source network and the earthquake.",
                max_length=5000,
                verbose_name="USGS ID",
            ),
        ),
    ]
