# Generated by Django 2.2 on 2019-07-09 05:45

import django.contrib.gis.db.models.fields
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Feed",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "archived_datetime",
                    models.DateTimeField(
                        help_text="The time the feed was pulled.", null=True
                    ),
                ),
                (
                    "type",
                    models.CharField(
                        choices=[("m1", "Magnitude > 1.0")], max_length=500
                    ),
                ),
                (
                    "format",
                    models.CharField(choices=[("geojson", "GeoJSON")], max_length=500),
                ),
                (
                    "timeframe",
                    models.CharField(
                        choices=[("one-hour", "One hour")], max_length=500
                    ),
                ),
                ("content", models.FileField(upload_to="")),
                ("generated", models.BigIntegerField(null=True)),
                ("url", models.CharField(blank=True, max_length=5000)),
                ("title", models.CharField(blank=True, max_length=5000)),
                ("api", models.CharField(blank=True, max_length=5000)),
                ("count", models.IntegerField(null=True)),
                ("status", models.IntegerField(null=True)),
            ],
            options={
                "ordering": ("-archived_datetime",),
                "get_latest_by": "archived_datetime",
            },
        ),
        migrations.CreateModel(
            name="FeedEarthquake",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("mag", models.FloatField(null=True)),
                ("place", models.CharField(blank=True, max_length=5000)),
                ("time", models.BigIntegerField(null=True)),
                ("updated", models.BigIntegerField(null=True)),
                ("tz", models.IntegerField(null=True)),
                ("url", models.CharField(blank=True, max_length=5000)),
                ("detail", models.CharField(blank=True, max_length=5000)),
                ("felt", models.IntegerField(null=True)),
                ("cdi", models.FloatField(null=True)),
                ("mmi", models.FloatField(null=True)),
                ("alert", models.CharField(blank=True, max_length=5000)),
                ("status", models.CharField(blank=True, max_length=5000)),
                ("tsunami", models.IntegerField(null=True)),
                ("sig", models.IntegerField(null=True)),
                ("net", models.CharField(blank=True, max_length=5000)),
                ("code", models.CharField(blank=True, max_length=5000)),
                ("ids", models.CharField(blank=True, max_length=5000)),
                ("sources", models.CharField(blank=True, max_length=5000)),
                ("types", models.CharField(blank=True, max_length=5000)),
                ("nst", models.IntegerField(null=True)),
                ("dmin", models.FloatField(null=True)),
                ("rms", models.FloatField(null=True)),
                ("gap", models.FloatField(null=True)),
                ("magType", models.CharField(blank=True, max_length=5000)),
                ("type", models.CharField(blank=True, max_length=5000)),
                ("title", models.CharField(blank=True, max_length=5000)),
                ("depth", models.FloatField(null=True)),
                (
                    "point",
                    django.contrib.gis.db.models.fields.PointField(
                        null=True, srid=4326
                    ),
                ),
                ("usgs_id", models.CharField(blank=True, max_length=5000)),
                (
                    "feed",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="anss.Feed"
                    ),
                ),
            ],
            options={
                "ordering": ("-feed_id", "-time"),
            },
        ),
    ]
