/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.plantuml.graphic.SpecialText;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.AbstractCommonUGraphic;
import net.sourceforge.plantuml.ugraphic.Scalable;
import net.sourceforge.plantuml.ugraphic.UComment;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public abstract class AbstractUGraphic<O>
extends AbstractCommonUGraphic {
    private final O graphic;
    private final Map<Class<? extends UShape>, UDriver<O>> drivers = new HashMap<Class<? extends UShape>, UDriver<O>>();

    public AbstractUGraphic(HColor defaultBackground, ColorMapper colorMapper, StringBounder stringBounder, O graphic) {
        super(Objects.requireNonNull(defaultBackground), colorMapper, stringBounder);
        this.graphic = graphic;
    }

    protected AbstractUGraphic(AbstractUGraphic<O> other) {
        super(other);
        this.graphic = other.graphic;
    }

    protected final O getGraphicObject() {
        return this.graphic;
    }

    protected boolean manageHiddenAutomatically() {
        return true;
    }

    protected final void registerDriver(Class<? extends UShape> cl, UDriver<O> driver) {
        this.drivers.put(cl, driver);
    }

    @Override
    public final void draw(UShape shape) {
        if (shape instanceof SpecialText) {
            ((SpecialText)shape).getTitle().drawU(this);
            return;
        }
        if (shape instanceof UEmpty) {
            return;
        }
        if (shape instanceof UComment) {
            this.drawComment((UComment)shape);
            return;
        }
        UDriver<O> driver = this.drivers.get(shape.getClass());
        if (driver == null) {
            throw new UnsupportedOperationException(shape.getClass().toString() + " " + this.getClass());
        }
        if (this.getParam().isHidden() && this.manageHiddenAutomatically()) {
            return;
        }
        this.beforeDraw();
        if (shape instanceof Scalable) {
            double scale = this.getParam().getScale();
            shape = ((Scalable)((Object)shape)).getScaled(scale);
            driver.draw(shape, this.getTranslateX(), this.getTranslateY(), this.getColorMapper(), this.getParam(), this.graphic);
        } else {
            driver.draw(shape, this.getTranslateX(), this.getTranslateY(), this.getColorMapper(), this.getParam(), this.graphic);
        }
        this.afterDraw();
    }

    protected void drawComment(UComment shape) {
    }

    protected void beforeDraw() {
    }

    protected void afterDraw() {
    }
}

