/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.preproc.FileWithSuffix;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc2.PreprocessorUtils;
import net.sourceforge.plantuml.security.SURL;
import net.sourceforge.plantuml.theme.ThemeUtils;
import net.sourceforge.plantuml.tim.Eater;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.EaterExceptionLocated;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TMemory;

public class EaterTheme
extends Eater {
    private String realName;
    private String name;
    private String from;
    private TContext context;

    public EaterTheme(StringLocated s) {
        super(s);
    }

    @Override
    public void analyze(TContext context, TMemory memory) throws EaterException, EaterExceptionLocated {
        this.skipSpaces();
        this.checkAndEatChar("!theme");
        this.skipSpaces();
        this.name = this.eatAllToEnd();
        int x = this.name.toLowerCase().indexOf(" from ");
        if (x != -1) {
            this.from = this.name.substring(x + " from ".length());
            this.name = this.name.substring(0, x);
            this.context = context;
        }
        this.realName = context.applyFunctionsAndVariables(memory, this.getLineLocation(), this.name);
    }

    public final ReadLine getTheme() throws EaterException {
        if (this.from == null) {
            ReadLine reader = ThemeUtils.getReaderTheme(this.realName);
            return reader;
        }
        if (this.from.startsWith("http://") || this.from.startsWith("https://")) {
            SURL url = SURL.create(ThemeUtils.getFullPath(this.from, this.realName));
            if (url == null) {
                throw EaterException.located("Cannot open URL");
            }
            try {
                return PreprocessorUtils.getReaderInclude(url, this.getLineLocation(), StandardCharsets.UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                throw EaterException.located("Cannot decode charset");
            }
        }
        try {
            FileWithSuffix file = this.context.getFileWithSuffix(this.from, this.realName);
            return ReadLineReader.create(file.getReader(StandardCharsets.UTF_8), "theme " + this.realName);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw EaterException.located("Cannot load " + this.realName);
        }
    }

    public String getName() {
        return this.name;
    }
}

