# Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
# with the License. A copy of the License is located at http://aws.amazon.com/apache2.0/
# or in the "LICENSE.txt" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
# OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions and
# limitations under the License.

# Generated by OpenAPI Generator (python-flask)

import sys

if sys.version_info < (3, 7):
    import typing

    def is_generic(klass):
        """Determine whether klass is a generic class."""
        return isinstance(klass, typing.GenericMeta)

    def is_dict(klass):
        """Determine whether klass is a Dict."""
        return klass.__extra__ == dict

    def is_list(klass):
        """Determine whether klass is a List."""
        return klass.__extra__ == list


else:

    def is_generic(klass):
        """Determine whether klass is a generic class."""
        return hasattr(klass, "__origin__")

    def is_dict(klass):
        """Determine whether klass is a Dict."""
        return klass.__origin__ == dict

    def is_list(klass):
        """Determine whether klass is a List."""
        return klass.__origin__ == list
