# Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
# with the License. A copy of the License is located at http://aws.amazon.com/apache2.0/
# or in the "LICENSE.txt" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
# OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions and
# limitations under the License.

# pylint: disable=R0801


from datetime import datetime
from typing import List

from pcluster.api import util
from pcluster.api.models.base_model_ import Model
from pcluster.api.models.cloud_formation_stack_status import CloudFormationStackStatus
from pcluster.api.models.ec2_ami_info import Ec2AmiInfo
from pcluster.api.models.image_build_status import ImageBuildStatus
from pcluster.api.models.image_builder_image_status import ImageBuilderImageStatus
from pcluster.api.models.image_configuration_structure import ImageConfigurationStructure
from pcluster.api.models.tag import Tag


class DescribeImageResponseContent(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(
        self,
        image_configuration=None,
        image_id=None,
        imagebuilder_image_status=None,
        imagebuilder_image_status_reason=None,
        creation_time=None,
        image_build_status=None,
        image_build_logs_arn=None,
        cloudformation_stack_creation_time=None,
        cloudformation_stack_status=None,
        cloudformation_stack_status_reason=None,
        cloudformation_stack_arn=None,
        cloudformation_stack_tags=None,
        region=None,
        ec2_ami_info=None,
        version=None,
    ):
        """DescribeImageResponseContent - a model defined in OpenAPI

        :param image_configuration: The image_configuration of this DescribeImageResponseContent.
        :type image_configuration: ImageConfigurationStructure
        :param image_id: The image_id of this DescribeImageResponseContent.
        :type image_id: str
        :param imagebuilder_image_status: The imagebuilder_image_status of this DescribeImageResponseContent.
        :type imagebuilder_image_status: ImageBuilderImageStatus
        :param imagebuilder_image_status_reason: The imagebuilder_image_status_reason
                                                 of this DescribeImageResponseContent.
        :type imagebuilder_image_status_reason: str
        :param creation_time: The creation_time of this DescribeImageResponseContent.
        :type creation_time: datetime
        :param image_build_status: The image_build_status of this DescribeImageResponseContent.
        :type image_build_status: ImageBuildStatus
        :param cloudformation_stack_status: The cloudformation_stack_status of this DescribeImageResponseContent.
        :type cloudformation_stack_status: CloudFormationStackStatus
        :param cloudformation_stack_status_reason: The cloudformation_stack_status_reason
                                                   of this DescribeImageResponseContent.
        :type cloudformation_stack_status_reason: str
        :param cloudformation_stack_arn: The cloudformation_stack_arn of this DescribeImageResponseContent.
        :type cloudformation_stack_arn: str
        :param region: The region of this DescribeImageResponseContent.
        :type region: str
        :param ec2_ami_info: The ec2_ami_info of this DescribeImageResponseContent.
        :param cloudformation_stack_creation_time: The cloudformation_stack_creation_time of this
                                                   DescribeImageResponseContent.
        :type cloudformation_stack_creation_time: datetime
        :param cloudformation_stack_tags: The cloudformation_stack_tags of this DescribeImageResponseContent.
        :type cloudformation_stack_tags: List[Tag]
        :param image_build_logs_arn: The image_build_logs_arn of this DescribeImageResponseContent.
        :type image_build_logs_arn: str
        :type ec2_ami_info: Ec2AmiInfo
        :param version: The version of this DescribeImageResponseContent.
        :type version: str
        """
        self.openapi_types = {
            "image_configuration": ImageConfigurationStructure,
            "image_id": str,
            "imagebuilder_image_status": ImageBuilderImageStatus,
            "imagebuilder_image_status_reason": str,
            "creation_time": datetime,
            "image_build_status": ImageBuildStatus,
            "cloudformation_stack_status": CloudFormationStackStatus,
            "cloudformation_stack_status_reason": str,
            "cloudformation_stack_arn": str,
            "region": str,
            "ec2_ami_info": Ec2AmiInfo,
            "version": str,
            "cloudformation_stack_tags": List[Tag],
            "image_build_logs_arn": str,
            "cloudformation_stack_creation_time": datetime,
        }

        self.attribute_map = {
            "image_configuration": "imageConfiguration",
            "image_id": "imageId",
            "imagebuilder_image_status": "imagebuilderImageStatus",
            "imagebuilder_image_status_reason": "imagebuilderImageStatusReason",
            "cloudformation_stack_tags": "cloudformationStackTags",
            "image_build_logs_arn": "imageBuildLogsArn",
            "creation_time": "creationTime",
            "image_build_status": "imageBuildStatus",
            "cloudformation_stack_creation_time": "cloudformationStackCreationTime",
            "cloudformation_stack_status": "cloudformationStackStatus",
            "cloudformation_stack_status_reason": "cloudformationStackStatusReason",
            "cloudformation_stack_arn": "cloudformationStackArn",
            "region": "region",
            "ec2_ami_info": "ec2AmiInfo",
            "version": "version",
        }

        self._cloudformation_stack_status = cloudformation_stack_status
        self._cloudformation_stack_status_reason = cloudformation_stack_status_reason
        self._cloudformation_stack_arn = cloudformation_stack_arn
        self._cloudformation_stack_tags = cloudformation_stack_tags
        self._cloudformation_stack_creation_time = cloudformation_stack_creation_time
        self._creation_time = creation_time
        self._ec2_ami_info = ec2_ami_info
        self._image_build_status = image_build_status
        self._image_build_logs_arn = image_build_logs_arn
        self._image_configuration = image_configuration
        self._image_id = image_id
        self._imagebuilder_image_status = imagebuilder_image_status
        self._imagebuilder_image_status_reason = imagebuilder_image_status_reason
        self._region = region
        self._version = version

    @classmethod
    def from_dict(cls, dikt) -> "DescribeImageResponseContent":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The DescribeImageResponseContent of this DescribeImageResponseContent.
        :rtype: DescribeImageResponseContent
        """
        return util.deserialize_model(dikt, cls)

    @property
    def image_configuration(self):
        """Gets the image_configuration of this DescribeImageResponseContent.


        :return: The image_configuration of this DescribeImageResponseContent.
        :rtype: ImageConfigurationStructure
        """
        return self._image_configuration

    @image_configuration.setter
    def image_configuration(self, image_configuration):
        """Sets the image_configuration of this DescribeImageResponseContent.


        :param image_configuration: The image_configuration of this DescribeImageResponseContent.
        :type image_configuration: ImageConfigurationStructure
        """
        if image_configuration is None:
            raise ValueError("Invalid value for `image_configuration`, must not be `None`")

        self._image_configuration = image_configuration

    @property
    def image_id(self):
        """Gets the image_id of this DescribeImageResponseContent.

        Id of the Image to retrieve detailed information for.

        :return: The image_id of this DescribeImageResponseContent.
        :rtype: str
        """
        return self._image_id

    @image_id.setter
    def image_id(self, image_id):
        """Sets the image_id of this DescribeImageResponseContent.

        Id of the Image to retrieve detailed information for.

        :param image_id: The image_id of this DescribeImageResponseContent.
        :type image_id: str
        """
        if image_id is None:
            raise ValueError("Invalid value for `image_id`, must not be `None`")

        self._image_id = image_id

    @property
    def cloudformation_stack_tags(self):
        """Gets the cloudformation_stack_tags of this DescribeImageResponseContent.

        Tags for the CloudFormation stack.  # noqa: E501

        :return: The cloudformation_stack_tags of this DescribeImageResponseContent.
        :rtype: List[Tag]
        """
        return self._cloudformation_stack_tags

    @cloudformation_stack_tags.setter
    def cloudformation_stack_tags(self, cloudformation_stack_tags):
        """Sets the cloudformation_stack_tags of this DescribeImageResponseContent.

        Tags for the CloudFormation stack.  # noqa: E501

        :param cloudformation_stack_tags: The cloudformation_stack_tags of this DescribeImageResponseContent.
        :type cloudformation_stack_tags: List[Tag]
        """

        self._cloudformation_stack_tags = cloudformation_stack_tags

    @property
    def imagebuilder_image_status(self):
        """Gets the imagebuilder_image_status of this DescribeImageResponseContent.


        :return: The imagebuilder_image_status of this DescribeImageResponseContent.
        :rtype: ImageBuilderImageStatus
        """
        return self._imagebuilder_image_status

    @imagebuilder_image_status.setter
    def imagebuilder_image_status(self, imagebuilder_image_status):
        """Sets the imagebuilder_image_status of this DescribeImageResponseContent.


        :param imagebuilder_image_status: The imagebuilder_image_status of this DescribeImageResponseContent.
        :type imagebuilder_image_status: ImageBuilderImageStatus
        """

        self._imagebuilder_image_status = imagebuilder_image_status

    @property
    def imagebuilder_image_status_reason(self):
        """Gets the imagebuilder_image_status_reason of this DescribeImageResponseContent.

        Reason for the ImageBuilder Image status.

        :return: The imagebuilder_image_status_reason of this DescribeImageResponseContent.
        :rtype: str
        """
        return self._imagebuilder_image_status_reason

    @imagebuilder_image_status_reason.setter
    def imagebuilder_image_status_reason(self, imagebuilder_image_status_reason):
        """Sets the imagebuilder_image_status_reason of this DescribeImageResponseContent.

        Reason for the ImageBuilder Image status.

        :param imagebuilder_image_status_reason: The imagebuilder_image_status_reason
                                                 of this DescribeImageResponseContent.
        :type imagebuilder_image_status_reason: str
        """

        self._imagebuilder_image_status_reason = imagebuilder_image_status_reason

    @property
    def creation_time(self):
        """Gets the creation_time of this DescribeImageResponseContent.

        Timestamp representing the image creation time.

        :return: The creation_time of this DescribeImageResponseContent.
        :rtype: datetime
        """
        return self._creation_time

    @creation_time.setter
    def creation_time(self, creation_time):
        """Sets the creation_time of this DescribeImageResponseContent.

        Timestamp representing the image creation time.

        :param creation_time: The creation_time of this DescribeImageResponseContent.
        :type creation_time: datetime
        """
        self._creation_time = creation_time

    @property
    def image_build_logs_arn(self):
        """Gets the image_build_logs_arn of this DescribeImageResponseContent.

        ARN of the logs for the CloudFormation stack.  # noqa: E501

        :return: The image_build_logs_arn of this DescribeImageResponseContent.
        :rtype: str
        """
        return self._image_build_logs_arn

    @image_build_logs_arn.setter
    def image_build_logs_arn(self, image_build_logs_arn):
        """Sets the image_build_logs_arn of this DescribeImageResponseContent.

        ARN of the logs for the CloudFormation stack.  # noqa: E501

        :param image_build_logs_arn: The image_build_logs_arn of this DescribeImageResponseContent.
        :type image_build_logs_arn: str
        """

        self._image_build_logs_arn = image_build_logs_arn

    @property
    def image_build_status(self):
        """Gets the image_build_status of this DescribeImageResponseContent.


        :return: The image_build_status of this DescribeImageResponseContent.
        :rtype: ImageBuildStatus
        """
        return self._image_build_status

    @image_build_status.setter
    def image_build_status(self, image_build_status):
        """Sets the image_build_status of this DescribeImageResponseContent.


        :param image_build_status: The image_build_status of this DescribeImageResponseContent.
        :type image_build_status: ImageBuildStatus
        """
        if image_build_status is None:
            raise ValueError("Invalid value for `image_build_status`, must not be `None`")

        self._image_build_status = image_build_status

    @property
    def cloudformation_stack_status(self):
        """Gets the cloudformation_stack_status of this DescribeImageResponseContent.


        :return: The cloudformation_stack_status of this DescribeImageResponseContent.
        :rtype: CloudFormationStackStatus
        """
        return self._cloudformation_stack_status

    @cloudformation_stack_status.setter
    def cloudformation_stack_status(self, cloudformation_stack_status):
        """Sets the cloudformation_stack_status of this DescribeImageResponseContent.


        :param cloudformation_stack_status: The cloudformation_stack_status of this DescribeImageResponseContent.
        :type cloudformation_stack_status: CloudFormationStackStatus
        """
        self._cloudformation_stack_status = cloudformation_stack_status

    @property
    def cloudformation_stack_status_reason(self):
        """Gets the cloudformation_stack_status_reason of this DescribeImageResponseContent.

        Reason for the CloudFormation stack status

        :return: The cloudformation_stack_status_reason of this DescribeImageResponseContent.
        :rtype: str
        """
        return self._cloudformation_stack_status_reason

    @cloudformation_stack_status_reason.setter
    def cloudformation_stack_status_reason(self, cloudformation_stack_status_reason):
        """Sets the cloudformation_stack_status_reason of this DescribeImageResponseContent.

        Reason for the CloudFormation stack status

        :param cloudformation_stack_status_reason: The cloudformation_stack_status_reason
                                                   of this DescribeImageResponseContent.
        :type cloudformation_stack_status_reason: str
        """

        self._cloudformation_stack_status_reason = cloudformation_stack_status_reason

    @property
    def cloudformation_stack_arn(self):
        """Gets the cloudformation_stack_arn of this DescribeImageResponseContent.

        ARN of the main CloudFormation stack.

        :return: The cloudformation_stack_arn of this DescribeImageResponseContent.
        :rtype: str
        """
        return self._cloudformation_stack_arn

    @cloudformation_stack_arn.setter
    def cloudformation_stack_arn(self, cloudformation_stack_arn):
        """Sets the cloudformation_stack_arn of this DescribeImageResponseContent.

        ARN of the main CloudFormation stack.

        :param cloudformation_stack_arn: The cloudformation_stack_arn of this DescribeImageResponseContent.
        :type cloudformation_stack_arn: str
        """
        self._cloudformation_stack_arn = cloudformation_stack_arn

    @property
    def region(self):
        """Gets the region of this DescribeImageResponseContent.

        AWS region where the image is created.

        :return: The region of this DescribeImageResponseContent.
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """Sets the region of this DescribeImageResponseContent.

        AWS region where the image is created.

        :param region: The region of this DescribeImageResponseContent.
        :type region: str
        """
        if region is None:
            raise ValueError("Invalid value for `region`, must not be `None`")

        self._region = region

    @property
    def cloudformation_stack_creation_time(self):
        """Gets the cloudformation_stack_creation_time of this DescribeImageResponseContent.

        Timestamp representing the CloudFormation stack creation time.  # noqa: E501

        :return: The cloudformation_stack_creation_time of this DescribeImageResponseContent.
        :rtype: datetime
        """
        return self._cloudformation_stack_creation_time

    @cloudformation_stack_creation_time.setter
    def cloudformation_stack_creation_time(self, cloudformation_stack_creation_time):
        """Sets the cloudformation_stack_creation_time of this DescribeImageResponseContent.

        Timestamp representing the CloudFormation stack creation time.  # noqa: E501

        :param cloudformation_stack_creation_time: The cloudformation_stack_creation_time of this
                                                   DescribeImageResponseContent.
        :type cloudformation_stack_creation_time: datetime
        """

        self._cloudformation_stack_creation_time = cloudformation_stack_creation_time

    @property
    def ec2_ami_info(self):
        """Gets the ec2_ami_info of this DescribeImageResponseContent.


        :return: The ec2_ami_info of this DescribeImageResponseContent.
        :rtype: Ec2AmiInfo
        """
        return self._ec2_ami_info

    @ec2_ami_info.setter
    def ec2_ami_info(self, ec2_ami_info):
        """Sets the ec2_ami_info of this DescribeImageResponseContent.


        :param ec2_ami_info: The ec2_ami_info of this DescribeImageResponseContent.
        :type ec2_ami_info: Ec2AmiInfo
        """

        self._ec2_ami_info = ec2_ami_info

    @property
    def version(self):
        """Gets the version of this DescribeImageResponseContent.

        ParallelCluster version used to build the image.

        :return: The version of this DescribeImageResponseContent.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this DescribeImageResponseContent.

        ParallelCluster version used to build the image.

        :param version: The version of this DescribeImageResponseContent.
        :type version: str
        """
        if version is None:
            raise ValueError("Invalid value for `version`, must not be `None`")

        self._version = version
