/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.impl;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.query.Dataset;

public class DatasetImpl
implements Dataset {
    private Set<URI> defaultRemoveGraphs = new LinkedHashSet<URI>();
    private URI defaultInsertGraph;
    private Set<URI> defaultGraphs = new LinkedHashSet<URI>();
    private Set<URI> namedGraphs = new LinkedHashSet<URI>();

    @Override
    public Set<URI> getDefaultRemoveGraphs() {
        return Collections.unmodifiableSet(this.defaultRemoveGraphs);
    }

    public void addDefaultRemoveGraph(URI graphURI) {
        this.defaultRemoveGraphs.add(graphURI);
    }

    public boolean removeDefaultRemoveGraph(URI graphURI) {
        return this.defaultRemoveGraphs.remove(graphURI);
    }

    @Override
    public URI getDefaultInsertGraph() {
        return this.defaultInsertGraph;
    }

    public void setDefaultInsertGraph(URI defaultInsertGraph) {
        this.defaultInsertGraph = defaultInsertGraph;
    }

    @Override
    public Set<URI> getDefaultGraphs() {
        return Collections.unmodifiableSet(this.defaultGraphs);
    }

    public void addDefaultGraph(URI graphURI) {
        this.defaultGraphs.add(graphURI);
    }

    public boolean removeDefaultGraph(URI graphURI) {
        return this.defaultGraphs.remove(graphURI);
    }

    @Override
    public Set<URI> getNamedGraphs() {
        return Collections.unmodifiableSet(this.namedGraphs);
    }

    public void addNamedGraph(URI graphURI) {
        this.namedGraphs.add(graphURI);
    }

    public boolean removeNamedGraph(URI graphURI) {
        return this.namedGraphs.remove(graphURI);
    }

    public void clear() {
        this.defaultRemoveGraphs.clear();
        this.defaultInsertGraph = null;
        this.defaultGraphs.clear();
        this.namedGraphs.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (URI uri : this.getDefaultRemoveGraphs()) {
            sb.append("DELETE FROM ");
            this.appendURI(sb, uri);
        }
        if (this.getDefaultInsertGraph() != null) {
            sb.append("INSERT INTO ");
            this.appendURI(sb, this.getDefaultInsertGraph());
        }
        for (URI uri : this.getDefaultGraphs()) {
            sb.append("USING ");
            this.appendURI(sb, uri);
        }
        for (URI uri : this.getNamedGraphs()) {
            sb.append("USING NAMED ");
            this.appendURI(sb, uri);
        }
        if (this.getDefaultGraphs().isEmpty() && this.getNamedGraphs().isEmpty()) {
            sb.append("## empty dataset ##");
        }
        return sb.toString();
    }

    private void appendURI(StringBuilder sb, URI uri) {
        String str = uri.toString();
        if (str.length() > 50) {
            sb.append("<").append(str, 0, 19).append("..");
            sb.append(str, str.length() - 29, str.length()).append(">\n");
        } else {
            sb.append("<").append(uri).append(">\n");
        }
    }
}

