/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.tools;

import java.sql.SQLException;
import org.apache.jena.arq.querybuilder.AbstractQueryBuilder;
import org.apache.jena.arq.querybuilder.ExprFactory;
import org.apache.jena.arq.querybuilder.SelectBuilder;
import org.apache.jena.arq.querybuilder.UpdateBuilder;
import org.apache.jena.arq.querybuilder.WhereBuilder;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Conditional;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_LogicalOr;
import org.apache.jena.sparql.expr.E_StrContains;
import org.apache.jena.sparql.expr.E_StrReplace;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction2;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.lang.sparql_11.ParseException;
import org.apache.jena.update.UpdateRequest;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.interfaces.TripleStoreClientInterface;

public class RenamingTool {
    String strMatch;
    String strTarget;
    String strReplacement;
    Expr exprFilter = null;
    boolean splitUpdate = true;
    int stepSize = 1000000;
    boolean quads = true;
    ExprFactory exprFactory = new ExprFactory();
    static String varCount = "count";
    static Var varTargetURI = Var.alloc("targetURI");
    static ExprVar exprTargetURI = new ExprVar(varTargetURI);
    static Var varReplacementURI = Var.alloc("replacementURI");
    static ExprVar exprReplacementURI = new ExprVar(varReplacementURI);
    Expr exprMatch;
    Expr exprTarget;
    static Var newS = Var.alloc("newS");
    static Var newP = Var.alloc("newP");
    static Var newO = Var.alloc("newO");
    static Var varS = Var.alloc("s");
    static Var varP = Var.alloc("p");
    static Var varO = Var.alloc("o");
    static Var varG = Var.alloc("g");
    public static ExprVar exprS = new ExprVar(varS);
    public static ExprVar exprP = new ExprVar(varP);
    public static ExprVar exprO = new ExprVar(varO);
    public static ExprVar exprG = new ExprVar(varG);
    static Var matchS = Var.alloc("matchS");
    static Var matchP = Var.alloc("matchP");
    static Var matchO = Var.alloc("matchO");
    static ExprVar exprMatchS = new ExprVar(matchS);
    static ExprVar exprMatchP = new ExprVar(matchP);
    static ExprVar exprMatchO = new ExprVar(matchO);

    public RenamingTool(String strTarget, String strReplacement) {
        this.strMatch = strTarget;
        this.strTarget = strTarget;
        this.strReplacement = strReplacement;
    }

    public RenamingTool(String strMatch, String strTarget, String strReplacement) {
        this.strMatch = strMatch;
        this.strTarget = strTarget;
        this.strReplacement = strReplacement;
    }

    public void setFilter(Expr filter) {
        this.exprFilter = filter;
    }

    public void setMatch(String match) {
        this.strMatch = match;
    }

    public void setTarget(String target) {
        this.strTarget = target;
    }

    public void setReplacement(String replacement) {
        this.strReplacement = replacement;
    }

    public void setUpdateSize(int updateSize) {
        this.splitUpdate = true;
        this.stepSize = updateSize;
    }

    public void setSingleUpdate() {
        this.splitUpdate = false;
    }

    public void setTripleStore() {
        this.quads = false;
    }

    public void setQuadsStore() {
        this.quads = true;
    }

    public void renameString(TripleStoreClientInterface kbClient) {
        this.renameString(kbClient, null);
    }

    public void renameString(TripleStoreClientInterface kbClient, String graph) {
        if (this.strTarget == null || this.strReplacement == null) {
            throw new JPSRuntimeException("RenamingTool: target or replacement is null!");
        }
        if (this.strMatch == null) {
            this.strMatch = this.strTarget;
        }
        this.exprMatch = this.exprFactory.asExpr(this.strMatch);
        this.exprTarget = this.exprFactory.asExpr(this.strTarget);
        WhereBuilder whereFilter = this.whereMatchString();
        WhereBuilder whereUpdate = this.whereUpdateString();
        this.performRename(kbClient, graph, whereFilter, whereUpdate);
    }

    public void renameIRI(TripleStoreClientInterface kbClient) {
        this.renameIRI(kbClient, null);
    }

    public void renameIRI(TripleStoreClientInterface kbClient, String graph) {
        if (this.strTarget == null || this.strReplacement == null) {
            throw new JPSRuntimeException("RenamingTool: target or replacement is null!");
        }
        WhereBuilder whereUpdate = this.whereUpdateIRI();
        WhereBuilder whereFilter = this.whereMatchIRI();
        this.performRename(kbClient, graph, whereFilter, whereUpdate);
    }

    private void performRename(TripleStoreClientInterface kbClient, String graph, WhereBuilder whereMatch, WhereBuilder whereUpdate) {
        if (this.splitUpdate) {
            String query = this.countQuery(graph, whereMatch);
            JSONArray result = kbClient.executeQuery(query);
            JSONObject jsonobject = result.getJSONObject(0);
            int count = jsonobject.getInt(varCount);
            int steps = count / this.stepSize;
            if (count % this.stepSize > 0) {
                ++steps;
            }
            UpdateRequest sparqlUpdate = this.buildSparqlUpdate(graph, whereUpdate, this.stepSize);
            for (int i = 0; i < steps; ++i) {
                try {
                    kbClient.executeUpdate(sparqlUpdate);
                    continue;
                }
                catch (Exception e) {
                    if (e.getCause() instanceof SQLException) {
                        throw new JPSRuntimeException("RenamingTool: tagging update failed! SourceKB might not be quads. Try setTripleStore().", e);
                    }
                    throw e;
                }
            }
            result = kbClient.executeQuery(query);
            jsonobject = result.getJSONObject(0);
            count = jsonobject.getInt(varCount);
            if (count > 0) {
                sparqlUpdate = this.buildSparqlUpdate(graph, whereUpdate, 0);
                kbClient.executeUpdate(sparqlUpdate);
            }
        } else {
            UpdateRequest sparqlUpdate = this.buildSparqlUpdate(graph, whereUpdate, 0);
            kbClient.executeUpdate(sparqlUpdate);
        }
    }

    private String countQuery(String graph, WhereBuilder whereFilter) {
        WhereBuilder where = null;
        if (graph != null) {
            where = new WhereBuilder();
            String graphURI = "<" + graph + ">";
            where.addGraph((Object)graphURI, (AbstractQueryBuilder)whereFilter);
        } else {
            where = whereFilter;
        }
        String query = "SELECT (COUNT(*) AS ?" + varCount + ") ";
        query = query + where.toString();
        return query;
    }

    private UpdateRequest buildSparqlUpdate(String graph, WhereBuilder where, int limit) {
        SelectBuilder select = new SelectBuilder();
        select.addVar(varS).addVar(varP).addVar(varO).addVar(newS).addVar(newP).addVar(newO);
        if (limit > 0) {
            select.setLimit(limit);
        }
        UpdateBuilder builder = new UpdateBuilder();
        if (this.quads) {
            if (graph == null) {
                select.addVar(varG);
                select.addGraph((Object)varG, (AbstractQueryBuilder)where);
                builder.addInsert(varG, newS, newP, newO).addDelete(varG, varS, varP, varO).addSubQuery(select);
            } else {
                String graphURI = "<" + graph + ">";
                select.addGraph((Object)graphURI, (AbstractQueryBuilder)where);
                builder.addInsert(graphURI, newS, newP, newO).addDelete(graphURI, varS, varP, varO).addSubQuery(select);
            }
        } else {
            select.addWhere(where);
            builder.addInsert(newS, newP, newO).addDelete(varS, varP, varO).addSubQuery(select);
        }
        return builder.buildRequest();
    }

    private WhereBuilder whereMatchIRI() {
        E_Equals eqS = this.exprFactory.eq(exprS, exprTargetURI);
        E_Equals eqP = this.exprFactory.eq(exprP, exprTargetURI);
        E_Equals eqO = this.exprFactory.eq(exprO, exprTargetURI);
        E_LogicalOr orSPO = this.exprFactory.or(eqS, this.exprFactory.or(eqP, eqO));
        WhereBuilder where = new WhereBuilder();
        if (this.exprFilter != null) {
            where.addFilter(this.exprFilter);
        }
        try {
            where.addWhere(varS, varP, varO).addBind("<" + this.strTarget + ">", (Object)varTargetURI).addBind("<" + this.strReplacement + ">", (Object)varReplacementURI).addFilter(orSPO);
        }
        catch (ParseException e) {
            throw new JPSRuntimeException(e);
        }
        return where;
    }

    private WhereBuilder whereUpdateIRI() {
        E_Conditional ifS = this.exprFactory.cond(this.exprFactory.eq(exprS, exprTargetURI), exprReplacementURI, exprS);
        E_Conditional ifP = this.exprFactory.cond(this.exprFactory.eq(exprP, exprTargetURI), exprReplacementURI, exprP);
        E_Conditional ifO = this.exprFactory.cond(this.exprFactory.eq(exprO, exprTargetURI), exprReplacementURI, exprO);
        E_Conditional ifSBlank = this.exprFactory.cond(this.exprFactory.isBlank(exprS), exprS, ifS);
        E_Conditional ifPBlank = this.exprFactory.cond(this.exprFactory.isBlank(exprP), exprP, ifP);
        E_Conditional ifOBlank = this.exprFactory.cond(this.exprFactory.isBlank(exprO), exprO, ifO);
        WhereBuilder where = this.whereMatchIRI().addBind(ifSBlank, (Object)newS).addBind(ifPBlank, (Object)newP).addBind(ifOBlank, (Object)newO);
        return where;
    }

    private WhereBuilder whereMatchString() {
        E_StrContains SContainsMatch = this.exprFactory.contains(this.exprFactory.str(exprS), this.exprMatch);
        E_StrContains PContainsMatch = this.exprFactory.contains(this.exprFactory.str(exprP), this.exprMatch);
        E_StrContains OContainsMatch = this.exprFactory.contains(this.exprFactory.str(exprO), this.exprMatch);
        E_StrContains SContainsTarget = this.exprFactory.contains(this.exprFactory.str(exprS), this.exprTarget);
        E_StrContains PContainsTarget = this.exprFactory.contains(this.exprFactory.str(exprP), this.exprTarget);
        E_StrContains OContainsTarget = this.exprFactory.contains(this.exprFactory.str(exprO), this.exprTarget);
        ExprFunction2 SContains = SContainsMatch;
        ExprFunction2 PContains = PContainsMatch;
        ExprFunction2 OContains = OContainsMatch;
        if (this.exprMatch != this.exprTarget) {
            SContains = this.exprFactory.and(SContainsMatch, SContainsTarget);
            PContains = this.exprFactory.and(PContainsMatch, PContainsTarget);
            OContains = this.exprFactory.and(OContainsMatch, OContainsTarget);
        }
        E_LogicalOr or = this.exprFactory.or(exprMatchS, this.exprFactory.or(exprMatchP, exprMatchO));
        WhereBuilder where = new WhereBuilder().addWhere(varS, varP, varO);
        if (this.exprFilter != null) {
            where.addFilter(this.exprFilter);
        }
        where.addBind(SContains, (Object)matchS).addBind(PContains, (Object)matchP).addBind(OContains, (Object)matchO).addFilter(or);
        return where;
    }

    private WhereBuilder whereUpdateString() {
        Expr exprReplacement = this.exprFactory.asExpr(this.strReplacement);
        E_StrReplace replaceS = this.exprFactory.replace(this.exprFactory.str(exprS), this.exprTarget, exprReplacement);
        E_StrReplace replaceP = this.exprFactory.replace(this.exprFactory.str(exprP), this.exprTarget, exprReplacement);
        E_StrReplace replaceO = this.exprFactory.replace(this.exprFactory.str(exprO), this.exprTarget, exprReplacement);
        E_Conditional ifS = this.exprFactory.cond(exprMatchS, this.exprFactory.iri(replaceS), exprS);
        E_Conditional ifP = this.exprFactory.cond(exprMatchP, this.exprFactory.iri(replaceP), exprP);
        E_Conditional ifO = this.exprFactory.cond(exprMatchO, this.exprFactory.iri(replaceO), exprO);
        E_Conditional ifSBlank = this.exprFactory.cond(this.exprFactory.isBlank(exprS), exprS, ifS);
        E_Conditional ifPBlank = this.exprFactory.cond(this.exprFactory.isBlank(exprP), exprP, ifP);
        E_Conditional ifOBlank = this.exprFactory.cond(this.exprFactory.isBlank(exprO), exprO, ifO);
        WhereBuilder where = this.whereMatchString().addBind(ifSBlank, (Object)newS).addBind(ifPBlank, (Object)newP).addBind(ifOBlank, (Object)newO);
        return where;
    }
}

