/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.query.fed;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.sparql.SPARQLParser;
import uk.ac.cam.cares.jps.base.query.fed.ParsedQueryTreeVisitor;
import uk.ac.cam.cares.jps.base.query.fed.ServiceDescriptionIndexer;

public class DataSourceSelector {
    static final Logger LOGGER = LogManager.getLogger(DataSourceSelector.class);
    private ServiceDescriptionIndexer indexer = null;
    private Map<String, String> host2host = null;

    public DataSourceSelector(ServiceDescriptionIndexer indexer) {
        this.indexer = indexer;
    }

    public DataSourceSelector(ServiceDescriptionIndexer indexer, Map<String, String> host2host) {
        this.indexer = indexer;
        this.host2host = host2host;
    }

    private String replaceHost(String url) {
        if (this.host2host == null) {
            return url;
        }
        for (String host : this.host2host.keySet()) {
            if (!url.contains(host)) continue;
            String newhost = this.host2host.get(host);
            url = url.replace(host, newhost);
            LOGGER.info("replace host in endpoint url, host=" + host + ", newhost=" + newhost + ", new url=" + url);
            return url;
        }
        return url;
    }

    public String addValuesClauses(String sparql) {
        String result = sparql;
        List<ParsedQueryTreeVisitor.ServiceGraphPatternSummary> summaries = DataSourceSelector.extractKeysForSubqueries(sparql);
        for (ParsedQueryTreeVisitor.ServiceGraphPatternSummary summary : summaries) {
            List<String> uris = summary.keys;
            List<ServiceDescriptionIndexer.ServiceDescriptionSummary> serviceDescrSummaries = this.indexer.conjunctiveQuery(uris);
            ArrayList<String> endpointsURLs = new ArrayList<String>();
            for (ServiceDescriptionIndexer.ServiceDescriptionSummary sdSummary : serviceDescrSummaries) {
                String url = this.replaceHost(sdSummary.endpointURL);
                endpointsURLs.add(url);
            }
            result = DataSourceSelector.addValuesClause(result, summary.serviceVarName, endpointsURLs);
        }
        return result;
    }

    public static String addValuesClause(String sparql, String varName, List<String> varValues) {
        String[] clauses;
        int minIndex = -1;
        for (String clause : clauses = new String[]{"LIMIT", "OFFSET", "ORDER", "HAVING", "GROUP"}) {
            int index = sparql.lastIndexOf(clause);
            if (minIndex != -1 && index >= minIndex) continue;
            minIndex = index;
        }
        String firstPart = sparql;
        if (minIndex > -1) {
            firstPart = sparql.substring(0, minIndex);
        }
        int index = firstPart.lastIndexOf("}");
        StringBuffer b = new StringBuffer("  VALUES ?").append(varName).append(" { ");
        for (String value : varValues) {
            b.append("<").append(value).append("> ");
        }
        b.append("}\r\n");
        LOGGER.info("added VALUES clause = " + b);
        String newSparql = sparql.substring(0, index) + b + sparql.substring(index, sparql.length());
        return newSparql;
    }

    public static List<ParsedQueryTreeVisitor.ServiceGraphPatternSummary> extractKeysForSubqueries(String sparql) {
        SPARQLParser parser = new SPARQLParser();
        String baseURI = null;
        ParsedQuery parsedQuery = parser.parseQuery(sparql, baseURI);
        LOGGER.debug("Visiting nodes on parsed query tree");
        ParsedQueryTreeVisitor visitor = new ParsedQueryTreeVisitor();
        parsedQuery.getTupleExpr().visit(visitor);
        List<ParsedQueryTreeVisitor.ServiceGraphPatternSummary> result = visitor.getSummariesWithoutBindings();
        String serviceVars = "";
        for (ParsedQueryTreeVisitor.ServiceGraphPatternSummary summary : result) {
            serviceVars = serviceVars + "?" + summary.serviceVarName + ", ";
        }
        LOGGER.info("Visited nodes on parsed query tree, found services variables=" + serviceVars);
        return result;
    }
}

