/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.query;

import org.apache.jena.arq.querybuilder.ExprFactory;
import org.apache.jena.arq.querybuilder.SelectBuilder;
import org.apache.jena.sparql.expr.E_Regex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.cache.LRUCache;
import uk.ac.cam.cares.jps.base.config.KeyValueMap;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.interfaces.TripleStoreClientInterface;
import uk.ac.cam.cares.jps.base.query.RemoteStoreClient;
import uk.ac.cam.cares.jps.base.router.AbstractCachedRouter;
import uk.ac.cam.cares.jps.base.util.InputValidator;
import uk.ac.cam.cares.jps.base.util.MiscUtil;

public class RDBStoreRouter
extends AbstractCachedRouter<String, String> {
    private static Logger LOGGER = LogManager.getLogger(RDBStoreRouter.class);
    public static final String RDFS_PREFIX = "rdfs";
    public static final String RDFS = "http://www.w3.org/2000/01/rdf-schema#";
    public static final String RDF_PREFIX = "rdf";
    public static final String RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String RDF_TYPE = "type";
    public static final String ONTORDBROUTER_PREFIX = "ontordbrouter";
    public static final String ONTORDBROUTER = "http://www.theworldavatar.com/kg/ontordbrouter/";
    public static final String RESOURCE = "resource";
    public static final String LABEL = "label";
    public static final String COLON = ":";
    public static final String QUESTION_MARK = "?";
    public static final String SLASH = "/";
    public static final String TARGET_RDB_RESOURCE = "TargetRDBResource";
    public static final String URL = "url";
    public static final String HAS_URL = "hasUrl";
    public static String RDBStoreRouterEndpoint = System.getenv("RDB_STOREROUTER_ENDPOINT");
    public static final String RDB_STOREROUTER_ENDPOINT_NAME = "RDB_STOREROUTER_ENDPOINT";
    private static final int CACHE_SIZE;
    static RDBStoreRouter rdbStoreRouter;

    private RDBStoreRouter() {
        super(new LRUCache(CACHE_SIZE));
    }

    public static synchronized RDBStoreRouter getInstance() {
        if (rdbStoreRouter == null) {
            rdbStoreRouter = new RDBStoreRouter();
        }
        return rdbStoreRouter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getRDBUrl(String targetRDBResourceID) {
        String rdbUrl = null;
        if (targetRDBResourceID != null && !targetRDBResourceID.isEmpty()) {
            RDBStoreRouter.getInstance();
            if (!RDBStoreRouter.isRemoteTargetResourceID(targetRDBResourceID)) throw new JPSRuntimeException("Invalid targetResourceID: " + targetRDBResourceID);
            String targetResourceLabel = RDBStoreRouter.getLabelFromTargetResourceID(targetRDBResourceID);
            LOGGER.info("Remote store. targetResourceLabel=" + targetResourceLabel);
            rdbUrl = (String)rdbStoreRouter.get(targetResourceLabel);
            if (rdbUrl != null) return rdbUrl;
            LOGGER.error("Url could not be retrieved for the following resource IRI:" + targetRDBResourceID + ", label:" + targetResourceLabel);
            return rdbUrl;
        } else {
            LOGGER.error("targetResourceID is null.");
        }
        return rdbUrl;
    }

    @Override
    public String getFromStore(String targetResourceLabel, TripleStoreClientInterface storeClient) {
        ExprFactory exprFactory = new ExprFactory();
        E_Regex exprRegex = exprFactory.regex((Object)exprFactory.str(QUESTION_MARK.concat(LABEL)), targetResourceLabel, "");
        SelectBuilder builder = ((SelectBuilder)((SelectBuilder)((SelectBuilder)new SelectBuilder().addPrefix(RDFS_PREFIX, RDFS)).addPrefix(RDF_PREFIX, RDF)).addPrefix(ONTORDBROUTER_PREFIX, ONTORDBROUTER)).addVar(QUESTION_MARK.concat(URL)).addWhere(QUESTION_MARK.concat(RESOURCE), RDF_PREFIX.concat(COLON).concat(RDF_TYPE), ONTORDBROUTER_PREFIX.concat(COLON).concat(TARGET_RDB_RESOURCE)).addOptional(QUESTION_MARK.concat(RESOURCE), ONTORDBROUTER_PREFIX.concat(COLON).concat(HAS_URL), QUESTION_MARK.concat(URL)).addWhere(QUESTION_MARK.concat(RESOURCE), RDFS_PREFIX.concat(COLON).concat(LABEL), QUESTION_MARK.concat(LABEL)).addFilter(exprRegex);
        JSONArray results = storeClient.executeQuery(builder.toString());
        if (!results.isEmpty()) {
            JSONObject obj = results.getJSONObject(0);
            String url = MiscUtil.optNullKey(obj, URL);
            return url;
        }
        LOGGER.error("URL not found for resource=" + targetResourceLabel);
        return null;
    }

    public static String getLabelFromTargetResourceID(String targetResourceID) {
        return targetResourceID.substring(targetResourceID.lastIndexOf(SLASH) + 1).trim();
    }

    public static boolean isRemoteTargetResourceID(String targetRDBResourceID) {
        if (InputValidator.checkIfValidIRI(targetRDBResourceID)) {
            return true;
        }
        if (targetRDBResourceID.matches("[A-Za-z0-9\\-\\_]+")) {
            return true;
        }
        LOGGER.error("Invalid namespace label:" + targetRDBResourceID + ". Not alphanumeric (special characters - and _ are allowed).");
        return false;
    }

    @Override
    public TripleStoreClientInterface getRouterStoreClient() {
        return new RemoteStoreClient(RDBStoreRouterEndpoint);
    }

    static {
        if (RDBStoreRouterEndpoint == null) {
            LOGGER.info("RDB_STOREROUTER_ENDPOINT not found in environment variables... Using jps.properties.");
            RDBStoreRouterEndpoint = KeyValueMap.getInstance().get("url.rdbstorerouter.endpoint");
        }
        LOGGER.info("RDB STOREROUTER_ENDPOINT set to " + RDBStoreRouterEndpoint);
        CACHE_SIZE = Integer.parseInt(KeyValueMap.getInstance().get("rdb.storerouter.cache.size"));
        rdbStoreRouter = null;
    }
}

