/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.discovery;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.config.AgentLocator;
import uk.ac.cam.cares.jps.base.config.KeyValueManager;
import uk.ac.cam.cares.jps.base.discovery.MediaType;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.http.Http;
import uk.ac.cam.cares.jps.base.util.InputValidator;

public class AgentCaller {
    private static final Logger LOGGER = LogManager.getLogger(AgentCaller.class);
    private static final String JSON_PARAMETER_KEY = "query";
    private static String hostPort = null;

    private static synchronized String getHostPort() {
        if (hostPort == null) {
            hostPort = AgentLocator.getProperty("host") + ":" + AgentLocator.getProperty("port");
        }
        return hostPort;
    }

    public static String executeGet(String path) {
        URIBuilder builder = AgentCaller.getUriBuilderForPath(path);
        try {
            HttpGet request = new HttpGet(builder.build());
            return AgentCaller.executeGet(request);
        }
        catch (Exception e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    public static String executeGet(String path, String ... keyOrValue) {
        URIBuilder builder = AgentCaller.getUriBuilderForPath(path);
        for (int i = 0; i < keyOrValue.length; i += 2) {
            String key = keyOrValue[i];
            String value = keyOrValue[i + 1];
            builder.setParameter(key, value);
        }
        try {
            HttpGet request = new HttpGet(builder.build());
            return AgentCaller.executeGet(request);
        }
        catch (Exception e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    public static String executePost(String path, String body) {
        String response_body;
        URIBuilder builder = AgentCaller.getUriBuilderForPath(path);
        StringEntity entity = new StringEntity(body, ContentType.APPLICATION_JSON);
        try {
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpPost request = new HttpPost(builder.build());
            request.setEntity(entity);
            HttpResponse response = httpClient.execute(request);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new JPSRuntimeException(response.getStatusLine().toString());
            }
            HttpEntity rsp_entity = response.getEntity();
            response_body = EntityUtils.toString(rsp_entity, "UTF-8");
        }
        catch (IOException | URISyntaxException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
        return response_body;
    }

    public static String executePut(String path, String body) {
        return AgentCaller.executePut(path, body, null);
    }

    public static String executePut(String path, String body, String jsonParam) {
        String response_body;
        URIBuilder builder = AgentCaller.getUriBuilderForPath(path);
        StringEntity entity = new StringEntity(body, ContentType.APPLICATION_JSON);
        if (jsonParam != null) {
            builder.setParameter(JSON_PARAMETER_KEY, jsonParam);
        }
        try {
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpPut request = new HttpPut(builder.build());
            request.setEntity(entity);
            HttpResponse response = httpClient.execute(request);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new JPSRuntimeException(response.getStatusLine().toString());
            }
            HttpEntity rsp_entity = response.getEntity();
            response_body = EntityUtils.toString(rsp_entity, "UTF-8");
        }
        catch (IOException | URISyntaxException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
        return response_body;
    }

    private static URIBuilder getUriBuilderForPath(String path) {
        URIBuilder builder;
        try {
            builder = new URIBuilder(Http.createURI(path, new String[0]));
        }
        catch (Exception e) {
            builder = new URIBuilder().setScheme("http").setHost(AgentCaller.getHostPort()).setPath(path);
        }
        return builder;
    }

    public static String executeGetWithURL(String url) {
        URI uri = Http.createURI(url, new String[0]);
        HttpGet request = new HttpGet(uri);
        return AgentCaller.executeGet(request);
    }

    public static String executeGetWithURLAndJSON(String url, String json) {
        URI uri = AgentCaller.createURIWithURLandJSON(url, json);
        HttpGet request = new HttpGet(uri);
        LOGGER.info("REQUEST HERE= " + request);
        return AgentCaller.executeGet(request);
    }

    public static URI createURIWithURLandJSON(String url, String json) {
        return Http.createURI(url, JSON_PARAMETER_KEY, json);
    }

    @Deprecated
    public static URI createURI(String url, String ... keyOrValue) {
        return Http.createURI(url, keyOrValue);
    }

    public static String executeGetWithURLKey(String urlKey, MediaType type, String ... keyOrValue) {
        String url = KeyValueManager.get(urlKey);
        URI uri = Http.createURI(url, keyOrValue);
        HttpGet request = new HttpGet(uri);
        if (type != null) {
            request.setHeader("Accept", type.type);
        }
        return AgentCaller.executeGet(request);
    }

    public static String executeGetWithJsonParameter(String path, String json) {
        URIBuilder builder = AgentCaller.getUriBuilderForPath(path);
        builder.setParameter(JSON_PARAMETER_KEY, json);
        try {
            HttpGet request = new HttpGet(builder.build());
            request.setHeader("Accept", "application/json");
            request.setHeader("Content-type", "application/json");
            return AgentCaller.executeGet(request);
        }
        catch (Exception e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    public static JSONObject readJsonParameter(HttpServletRequest request) {
        try {
            String json = null;
            if (request.getMethod().equals("GET") && (json = request.getParameter(JSON_PARAMETER_KEY)) != null) {
                JSONObject jo = new JSONObject();
                if (InputValidator.checkIfValidJSONObject(json)) {
                    jo = new JSONObject(json);
                } else {
                    jo.put("body", json);
                }
                jo.put("acceptHeaders", AgentCaller.getAccept(request)).put("method", request.getMethod()).put("path", request.getPathInfo()).put("contentType", request.getContentType()).put("requestUrl", request.getRequestURL().toString());
                return jo;
            }
            JSONObject jsonobject = Http.readJsonParameter(request);
            if (request.getMethod().equals("PUT") || request.getMethod().equals("POST")) {
                JSONObject jo;
                json = IOUtils.toString(request.getReader());
                String json2 = request.getParameter(JSON_PARAMETER_KEY);
                if (json2 != null) {
                    jo = new JSONObject(json2);
                    for (String key : JSONObject.getNames(jo)) {
                        jsonobject.put(key, jo.get(key));
                    }
                }
                if (InputValidator.checkIfValidJSONObject(json)) {
                    jo = new JSONObject(json);
                    for (String key : JSONObject.getNames(jo)) {
                        jsonobject.put(key, jo.get(key));
                    }
                }
            }
            jsonobject.put("method", request.getMethod()).put("acceptHeaders", AgentCaller.getAccept(request)).put("body", json).put("path", request.getPathInfo()).put("contentType", request.getContentType()).put("requestUrl", request.getRequestURL().toString());
            return jsonobject;
        }
        catch (IOException | JSONException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    protected static String getAccept(HttpServletRequest req) {
        String accept = null;
        Enumeration acceptList = req.getHeaders("Accept");
        if (acceptList.hasMoreElements()) {
            accept = (String)acceptList.nextElement();
        }
        LOGGER.info("accept = " + accept);
        return accept;
    }

    @Deprecated
    public static void writeJsonParameter(HttpServletResponse response, JSONObject json) throws IOException {
        Http.writeJsonParameter(response, json);
    }

    public static String executeGet(HttpGet request) {
        Closeable httpResponse = null;
        try {
            StringBuffer buf = new StringBuffer(request.getMethod()).append(" ").append(request.getURI().getScheme()).append("://").append(request.getURI().getHost());
            int port = request.getURI().getPort();
            if (port > -1) {
                buf.append(":").append(request.getURI().getPort());
            }
            buf.append(request.getURI().getPath());
            String requestAsString = buf.toString();
            String query = request.getURI().getQuery();
            if (query != null) {
                int length = query.length();
                if (length > 100) {
                    query = query.substring(0, 99);
                }
                buf.append("?").append(query);
            }
            LOGGER.info(buf.toString());
            httpResponse = HttpClientBuilder.create().build().execute(request);
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                String body = EntityUtils.toString(httpResponse.getEntity());
                LOGGER.error(body);
                String message = "original request = " + requestAsString;
                if (request.getURI().getQuery() != null) {
                    message = message + "?" + request.getURI().getQuery();
                }
                LOGGER.info(message);
                throw new JPSRuntimeException("HTTP response with error = " + httpResponse.getStatusLine() + ", " + message);
            }
            String body = EntityUtils.toString(httpResponse.getEntity());
            LOGGER.debug(body);
            String string = body;
            return string;
        }
        catch (Exception e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static String getRequestBody(String url) {
        try {
            URL urlForGetRequest = new URL(url);
            HttpURLConnection conection = (HttpURLConnection)urlForGetRequest.openConnection();
            conection.setRequestMethod("GET");
            String readLine = null;
            int responseCode = conection.getResponseCode();
            if (responseCode == 200) {
                BufferedReader in = new BufferedReader(new InputStreamReader(conection.getInputStream()));
                StringBuffer response = new StringBuffer();
                while ((readLine = in.readLine()) != null) {
                    response.append(readLine);
                }
                in.close();
                return response.toString();
            }
            throw new JPSRuntimeException("Failure to connect");
        }
        catch (MalformedURLException e) {
            throw new JPSRuntimeException("Malformed URL " + url + "; try again.");
        }
        catch (ProtocolException e) {
            throw new JPSRuntimeException("Protocol Exception " + url + "; try again.");
        }
        catch (IOException e) {
            throw new JPSRuntimeException("IO Exception " + url + "; try again.");
        }
    }

    @Deprecated
    public static void printToResponse(Object object, HttpServletResponse resp) {
        Http.printToResponse(object, resp);
    }

    @Deprecated
    public static String serializeForResponse(Object object) {
        return Http.serializeForResponse(object);
    }

    @Deprecated
    public static String encodePercentage(String s) {
        return Http.encodePercentage(s);
    }

    @Deprecated
    public static String decodePercentage(String s) {
        return Http.decodePercentage(s);
    }
}

