/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.converter;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import org.apache.commons.validator.routines.UrlValidator;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import uk.ac.cam.cares.jps.base.converter.ITBoxManagement;
import uk.ac.cam.cares.jps.base.converter.SpringConfiguration;
import uk.ac.cam.cares.jps.base.converter.TBoxConfiguration;
import uk.ac.cam.cares.jps.base.converter.TBoxGeneration;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;

public class TBoxManagement
extends TBoxGeneration
implements ITBoxManagement {
    private Logger logger = LoggerFactory.getLogger(TBoxManagement.class);
    public OWLDataFactory dataFactory = OWLManager.getOWLDataFactory();
    public OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
    public OWLOntology ontology;
    public IRI ontologyIRI;
    public static TBoxConfiguration tBoxConfig;
    public static ApplicationContext applicationContext;
    public String SLASH = "/";
    public String BACKSLASH = "\\";
    public String FILE_EXT_OWL = ".owl";
    public String FILE_EXT_RDF = ".rdf";
    public static final String HTTP_PROTOCOL = "http://";
    public static final String HTTPS_PROTOCOL = "https://";
    public static final String OWL_VERSIONINFO = "versionInfo";
    public static final String OWL_URL = "http://www.w3.org/2002/07/owl#";

    @Override
    public void createOWLClass(String className, String targetName, String relation) throws JPSRuntimeException {
        this.checkClassName(className);
        OWLClass child = this.createClass(className);
        OWLClass parent = null;
        if (targetName != null && !targetName.isEmpty() && relation != null && !relation.isEmpty()) {
            parent = this.createClass(targetName);
            if (relation.equalsIgnoreCase(tBoxConfig.getIsARelation())) {
                this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLSubClassOfAxiom(child, parent)));
            } else if (relation.equalsIgnoreCase(tBoxConfig.getEquivalentToRelation())) {
                this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLEquivalentClassesAxiom((OWLClassExpression)child, (OWLClassExpression)parent)));
            }
        } else {
            if (tBoxConfig.gettBoxIri() == null || tBoxConfig.gettBoxIri().isEmpty()) {
                this.logger.error("TBox IRI is not provided in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
                throw new JPSRuntimeException("TBox IRI must be provided in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
            }
            if (this.ontology == null) {
                this.logger.error("TBox IRI is missing in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
                throw new JPSRuntimeException("TBox IRI must be provided in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
            }
            this.ontology.add((OWLAxiom)this.dataFactory.getOWLDeclarationAxiom(child));
        }
    }

    @Override
    public void addLabelToOWLClass(String className, String label) throws JPSRuntimeException {
        if (label != null && !label.isEmpty()) {
            OWLClass clas = this.createClass(className);
            OWLAnnotationProperty rdfsLabel = this.dataFactory.getRDFSLabel();
            OWLAnnotation labelAnnotation = this.dataFactory.getOWLAnnotation(rdfsLabel, this.dataFactory.getOWLLiteral(label));
            this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLAnnotationAssertionAxiom(clas.getIRI(), labelAnnotation)));
        }
    }

    @Override
    public void addDefinitionToOWLClass(String className, String definition) throws JPSRuntimeException {
        if (definition != null && !definition.isEmpty()) {
            OWLClass clas = this.createClass(className);
            OWLAnnotationProperty comment = this.dataFactory.getRDFSComment();
            OWLAnnotation definitionLiteral = this.dataFactory.getOWLAnnotation(comment, this.dataFactory.getOWLLiteral(definition));
            this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLAnnotationAssertionAxiom(clas.getIRI(), definitionLiteral)));
        }
    }

    @Override
    public void addLabelToObjectProperty(String property, String label) throws JPSRuntimeException {
        if (label != null && !label.isEmpty()) {
            OWLObjectProperty objectProperty = this.createObjectProperty(property);
            OWLAnnotationProperty rdfsLabel = this.dataFactory.getRDFSLabel();
            OWLAnnotation labelAnnotation = this.dataFactory.getOWLAnnotation(rdfsLabel, this.dataFactory.getOWLLiteral(label));
            this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLAnnotationAssertionAxiom(objectProperty.getIRI(), labelAnnotation)));
        }
    }

    @Override
    public void addDefinitionToObjectProperty(String property, String definition) throws JPSRuntimeException {
        if (definition != null && !definition.isEmpty()) {
            OWLObjectProperty objectProperty = this.createObjectProperty(property);
            OWLAnnotationProperty comment = this.dataFactory.getRDFSComment();
            OWLAnnotation definitionLiteral = this.dataFactory.getOWLAnnotation(comment, this.dataFactory.getOWLLiteral(definition));
            this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLAnnotationAssertionAxiom(objectProperty.getIRI(), definitionLiteral)));
        }
    }

    @Override
    public void addLabelToDataProperty(String property, String label) throws JPSRuntimeException {
        if (label != null && !label.isEmpty()) {
            OWLDataProperty dataProperty = this.createDataProperty(property);
            OWLAnnotationProperty rdfsLabel = this.dataFactory.getRDFSLabel();
            OWLAnnotation labelAnnotation = this.dataFactory.getOWLAnnotation(rdfsLabel, this.dataFactory.getOWLLiteral(label));
            this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLAnnotationAssertionAxiom(dataProperty.getIRI(), labelAnnotation)));
        }
    }

    @Override
    public void addDefinitionToDataProperty(String property, String definition) throws JPSRuntimeException {
        if (definition != null && !definition.isEmpty()) {
            OWLDataProperty dataProperty = this.createDataProperty(property);
            OWLAnnotationProperty comment = this.dataFactory.getRDFSComment();
            OWLAnnotation definitionLiteral = this.dataFactory.getOWLAnnotation(comment, this.dataFactory.getOWLLiteral(definition));
            this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLAnnotationAssertionAxiom(dataProperty.getIRI(), definitionLiteral)));
        }
    }

    @Override
    public void addDefinedByToClass(String className, String url) throws JPSRuntimeException {
        if (url != null && !url.isEmpty()) {
            OWLClass clas = this.createClass(className);
            OWLAnnotationProperty isDefinedBy = this.dataFactory.getRDFSIsDefinedBy();
            OWLAnnotation definedByLiteral = this.dataFactory.getOWLAnnotation(isDefinedBy, this.dataFactory.getOWLLiteral(url));
            this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLAnnotationAssertionAxiom(clas.getIRI(), definedByLiteral)));
        }
    }

    @Override
    public void addDefinedByToObjectProperty(String property, String url) throws JPSRuntimeException {
        if (url != null && !url.isEmpty()) {
            OWLObjectProperty objectProperty = this.createObjectProperty(property);
            OWLAnnotationProperty isDefinedBy = this.dataFactory.getRDFSIsDefinedBy();
            OWLAnnotation definedByLiteral = this.dataFactory.getOWLAnnotation(isDefinedBy, this.dataFactory.getOWLLiteral(url));
            this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLAnnotationAssertionAxiom(objectProperty.getIRI(), definedByLiteral)));
        }
    }

    @Override
    public void addDefinedByToDataProperty(String property, String url) throws JPSRuntimeException {
        if (url != null && !url.isEmpty()) {
            OWLDataProperty dataProperty = this.createDataProperty(property);
            OWLAnnotationProperty isDefinedBy = this.dataFactory.getRDFSIsDefinedBy();
            OWLAnnotation definedByLiteral = this.dataFactory.getOWLAnnotation(isDefinedBy, this.dataFactory.getOWLLiteral(url));
            this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLAnnotationAssertionAxiom(dataProperty.getIRI(), definedByLiteral)));
        }
    }

    @Override
    public void addLogicalFormulaToObjectProperty(String property, String quantifier, String domain, String range) throws JPSRuntimeException {
        if (!(quantifier == null || quantifier.isEmpty() || domain == null || domain.isEmpty() || range == null || range.isEmpty())) {
            OWLObjectProperty objectProperty = this.createObjectProperty(property);
            OWLClass rangeClass = null;
            OWLObjectUnionOf objectUnionOfRanges = null;
            this.processUnionOfRelationToAddTypeOfLogicalFormula(objectProperty, quantifier, rangeClass, objectUnionOfRanges, domain, range);
        }
    }

    private void processUnionOfRelationToAddTypeOfLogicalFormula(OWLObjectProperty objectProperty, String quantifier, OWLClass rangeClass, OWLObjectUnionOf objectUnionOfRanges, String domain, String range) throws JPSRuntimeException {
        if (range.contains("UNION")) {
            objectUnionOfRanges = this.getUnionOfRange(objectProperty, range.split("UNION"));
        } else {
            rangeClass = this.createClass(range);
        }
        for (String singleDomain : domain.split("UNION")) {
            this.decideToAddTypeOfLogicalFormula(objectProperty, rangeClass, objectUnionOfRanges, quantifier, singleDomain, range);
        }
    }

    private void decideToAddTypeOfLogicalFormula(OWLObjectProperty objectProperty, OWLClass rangeClass, OWLObjectUnionOf objectUnionOfRanges, String quantifier, String singleDomain, String range) throws JPSRuntimeException {
        OWLClass domainClass = this.createClass(singleDomain);
        if (quantifier != null && !quantifier.isEmpty() && quantifier.trim().equalsIgnoreCase("only")) {
            this.addUniversalQuantification(objectProperty, domainClass, rangeClass, objectUnionOfRanges, range);
        } else if (quantifier != null && !quantifier.isEmpty() && quantifier.trim().equalsIgnoreCase("exactly 1")) {
            this.addExactlyOneQuantification(objectProperty, domainClass, rangeClass);
        } else if (quantifier != null && !quantifier.isEmpty() && quantifier.trim().equalsIgnoreCase("minimum 1")) {
            this.addMinimumOneQuantification(objectProperty, domainClass, rangeClass);
        } else if (quantifier != null && !quantifier.isEmpty() && quantifier.trim().equalsIgnoreCase("maximum 1")) {
            this.addMaximumOneQuantification(objectProperty, domainClass, rangeClass);
        }
    }

    private void addUniversalQuantification(OWLObjectProperty objectProperty, OWLClass domainClass, OWLClass rangeClass, OWLObjectUnionOf objectUnionOfRanges, String range) {
        OWLObjectAllValuesFrom restriction = range.contains("UNION") ? this.dataFactory.getOWLObjectAllValuesFrom(objectProperty, objectUnionOfRanges) : this.dataFactory.getOWLObjectAllValuesFrom(objectProperty, rangeClass);
        this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLSubClassOfAxiom(domainClass, restriction)));
    }

    private void addExactlyOneQuantification(OWLObjectProperty objectProperty, OWLClass domainClass, OWLClass rangeClass) {
        OWLObjectExactCardinality restriction = this.dataFactory.getOWLObjectExactCardinality(1, objectProperty, rangeClass);
        this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLSubClassOfAxiom(domainClass, restriction)));
    }

    private void addMinimumOneQuantification(OWLObjectProperty objectProperty, OWLClass domainClass, OWLClass rangeClass) {
        OWLObjectMinCardinality restriction = this.dataFactory.getOWLObjectMinCardinality(1, objectProperty, rangeClass);
        this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLSubClassOfAxiom(domainClass, restriction)));
    }

    private void addMaximumOneQuantification(OWLObjectProperty objectProperty, OWLClass domainClass, OWLClass rangeClass) {
        OWLObjectMaxCardinality restriction = this.dataFactory.getOWLObjectMaxCardinality(1, objectProperty, rangeClass);
        this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLSubClassOfAxiom(domainClass, restriction)));
    }

    @Override
    public void createOWLDataProperty(String propertyName, String type, String targetName, String relation, String domain, String range, String quantifier) throws JPSRuntimeException {
        this.checkPropertyName(propertyName);
        OWLDataProperty dataProperty = this.createDataProperty(propertyName);
        for (String singleType : type.split(",")) {
            switch (singleType.toLowerCase().trim()) {
                case "functional property": {
                    this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLFunctionalDataPropertyAxiom(dataProperty)));
                }
            }
        }
        this.addDomain(dataProperty, domain);
        this.addRange(dataProperty, range);
        OWLDataProperty parentProperty = null;
        if (targetName != null && !targetName.isEmpty() && relation != null && !relation.isEmpty()) {
            parentProperty = this.createDataProperty(targetName);
            if (relation.equalsIgnoreCase(tBoxConfig.getIsARelation())) {
                this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLSubDataPropertyOfAxiom(dataProperty, parentProperty)));
            } else if (relation.equalsIgnoreCase(tBoxConfig.getEquivalentToRelation())) {
                this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLEquivalentDataPropertiesAxiom((OWLDataPropertyExpression)dataProperty, (OWLDataPropertyExpression)parentProperty)));
            }
        }
    }

    @Override
    public void createOWLObjectProperty(String propertyName, String type, String targetName, String relation, String domain, String range, String quantifier) throws JPSRuntimeException {
        this.checkPropertyName(propertyName);
        OWLObjectProperty objectProperty = this.createObjectProperty(propertyName);
        block18: for (String singleType : type.split(",")) {
            switch (singleType.toLowerCase().trim()) {
                case "reflexive property": {
                    this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLReflexiveObjectPropertyAxiom(objectProperty)));
                    continue block18;
                }
                case "transitive property": {
                    this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLTransitiveObjectPropertyAxiom(objectProperty)));
                    continue block18;
                }
                case "symmetric property": {
                    this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLSymmetricObjectPropertyAxiom(objectProperty)));
                    continue block18;
                }
                case "asymmetric property": {
                    this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLAsymmetricObjectPropertyAxiom(objectProperty)));
                    continue block18;
                }
                case "irreflexive property": {
                    this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLIrreflexiveObjectPropertyAxiom(objectProperty)));
                    continue block18;
                }
                case "functional property": {
                    this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLFunctionalObjectPropertyAxiom(objectProperty)));
                    continue block18;
                }
                case "inverse functional property": {
                    this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLInverseFunctionalObjectPropertyAxiom(objectProperty)));
                }
            }
        }
        this.addDomain(objectProperty, domain);
        this.addRange(objectProperty, range, quantifier);
        OWLObjectProperty parentProperty = null;
        if (targetName != null && !targetName.isEmpty() && relation != null && !relation.isEmpty()) {
            parentProperty = this.createObjectProperty(targetName);
            if (relation.equalsIgnoreCase(tBoxConfig.getIsARelation())) {
                this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLSubObjectPropertyOfAxiom(objectProperty, parentProperty)));
            } else if (relation.equalsIgnoreCase(tBoxConfig.getEquivalentToRelation())) {
                this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLEquivalentObjectPropertiesAxiom((OWLObjectPropertyExpression)objectProperty, (OWLObjectPropertyExpression)parentProperty)));
            } else if (relation.equalsIgnoreCase(tBoxConfig.getInverseOfRelation())) {
                this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLInverseObjectPropertiesAxiom(objectProperty, parentProperty)));
            }
        }
    }

    private void addDomain(OWLDataProperty dataProperty, String domain) throws JPSRuntimeException {
        if (domain == null || domain.isEmpty()) {
            return;
        }
        if (domain.contains("UNION")) {
            this.addUnionOfDomain(dataProperty, domain.split("UNION"));
        } else if (domain.contains("INTERSECTION")) {
            this.addIntersectionOfDomain(dataProperty, domain.split("INTERSECTION"));
        } else {
            this.addSingleClassDomain(dataProperty, domain);
        }
    }

    private void addDomain(OWLObjectProperty objectProperty, String domain) throws JPSRuntimeException {
        if (domain == null || domain.isEmpty()) {
            return;
        }
        if (domain.contains("UNION")) {
            this.addUnionOfDomain(objectProperty, domain.split("UNION"));
        } else if (domain.contains("INTERSECTION")) {
            this.addIntersectionOfDomain(objectProperty, domain.split("INTERSECTION"));
        } else if (domain != null || !domain.isEmpty()) {
            this.addSingleClassDomain(objectProperty, domain);
        }
    }

    private void addRange(OWLDataProperty dataProperty, String range) throws JPSRuntimeException {
        if (range == null || range.isEmpty()) {
            return;
        }
        if (!range.contains("UNION") && !range.contains("INTERSECTION")) {
            this.addSingleDataTypeRange(dataProperty, range);
        }
    }

    private void addRange(OWLObjectProperty objectProperty, String range, String quantifier) throws JPSRuntimeException {
        if (range == null || range.isEmpty()) {
            return;
        }
        if (range.contains("UNION")) {
            this.addUnionOfRange(objectProperty, range.split("UNION"));
        } else if (range.contains("INTERSECTION")) {
            this.addIntersectionOfRange(objectProperty, range.split("INTERSECTION"));
        } else if (range != null || !range.isEmpty()) {
            this.addSingleClassRange(objectProperty, range);
        }
    }

    private void addSingleClassDomain(OWLDataProperty dataProperty, String domain) throws JPSRuntimeException {
        OWLClass owlClass = this.createClass(domain);
        this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLDataPropertyDomainAxiom(dataProperty, owlClass)));
    }

    private void addSingleClassDomain(OWLObjectProperty objectProperty, String domain) throws JPSRuntimeException {
        OWLClass owlClass = this.createClass(domain);
        this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLObjectPropertyDomainAxiom(objectProperty, owlClass)));
    }

    private void addSingleDataTypeRange(OWLDataProperty dataProperty, String range) throws JPSRuntimeException {
        if (range.trim().startsWith(HTTP_PROTOCOL) || range.trim().startsWith(HTTPS_PROTOCOL)) {
            this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)dataProperty, this.dataFactory.getOWLDatatype(range))));
        } else {
            this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)dataProperty, this.getRange(range))));
        }
    }

    private void addSingleClassRange(OWLObjectProperty objectProperty, String range) throws JPSRuntimeException {
        this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLObjectPropertyRangeAxiom(objectProperty, this.createClass(range))));
    }

    private void addUnionOfRange(OWLObjectProperty objectProperty, String[] ranges) throws JPSRuntimeException {
        HashSet<OWLClass> owlClassExpressions = new HashSet<OWLClass>();
        for (String range : ranges) {
            owlClassExpressions.add(this.createClass(range));
        }
        this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLObjectPropertyRangeAxiom(objectProperty, this.dataFactory.getOWLObjectUnionOf(owlClassExpressions))));
    }

    private OWLObjectUnionOf getUnionOfRange(OWLObjectProperty objectProperty, String[] ranges) throws JPSRuntimeException {
        HashSet<OWLClass> owlClassExpressions = new HashSet<OWLClass>();
        for (String range : ranges) {
            owlClassExpressions.add(this.createClass(range));
        }
        return this.dataFactory.getOWLObjectUnionOf(owlClassExpressions);
    }

    private void addIntersectionOfRange(OWLObjectProperty objectProperty, String[] ranges) throws JPSRuntimeException {
        HashSet<OWLClass> owlClassExpressions = new HashSet<OWLClass>();
        for (String range : ranges) {
            owlClassExpressions.add(this.createClass(range));
        }
        this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLObjectPropertyRangeAxiom(objectProperty, this.dataFactory.getOWLObjectIntersectionOf(owlClassExpressions))));
    }

    private void addUnionOfDomain(OWLObjectProperty objectProperty, String[] domains) throws JPSRuntimeException {
        HashSet<OWLClass> owlClassExpressions = new HashSet<OWLClass>();
        for (String domain : domains) {
            owlClassExpressions.add(this.createClass(domain));
        }
        this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLObjectPropertyDomainAxiom(objectProperty, this.dataFactory.getOWLObjectUnionOf(owlClassExpressions))));
    }

    private OWLObjectUnionOf getUnionOfDomain(OWLObjectProperty objectProperty, String[] domains) throws JPSRuntimeException {
        HashSet<OWLClass> owlClassExpressions = new HashSet<OWLClass>();
        for (String domain : domains) {
            owlClassExpressions.add(this.createClass(domain));
        }
        this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLObjectPropertyDomainAxiom(objectProperty, this.dataFactory.getOWLObjectUnionOf(owlClassExpressions))));
        return this.dataFactory.getOWLObjectUnionOf(owlClassExpressions);
    }

    private void addIntersectionOfDomain(OWLObjectProperty objectProperty, String[] domains) throws JPSRuntimeException {
        HashSet<OWLClass> owlClassExpressions = new HashSet<OWLClass>();
        for (String domain : domains) {
            owlClassExpressions.add(this.createClass(domain));
        }
        this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLObjectPropertyDomainAxiom(objectProperty, this.dataFactory.getOWLObjectIntersectionOf(owlClassExpressions))));
    }

    private void addUnionOfDomain(OWLDataProperty dataProperty, String[] domains) throws JPSRuntimeException {
        HashSet<OWLClass> owlClassExpressions = new HashSet<OWLClass>();
        for (String domain : domains) {
            owlClassExpressions.add(this.createClass(domain));
        }
        this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLDataPropertyDomainAxiom(dataProperty, this.dataFactory.getOWLObjectUnionOf(owlClassExpressions))));
    }

    private void addIntersectionOfDomain(OWLDataProperty dataProperty, String[] domains) throws JPSRuntimeException {
        HashSet<OWLClass> owlClassExpressions = new HashSet<OWLClass>();
        for (String domain : domains) {
            owlClassExpressions.add(this.createClass(domain));
        }
        this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLDataPropertyDomainAxiom(dataProperty, this.dataFactory.getOWLObjectIntersectionOf(owlClassExpressions))));
    }

    private OWL2Datatype getRange(String range) {
        switch (range.toLowerCase()) {
            case "string": {
                return OWL2Datatype.XSD_STRING;
            }
            case "integer": {
                return OWL2Datatype.XSD_INTEGER;
            }
            case "int": {
                return OWL2Datatype.XSD_INT;
            }
            case "float": {
                return OWL2Datatype.XSD_FLOAT;
            }
            case "double": {
                return OWL2Datatype.XSD_DOUBLE;
            }
            case "date time": {
                return OWL2Datatype.XSD_DATE_TIME;
            }
            case "date time stamp": {
                return OWL2Datatype.XSD_DATE_TIME_STAMP;
            }
            case "boolean": {
                return OWL2Datatype.XSD_BOOLEAN;
            }
            case "long": {
                return OWL2Datatype.XSD_LONG;
            }
            case "decimal": {
                return OWL2Datatype.XSD_DECIMAL;
            }
            case "negative integer": {
                return OWL2Datatype.XSD_NEGATIVE_INTEGER;
            }
            case "non negative integer": {
                return OWL2Datatype.XSD_NON_NEGATIVE_INTEGER;
            }
            case "non positive integer": {
                return OWL2Datatype.XSD_NON_POSITIVE_INTEGER;
            }
            case "rational": {
                return OWL2Datatype.OWL_RATIONAL;
            }
            case "real": {
                return OWL2Datatype.OWL_REAL;
            }
            case "literal": {
                return OWL2Datatype.RDFS_LITERAL;
            }
            case "lang string": {
                return OWL2Datatype.RDF_LANG_STRING;
            }
            case "plain literal": {
                return OWL2Datatype.RDF_PLAIN_LITERAL;
            }
            case "xml literal": {
                return OWL2Datatype.RDF_XML_LITERAL;
            }
            case "any uri": {
                return OWL2Datatype.XSD_ANY_URI;
            }
            case "base 64 binary": {
                return OWL2Datatype.XSD_BASE_64_BINARY;
            }
            case "byte": {
                return OWL2Datatype.XSD_BYTE;
            }
            case "hex binary": {
                return OWL2Datatype.XSD_HEX_BINARY;
            }
            case "language": {
                return OWL2Datatype.XSD_LANGUAGE;
            }
            case "name": {
                return OWL2Datatype.XSD_NAME;
            }
            case "ncname": {
                return OWL2Datatype.XSD_NCNAME;
            }
            case "nmtoken": {
                return OWL2Datatype.XSD_NMTOKEN;
            }
            case "normalized string": {
                return OWL2Datatype.XSD_NORMALIZED_STRING;
            }
            case "positive integer": {
                return OWL2Datatype.XSD_POSITIVE_INTEGER;
            }
            case "short": {
                return OWL2Datatype.XSD_SHORT;
            }
            case "token": {
                return OWL2Datatype.XSD_TOKEN;
            }
            case "unsigned byte": {
                return OWL2Datatype.XSD_UNSIGNED_BYTE;
            }
            case "unsigned int": {
                return OWL2Datatype.XSD_UNSIGNED_INT;
            }
            case "unsigned long": {
                return OWL2Datatype.XSD_UNSIGNED_LONG;
            }
            case "unsigned short": {
                return OWL2Datatype.XSD_UNSIGNED_SHORT;
            }
        }
        this.logger.warn("The following data type is not valid:" + range + ". Now the converter will proceed with the string data type.");
        return OWL2Datatype.XSD_STRING;
    }

    private OWLClass createClass(String className) throws JPSRuntimeException {
        String[] classLabels = className.contains(",") ? className.split(",") : new String[]{className};
        return this.createClass(classLabels);
    }

    private OWLClass createClass(String[] classLabels) throws JPSRuntimeException {
        if (tBoxConfig.gettBoxIri() == null || tBoxConfig.gettBoxIri().isEmpty()) {
            this.logger.error("TBox IRI is not provided in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
            throw new JPSRuntimeException("TBox IRI must be provided in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
        }
        if (this.ontology == null) {
            this.logger.error("TBox IRI is missing in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
            throw new JPSRuntimeException("TBox IRI must be provided in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
        }
        OWLClass classInOwl = null;
        int labelSequence = 0;
        for (String classLabel : classLabels) {
            if (++labelSequence >= 2) continue;
            this.checkClassName(classLabel);
            classInOwl = classLabel.trim().startsWith(HTTP_PROTOCOL) || classLabel.trim().startsWith(HTTPS_PROTOCOL) ? this.dataFactory.getOWLClass(classLabel.replace(" ", "")) : (tBoxConfig.gettBoxIri().endsWith(this.SLASH) ? this.dataFactory.getOWLClass(tBoxConfig.gettBoxIri().concat(classLabel.replace(" ", ""))) : this.dataFactory.getOWLClass(tBoxConfig.gettBoxIri().concat("#").concat(classLabel.replace(" ", ""))));
        }
        return classInOwl;
    }

    private OWLDataProperty createDataProperty(String propertyLabel) throws JPSRuntimeException {
        if (tBoxConfig.gettBoxIri() == null || tBoxConfig.gettBoxIri().isEmpty()) {
            this.logger.error("TBox IRI is not provided in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
            throw new JPSRuntimeException("TBox IRI must be provided in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
        }
        if (this.ontology == null) {
            this.logger.error("TBox IRI is missing in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
            throw new JPSRuntimeException("TBox IRI must be provided in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
        }
        if (propertyLabel.trim().startsWith(HTTP_PROTOCOL) || propertyLabel.trim().startsWith(HTTPS_PROTOCOL)) {
            return this.dataFactory.getOWLDataProperty(propertyLabel.replace(" ", ""));
        }
        if (tBoxConfig.gettBoxIri().endsWith(this.SLASH)) {
            return this.dataFactory.getOWLDataProperty(tBoxConfig.gettBoxIri().concat(propertyLabel.replace(" ", "")));
        }
        return this.dataFactory.getOWLDataProperty(tBoxConfig.gettBoxIri().concat("#").concat(propertyLabel.replace(" ", "")));
    }

    private OWLObjectProperty createObjectProperty(String propertyLabel) throws JPSRuntimeException {
        if (tBoxConfig.gettBoxIri() == null || tBoxConfig.gettBoxIri().isEmpty()) {
            this.logger.error("TBox IRI is not provided in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
            throw new JPSRuntimeException("TBox IRI must be provided in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
        }
        if (this.ontology == null) {
            this.logger.error("TBox IRI is missing in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
            throw new JPSRuntimeException("TBox IRI must be provided in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
        }
        if (propertyLabel.trim().startsWith(HTTP_PROTOCOL) || propertyLabel.trim().startsWith(HTTPS_PROTOCOL)) {
            return this.dataFactory.getOWLObjectProperty(propertyLabel.replace(" ", ""));
        }
        if (tBoxConfig.gettBoxIri().endsWith(this.SLASH)) {
            return this.dataFactory.getOWLObjectProperty(tBoxConfig.gettBoxIri().concat(propertyLabel.replace(" ", "")));
        }
        return this.dataFactory.getOWLObjectProperty(tBoxConfig.gettBoxIri().concat("#").concat(propertyLabel.replace(" ", "")));
    }

    private void checkClassName(String className) throws JPSRuntimeException {
        if (className == null) {
            this.logger.error("Class name is null.");
            throw new JPSRuntimeException("Class name is null.");
        }
        if (className.isEmpty()) {
            this.logger.error("Class name is empty.");
            throw new JPSRuntimeException("Class name is empty.");
        }
    }

    private void checkPropertyName(String propertyName) throws JPSRuntimeException {
        if (propertyName == null) {
            this.logger.error("Property name is null.");
            throw new JPSRuntimeException("Property name is null.");
        }
        if (propertyName.isEmpty()) {
            this.logger.error("Property name is empty.");
            throw new JPSRuntimeException("Property name is empty.");
        }
    }

    @Override
    public void init() throws JPSRuntimeException, OWLOntologyCreationException {
        applicationContext = new AnnotationConfigApplicationContext(SpringConfiguration.class);
        tBoxConfig = applicationContext.getBean(TBoxConfiguration.class);
    }

    @Override
    public void instantiateOntologyModel() throws OWLOntologyCreationException {
        if (this.ontologyIRI == null) {
            if (tBoxConfig.gettBoxIri() == null || tBoxConfig.gettBoxIri().isEmpty()) {
                this.logger.error("TBox IRI must be provided.");
                throw new JPSRuntimeException("TBox IRI must be provided.");
            }
            if (!new UrlValidator().isValid(tBoxConfig.gettBoxIri())) {
                this.logger.error("Provided TBox IRI is not a valid:" + tBoxConfig.gettBoxIri());
                throw new JPSRuntimeException("Provided TBox IRI is not a valid:" + tBoxConfig.gettBoxIri());
            }
            this.ontologyIRI = IRI.create(tBoxConfig.gettBoxIri());
        }
        this.ontology = this.manager.createOntology(this.ontologyIRI);
        if (this.ontology == null) {
            this.logger.error("The requested ontology could not be created.");
            throw new JPSRuntimeException("Ontology could not be created.");
        }
    }

    @Override
    public void saveOntology(String owlFilePath) throws OWLOntologyStorageException {
        try {
            if (this.getOntologyFileNameFromIri(tBoxConfig.gettBoxIri()) == null || this.getOntologyFileNameFromIri(tBoxConfig.gettBoxIri()).isEmpty()) {
                throw new OWLOntologyStorageException("Invalid TBox file name provided.");
            }
            File file = new File(owlFilePath);
            this.representOntologyMetadata();
            if (tBoxConfig.gettBoxImport() != null && tBoxConfig.gettBoxImport().length() > HTTP_PROTOCOL.length()) {
                for (String ontologyBeingImported : tBoxConfig.gettBoxImport().split(",")) {
                    if (!ontologyBeingImported.trim().startsWith(HTTP_PROTOCOL) && !ontologyBeingImported.trim().startsWith(HTTPS_PROTOCOL)) continue;
                    OWLImportsDeclaration importDeclarationABox = this.dataFactory.getOWLImportsDeclaration(IRI.create(ontologyBeingImported.trim()));
                    this.manager.applyChange(new AddImport(this.ontology, importDeclarationABox));
                }
            }
            this.manager.saveOntology(this.ontology, this.manager.getOntologyFormat(this.ontology), IRI.create(file.toURI()));
            this.logger.info("The TBox has been saved at the path of " + owlFilePath);
        }
        catch (OWLOntologyStorageException e) {
            this.logger.error("The ontology could not be saved.");
            e.printStackTrace();
            throw new OWLOntologyStorageException("The ontology could not be saved.");
        }
        catch (JPSRuntimeException e) {
            this.logger.error("The ontology-code commit hash could not be retrieved.");
            e.printStackTrace();
            throw new OWLOntologyStorageException("The ontology-code commit hash could not be retrieved.");
        }
    }

    private void addDataProperty(IRI iri, String propertyValue, String individialName) throws JPSRuntimeException {
        OWLDataProperty identifierProperty = this.dataFactory.getOWLDataProperty(iri);
        this.addDataProperty(identifierProperty, propertyValue, individialName);
    }

    private void addDataProperty(OWLDataProperty identifierProperty, String propertyValue, String individialName) throws JPSRuntimeException {
        OWLLiteral literal = this.createOWLLiteral(this.dataFactory, propertyValue);
        OWLNamedIndividual individual = this.ontologyIRI.toString().endsWith(this.SLASH) ? this.dataFactory.getOWLNamedIndividual(this.ontologyIRI.toString().concat(individialName)) : this.dataFactory.getOWLNamedIndividual(this.ontologyIRI.toString().concat("#").concat(individialName));
        this.manager.applyChange(new AddAxiom(this.ontology, this.dataFactory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)identifierProperty, (OWLIndividual)individual, literal)));
    }

    private OWLLiteral createOWLLiteral(OWLDataFactory ontoFactory, String literal) {
        return ontoFactory.getOWLLiteral(literal);
    }

    private void representOntologyMetadata() throws JPSRuntimeException {
        this.representComment();
        this.representDateOfGeneration();
        this.representVersion();
        this.representCommitHash();
    }

    private void representComment() throws JPSRuntimeException {
        String comment = tBoxConfig.gettBoxComment();
        if (comment != null && !comment.isEmpty()) {
            OWLLiteral commentValue = this.dataFactory.getOWLLiteral(comment);
            OWLAnnotationProperty commentProperty = this.dataFactory.getRDFSComment();
            OWLAnnotation commentPropertyAttributeWithValue = this.dataFactory.getOWLAnnotation(commentProperty, commentValue);
            this.manager.applyChange(new AddOntologyAnnotation(this.ontology, commentPropertyAttributeWithValue));
        }
    }

    private void representCommitHash() throws JPSRuntimeException {
        String commitHash = tBoxConfig.getGitCommitHashValue();
        if (commitHash != null && !commitHash.isEmpty()) {
            OWLLiteral commitHashValue = this.dataFactory.getOWLLiteral(commitHash);
            OWLAnnotationProperty commit = tBoxConfig.gettBoxIri().endsWith(this.SLASH) ? this.dataFactory.getOWLAnnotationProperty(IRI.create(tBoxConfig.gettBoxIri().concat(tBoxConfig.getCompChemGitCommitHash()))) : this.dataFactory.getOWLAnnotationProperty(IRI.create(tBoxConfig.gettBoxIri().concat("#").concat(tBoxConfig.getCompChemGitCommitHash())));
            OWLAnnotation commitAttributeWithValue = this.dataFactory.getOWLAnnotation(commit, commitHashValue);
            this.manager.applyChange(new AddOntologyAnnotation(this.ontology, commitAttributeWithValue));
        }
    }

    private void representVersion() throws JPSRuntimeException {
        String version = tBoxConfig.gettBoxVersion();
        if (version != null && !version.isEmpty()) {
            OWLLiteral versionValue = this.dataFactory.getOWLLiteral(version);
            OWLAnnotationProperty versionProperty = this.dataFactory.getOWLAnnotationProperty(OWL_URL.concat(OWL_VERSIONINFO));
            OWLAnnotation versionAttributeWithValue = this.dataFactory.getOWLAnnotation(versionProperty, versionValue);
            this.manager.applyChange(new AddOntologyAnnotation(this.ontology, versionAttributeWithValue));
        }
    }

    private void representDateOfGeneration() throws JPSRuntimeException {
        String date = tBoxConfig.getAnnotationPropertyDate();
        if (date != null && !date.isEmpty()) {
            OWLLiteral dateValue = this.dataFactory.getOWLLiteral(this.getCurrentDate());
            OWLAnnotationProperty dateProperty = this.dataFactory.getOWLAnnotationProperty(date);
            OWLAnnotation versionAttributeWithValue = this.dataFactory.getOWLAnnotation(dateProperty, dateValue);
            this.manager.applyChange(new AddOntologyAnnotation(this.ontology, versionAttributeWithValue));
        }
    }

    private String getCurrentDate() {
        String pattern = "dd MMMM yyyy";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern, new Locale("en", "UK"));
        String date = simpleDateFormat.format(new Date());
        return date;
    }

    private String getOntologyFileNameFromIri(String iri) {
        String[] tokens = iri.split(this.SLASH);
        if (iri.endsWith(this.SLASH)) {
            return tokens[tokens.length - 2];
        }
        if (iri.contains(this.SLASH)) {
            return tokens[tokens.length - 1];
        }
        return null;
    }
}

