/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import it.unimi.dsi.bits.Fast;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Random;

public class BloomFilter2
implements Externalizable {
    private static final long serialVersionUID = -880117129471136320L;
    private static final transient boolean DEBUG = false;
    private static final transient int VERSION0 = 0;
    private int size;
    public static final transient long MAX_BITS = 137438953408L;
    private static final transient long LOG2_LONG_SIZE = 6L;
    private static final transient long BIT_INDEX_MASK = 63L;
    public static final transient int NUMBER_OF_WEIGHTS = 16;
    private long m;
    private int d;
    private long[] bits;
    private int[][] weight;
    private int[] init;
    private static final transient double NATURAL_LOG_OF_2 = Math.log(2.0);

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        int version = in.readInt();
        if (version != 0) {
            throw new IOException("Unknown version=" + version);
        }
        this.size = in.readInt();
        this.m = in.readLong();
        this.d = in.readInt();
        this.bits = new long[(int)this.m / 64];
        for (i = 0; i < this.bits.length; ++i) {
            this.bits[i] = in.readLong();
        }
        this.weight = new int[this.d][16];
        for (i = 0; i < this.d; ++i) {
            this.weight[i] = new int[16];
            for (int j = 0; j < 16; ++j) {
                this.weight[i][j] = in.readInt();
            }
        }
        this.init = new int[this.d];
        for (i = 0; i < this.d; ++i) {
            this.init[i] = in.readInt();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int i;
        out.writeInt(0);
        out.writeInt(this.size);
        out.writeLong(this.m);
        out.writeInt(this.d);
        for (i = 0; i < this.bits.length; ++i) {
            out.writeLong(this.bits[i]);
        }
        for (i = 0; i < this.d; ++i) {
            for (int j = 0; j < 16; ++j) {
                out.writeInt(this.weight[i][j]);
            }
        }
        for (i = 0; i < this.d; ++i) {
            out.writeInt(this.init[i]);
        }
    }

    public final long m() {
        return this.m;
    }

    public final int d() {
        return this.d;
    }

    public BloomFilter2() {
    }

    public BloomFilter2(int n) {
        this(n, Fast.mostSignificantBit(n) + 1);
    }

    public BloomFilter2(int n, int d) {
        this.d = d;
        long wantedNumberOfBits = (long)Math.ceil((double)n * ((double)d / NATURAL_LOG_OF_2));
        if (wantedNumberOfBits > 137438953408L) {
            throw new IllegalArgumentException("The wanted number of bits (" + wantedNumberOfBits + ") is larger than " + 137438953408L);
        }
        this.bits = new long[(int)((wantedNumberOfBits + 64L - 1L) / 64L)];
        this.m = (long)this.bits.length * 64L;
        Random rand = new Random();
        this.weight = new int[d][];
        this.init = new int[d];
        for (int i = 0; i < d; ++i) {
            this.weight[i] = new int[16];
            this.init[i] = rand.nextInt();
            for (int j = 0; j < 16; ++j) {
                this.weight[i][j] = rand.nextInt();
            }
        }
    }

    private static boolean get(long[] bits, long index) {
        return (bits[(int)(index >> 6)] & 1L << (int)(index & 0x3FL)) != 0L;
    }

    private boolean set(long[] bits, long index) {
        int unit = (int)(index >> 6);
        long mask = 1L << (int)(index & 0x3FL);
        boolean result = (bits[unit] & mask) != 0L;
        int n = unit;
        bits[n] = bits[n] | mask;
        return result;
    }

    private long hash(CharSequence s, int l, int k) {
        int[] w = this.weight[k];
        long h = this.init[k];
        int i = l;
        while (i-- != 0) {
            h ^= (h << 5) + (long)(s.charAt(i) * w[i % 16]) + (h >>> 2);
        }
        return (h & Long.MAX_VALUE) % this.m;
    }

    private long hash(byte[] a, int l, int k) {
        int[] w = this.weight[k];
        long h = this.init[k];
        int i = l;
        while (i-- != 0) {
            h ^= (h << 5) + (long)(a[i] * w[i % 16]) + (h >>> 2);
        }
        return (h & Long.MAX_VALUE) % this.m;
    }

    private long hash(short[] a, int l, int k) {
        int[] w = this.weight[k];
        long h = this.init[k];
        int i = l;
        while (i-- != 0) {
            h ^= (h << 5) + (long)(a[i] * w[i % 16]) + (h >>> 2);
        }
        return (h & Long.MAX_VALUE) % this.m;
    }

    private long hash(char[] a, int l, int k) {
        int[] w = this.weight[k];
        long h = this.init[k];
        int i = l;
        while (i-- != 0) {
            h ^= (h << 5) + (long)(a[i] * w[i % 16]) + (h >>> 2);
        }
        return (h & Long.MAX_VALUE) % this.m;
    }

    private long hash(int[] a, int l, int k) {
        int[] w = this.weight[k];
        long h = this.init[k];
        int i = l;
        while (i-- != 0) {
            h ^= (h << 5) + (long)(a[i] * w[i % 16]) + (h >>> 2);
        }
        return (h & Long.MAX_VALUE) % this.m;
    }

    private long hash(long[] a, int l, int k) {
        int[] w = this.weight[k];
        long h = this.init[k];
        int i = l;
        while (i-- != 0) {
            h ^= (h << 5) + a[i] * (long)w[i % 16] + (h >>> 2);
        }
        return (h & Long.MAX_VALUE) % this.m;
    }

    private long hash(float[] a, int l, int k) {
        int[] w = this.weight[k];
        long h = this.init[k];
        int i = l;
        while (i-- != 0) {
            h ^= (h << 5) + (long)(Float.floatToRawIntBits(a[i]) * w[i % 16]) + (h >>> 2);
        }
        return (h & Long.MAX_VALUE) % this.m;
    }

    private long hash(double[] a, int l, int k) {
        int[] w = this.weight[k];
        long h = this.init[k];
        int i = l;
        while (i-- != 0) {
            h ^= (h << 5) + Double.doubleToRawLongBits(a[i]) * (long)w[i % 16] + (h >>> 2);
        }
        return (h & Long.MAX_VALUE) % this.m;
    }

    public boolean contains(CharSequence s) {
        int i = this.d;
        int l = s.length();
        long[] bits = this.bits;
        while (i-- != 0) {
            if (BloomFilter2.get(bits, this.hash(s, l, i))) continue;
            return false;
        }
        return true;
    }

    public boolean contains(byte[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        while (i-- != 0) {
            if (BloomFilter2.get(bits, this.hash(a, l, i))) continue;
            return false;
        }
        return true;
    }

    public boolean contains(short[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        while (i-- != 0) {
            if (BloomFilter2.get(bits, this.hash(a, l, i))) continue;
            return false;
        }
        return true;
    }

    public boolean contains(char[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        while (i-- != 0) {
            if (BloomFilter2.get(bits, this.hash(a, l, i))) continue;
            return false;
        }
        return true;
    }

    public boolean contains(int[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        while (i-- != 0) {
            if (BloomFilter2.get(bits, this.hash(a, l, i))) continue;
            return false;
        }
        return true;
    }

    public boolean contains(long[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        while (i-- != 0) {
            if (BloomFilter2.get(bits, this.hash(a, l, i))) continue;
            return false;
        }
        return true;
    }

    public boolean contains(float[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        while (i-- != 0) {
            if (BloomFilter2.get(bits, this.hash(a, l, i))) continue;
            return false;
        }
        return true;
    }

    public boolean contains(double[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        while (i-- != 0) {
            if (BloomFilter2.get(bits, this.hash(a, l, i))) continue;
            return false;
        }
        return true;
    }

    public boolean add(CharSequence s) {
        int i = this.d;
        int l = s.length();
        long[] bits = this.bits;
        boolean alreadySet = true;
        while (i-- != 0) {
            alreadySet &= this.set(bits, this.hash(s, l, i));
        }
        if (!alreadySet) {
            ++this.size;
        }
        return !alreadySet;
    }

    public boolean add(byte[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        boolean alreadySet = true;
        while (i-- != 0) {
            alreadySet &= this.set(bits, this.hash(a, l, i));
        }
        if (!alreadySet) {
            ++this.size;
        }
        return !alreadySet;
    }

    public boolean add(short[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        boolean alreadySet = true;
        while (i-- != 0) {
            alreadySet &= this.set(bits, this.hash(a, l, i));
        }
        if (!alreadySet) {
            ++this.size;
        }
        return !alreadySet;
    }

    public boolean add(char[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        boolean alreadySet = true;
        while (i-- != 0) {
            alreadySet &= this.set(bits, this.hash(a, l, i));
        }
        if (!alreadySet) {
            ++this.size;
        }
        return !alreadySet;
    }

    public boolean add(int[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        boolean alreadySet = true;
        while (i-- != 0) {
            alreadySet &= this.set(bits, this.hash(a, l, i));
        }
        if (!alreadySet) {
            ++this.size;
        }
        return !alreadySet;
    }

    public boolean add(long[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        boolean alreadySet = true;
        while (i-- != 0) {
            alreadySet &= this.set(bits, this.hash(a, l, i));
        }
        if (!alreadySet) {
            ++this.size;
        }
        return !alreadySet;
    }

    public boolean add(float[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        boolean alreadySet = true;
        while (i-- != 0) {
            alreadySet &= this.set(bits, this.hash(a, l, i));
        }
        if (!alreadySet) {
            ++this.size;
        }
        return !alreadySet;
    }

    public boolean add(double[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        boolean alreadySet = true;
        while (i-- != 0) {
            alreadySet &= this.set(bits, this.hash(a, l, i));
        }
        if (!alreadySet) {
            ++this.size;
        }
        return !alreadySet;
    }

    public void clear() {
        Arrays.fill(this.bits, 0L);
        this.size = 0;
    }

    public long size() {
        return this.size;
    }
}

