/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdflink;

import java.util.function.Consumer;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionBuilder;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.TxnType;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdflink.LibRDFLink;
import org.apache.jena.rdflink.RDFLink;
import org.apache.jena.rdflink.RDFLinkAdapter;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecApp;
import org.apache.jena.sparql.exec.QueryExecMod;
import org.apache.jena.sparql.exec.QueryExecutionAdapter;
import org.apache.jena.sparql.exec.QueryExecutionBuilderAdapter;
import org.apache.jena.sparql.exec.QueryExecutionCompat;
import org.apache.jena.sparql.exec.ResultSetAdapter;
import org.apache.jena.sparql.exec.UpdateExecutionBuilderAdapter;
import org.apache.jena.update.UpdateExecutionBuilder;
import org.apache.jena.update.UpdateRequest;

public class RDFConnectionAdapter
implements RDFConnection {
    private final RDFLink other;

    public static RDFConnection adapt(RDFLink link) {
        if (link instanceof RDFLinkAdapter) {
            return ((RDFLinkAdapter)link).getConnection();
        }
        return new RDFConnectionAdapter(link);
    }

    protected RDFLink get() {
        return this.other;
    }

    public RDFLink getLink() {
        return this.get();
    }

    protected RDFConnectionAdapter(RDFLink conn) {
        this.other = conn;
    }

    @Override
    public void queryResultSet(String queryString, Consumer<ResultSet> resultSetAction) {
        this.get().queryRowSet(queryString, rowSet -> resultSetAction.accept((ResultSet)new ResultSetAdapter(rowSet)));
    }

    @Override
    public void queryResultSet(Query query, Consumer<ResultSet> resultSetAction) {
        this.get().queryRowSet(query, rowSet -> resultSetAction.accept((ResultSet)new ResultSetAdapter(rowSet)));
    }

    @Override
    public Model queryConstruct(String queryString) {
        return LibRDFLink.graph2model(this.get().queryConstruct(queryString));
    }

    @Override
    public Model queryConstruct(Query query) {
        return LibRDFLink.graph2model(this.get().queryConstruct(query));
    }

    @Override
    public Model queryDescribe(String queryString) {
        return LibRDFLink.graph2model(this.get().queryDescribe(queryString));
    }

    @Override
    public Model queryDescribe(Query query) {
        return LibRDFLink.graph2model(this.get().queryDescribe(query));
    }

    @Override
    public boolean queryAsk(String queryString) {
        return this.get().queryAsk(queryString);
    }

    @Override
    public boolean queryAsk(Query query) {
        return this.get().queryAsk(query);
    }

    @Override
    public QueryExecution query(Query query) {
        return RDFConnectionAdapter.adapt(this.get().query(query));
    }

    @Override
    public QueryExecution query(String queryString) {
        return RDFConnectionAdapter.adapt(this.get().query(queryString));
    }

    @Override
    public QueryExecutionBuilder newQuery() {
        return new QueryExecutionBuilderAdapter(this.get().newQuery());
    }

    @Override
    public UpdateExecutionBuilder newUpdate() {
        return new UpdateExecutionBuilderAdapter(this.get().newUpdate());
    }

    private static QueryExecution adapt(QueryExec queryExec) {
        if (queryExec instanceof QueryExecApp) {
            QueryExecMod builder = ((QueryExecApp)queryExec).getBuilder();
            Dataset ds = null;
            if (queryExec.getDataset() != null) {
                ds = DatasetFactory.wrap((DatasetGraph)queryExec.getDataset());
            }
            return QueryExecutionCompat.compatibility((QueryExecMod)builder, (Dataset)ds, (Query)queryExec.getQuery(), (String)queryExec.getQueryString());
        }
        return QueryExecutionAdapter.adapt((QueryExec)queryExec);
    }

    @Override
    public void update(UpdateRequest update) {
        this.get().update(update);
    }

    @Override
    public void update(String update) {
        this.get().update(update);
    }

    @Override
    public Model fetch() {
        return LibRDFLink.graph2model(this.get().get());
    }

    @Override
    public Model fetch(String graphName) {
        return LibRDFLink.graph2model(this.get().get(LibRDFLink.name(graphName)));
    }

    @Override
    public void load(String graphName, String file) {
        this.get().load(LibRDFLink.name(graphName), file);
    }

    @Override
    public void load(String file) {
        this.get().load(file);
    }

    @Override
    public void load(String graphName, Model model) {
        this.get().load(LibRDFLink.name(graphName), LibRDFLink.model2graph(model));
    }

    @Override
    public void load(Model model) {
        this.get().load(LibRDFLink.model2graph(model));
    }

    @Override
    public void put(String graphName, String file) {
        this.get().put(LibRDFLink.name(graphName), file);
    }

    @Override
    public void put(String file) {
        this.get().put(file);
    }

    @Override
    public void put(String graphName, Model model) {
        this.get().put(LibRDFLink.name(graphName), LibRDFLink.model2graph(model));
    }

    @Override
    public void put(Model model) {
        this.get().put(LibRDFLink.model2graph(model));
    }

    @Override
    public void delete(String graphName) {
        this.get().delete(LibRDFLink.name(graphName));
    }

    @Override
    public void delete() {
        this.get().delete();
    }

    @Override
    public Dataset fetchDataset() {
        return LibRDFLink.asDataset(this.get().getDataset());
    }

    @Override
    public void loadDataset(String file) {
        this.get().loadDataset(file);
    }

    @Override
    public void loadDataset(Dataset dataset) {
        this.get().loadDataset(LibRDFLink.asDatasetGraph(dataset));
    }

    @Override
    public void putDataset(String file) {
        this.get().putDataset(file);
    }

    @Override
    public void putDataset(Dataset dataset) {
        this.get().putDataset(LibRDFLink.asDatasetGraph(dataset));
    }

    @Override
    public boolean isClosed() {
        return this.get().isClosed();
    }

    @Override
    public void close() {
        this.get().close();
    }

    public void begin(TxnType type) {
        this.get().begin(type);
    }

    public void begin(ReadWrite readWrite) {
        this.get().begin(readWrite);
    }

    public boolean promote(Transactional.Promote mode) {
        return this.get().promote(mode);
    }

    public void commit() {
        this.get().commit();
    }

    public void abort() {
        this.get().abort();
    }

    public void end() {
        this.get().end();
    }

    public ReadWrite transactionMode() {
        return this.get().transactionMode();
    }

    public TxnType transactionType() {
        return this.get().transactionType();
    }

    public boolean isInTransaction() {
        return this.get().isInTransaction();
    }
}

