/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.ndx.pipeline;

import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import com.bigdata.service.AbstractFederation;
import com.bigdata.service.ndx.pipeline.AbstractPendingSetMasterTask;
import com.bigdata.service.ndx.pipeline.AbstractPendingSetSubtask;
import com.bigdata.service.ndx.pipeline.AbstractRunnableMasterStats;
import com.bigdata.service.ndx.pipeline.AbstractSubtask;
import com.bigdata.service.ndx.pipeline.AbstractSubtaskStats;
import com.bigdata.service.ndx.pipeline.SubtaskOp;
import com.bigdata.util.concurrent.MovingAverageTask;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractPendingSetMasterStats<L, HS extends AbstractSubtaskStats>
extends AbstractRunnableMasterStats<L, HS> {
    public AbstractPendingSetMasterStats(AbstractFederation<?> fed) {
        super(fed);
    }

    @Override
    protected PendingSetStatisticsTask newStatisticsTask() {
        return new PendingSetStatisticsTask();
    }

    public CounterSet getCounters() {
        final PendingSetStatisticsTask statisticsTask = (PendingSetStatisticsTask)this.statisticsTask;
        CounterSet t = super.getCounterSet();
        t.addCounter("averageMasterPendingSetSize", new Instrument<Double>(){

            @Override
            public void sample() {
                this.setValue(statisticsTask.averageMasterPendingSetSize.getMovingAverage());
            }
        });
        t.addCounter("averageSinkPendingSetSize", new Instrument<Double>(){

            @Override
            public void sample() {
                this.setValue(statisticsTask.averageSinkPendingSetSize.getMovingAverage());
            }
        });
        t.addCounter("averageMaximumSinkPendingSetSize", new Instrument<Double>(){

            @Override
            public void sample() {
                this.setValue(statisticsTask.averageMaximumSinkPendingSetSize.getMovingAverage());
            }
        });
        return t;
    }

    protected class PendingSetStatisticsTask
    extends AbstractRunnableMasterStats.StatisticsTask {
        final MovingAverageTask averageMasterPendingSetSize;
        final MovingAverageTask averageSinkPendingSetSize;
        final MovingAverageTask averageMaximumSinkPendingSetSize;

        protected PendingSetStatisticsTask() {
            super(AbstractPendingSetMasterStats.this);
            this.averageMasterPendingSetSize = new MovingAverageTask("averageMasterPendingSetSize", (Callable<? extends Number>)new Callable<Long>(){

                @Override
                public Long call() {
                    long n = 0L;
                    Iterator itr = AbstractPendingSetMasterStats.this.masters.iterator();
                    while (itr.hasNext()) {
                        AbstractPendingSetMasterTask master = (AbstractPendingSetMasterTask)((WeakReference)itr.next()).get();
                        if (master == null) continue;
                        n += (long)master.getPendingSetSize();
                    }
                    return n;
                }
            });
            this.averageSinkPendingSetSize = new MovingAverageTask("averageSinkPendingSetSize", (Callable<? extends Number>)new Callable<Double>(){

                @Override
                public Double call() {
                    final AtomicLong n = new AtomicLong(0L);
                    final AtomicInteger m = new AtomicInteger(0);
                    SubtaskOp op = new SubtaskOp(){

                        public void call(AbstractSubtask subtask) {
                            int size = ((AbstractPendingSetSubtask)subtask).getPendingSetSize();
                            n.addAndGet(size);
                            m.incrementAndGet();
                        }
                    };
                    Iterator itr = AbstractPendingSetMasterStats.this.masters.iterator();
                    while (itr.hasNext()) {
                        AbstractPendingSetMasterTask master = (AbstractPendingSetMasterTask)((WeakReference)itr.next()).get();
                        if (master == null) continue;
                        try {
                            master.mapOperationOverSubtasks(op);
                        }
                        catch (InterruptedException ex) {
                            break;
                        }
                        catch (ExecutionException ex) {
                            PendingSetStatisticsTask.this.log.error((Object)this, (Throwable)ex);
                            break;
                        }
                    }
                    if (m.get() == 0) {
                        return 0.0;
                    }
                    return (double)n.get() / (double)m.get();
                }
            });
            this.averageMaximumSinkPendingSetSize = new MovingAverageTask("averageMaximumSinkPendingSetSize", (Callable<? extends Number>)new Callable<Integer>(){

                @Override
                public Integer call() {
                    final AtomicInteger max = new AtomicInteger(0);
                    SubtaskOp op = new SubtaskOp(){

                        public void call(AbstractSubtask subtask) {
                            int size = ((AbstractPendingSetSubtask)subtask).getPendingSetSize();
                            if (size > max.get()) {
                                max.set(size);
                            }
                        }
                    };
                    Iterator itr = AbstractPendingSetMasterStats.this.masters.iterator();
                    while (itr.hasNext()) {
                        AbstractPendingSetMasterTask master = (AbstractPendingSetMasterTask)((WeakReference)itr.next()).get();
                        if (master == null) continue;
                        try {
                            master.mapOperationOverSubtasks(op);
                        }
                        catch (InterruptedException ex) {
                            break;
                        }
                        catch (ExecutionException ex) {
                            PendingSetStatisticsTask.this.log.error((Object)this, (Throwable)ex);
                            break;
                        }
                    }
                    return max.get();
                }
            });
        }

        @Override
        public void run() {
            super.run();
            this.averageMasterPendingSetSize.run();
            this.averageSinkPendingSetSize.run();
            this.averageMaximumSinkPendingSetSize.run();
        }
    }
}

