/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.ndx.pipeline;

import com.bigdata.cache.ConcurrentWeakValueCache;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import com.bigdata.service.ndx.pipeline.AbstractMasterTask;
import com.bigdata.service.ndx.pipeline.AbstractSubtaskStats;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractMasterStats<L, HS extends AbstractSubtaskStats> {
    public final AtomicLong subtaskStartCount = new AtomicLong();
    public final AtomicLong subtaskEndCount = new AtomicLong();
    public final AtomicLong subtaskIdleTimeoutCount = new AtomicLong();
    private final AtomicInteger maximumPartitionCount = new AtomicInteger();
    public final AtomicLong redirectCount = new AtomicLong();
    public long elapsedRedirectNanos = 0L;
    public final AtomicLong chunksIn = new AtomicLong();
    public final AtomicLong elementsIn = new AtomicLong();
    public final AtomicLong elementsOut = new AtomicLong();
    public final AtomicLong elementsOnSinkQueues = new AtomicLong();
    public final AtomicLong chunksTransferred = new AtomicLong();
    public final AtomicLong elementsTransferred = new AtomicLong();
    public final AtomicLong chunksOut = new AtomicLong();
    public long elapsedSinkOfferNanos = 0L;
    public long elapsedSinkChunkWaitingNanos = 0L;
    public long elapsedSinkChunkWritingNanos = 0L;
    private final ConcurrentWeakValueCache<L, HS> sinkStats = new ConcurrentWeakValueCache(0);
    protected final ConcurrentWeakValueCache<Integer, AbstractMasterTask> masters = new ConcurrentWeakValueCache(0);
    public final AtomicInteger masterCreateCount = new AtomicInteger();

    public int getMaximumPartitionCount() {
        return this.maximumPartitionCount.get();
    }

    public int getActiveSinkCount() {
        return this.sinkStats.size();
    }

    public int getMasterActiveCount() {
        return this.masters.size();
    }

    void addMaster(AbstractMasterTask master) {
        if (master == null) {
            throw new IllegalArgumentException();
        }
        if (this.masters.putIfAbsent((Object)master.hashCode(), (Object)master) == null) {
            this.masterCreateCount.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HS getSubtaskStats(L locator) {
        ConcurrentWeakValueCache<L, HS> concurrentWeakValueCache = this.sinkStats;
        synchronized (concurrentWeakValueCache) {
            AbstractSubtaskStats t = (AbstractSubtaskStats)this.sinkStats.get(locator);
            if (t == null) {
                t = this.newSubtaskStats(locator);
                this.sinkStats.put(locator, (Object)t);
                this.maximumPartitionCount.set(Math.max(this.maximumPartitionCount.get(), this.sinkStats.size()));
            }
            return (HS)t;
        }
    }

    protected abstract HS newSubtaskStats(L var1);

    public Map<L, HS> getSubtaskStats() {
        LinkedHashMap m = new LinkedHashMap(this.sinkStats.size());
        Iterator itr = this.sinkStats.entryIterator();
        while (itr.hasNext()) {
            Map.Entry e = (Map.Entry)itr.next();
            AbstractSubtaskStats subtaskStats = (AbstractSubtaskStats)((WeakReference)e.getValue()).get();
            if (subtaskStats == null) continue;
            m.put(e.getKey(), subtaskStats);
        }
        return m;
    }

    public CounterSet getCounterSet() {
        CounterSet t = new CounterSet();
        t.addCounter("masterCreateCount", new Instrument<Integer>(){

            @Override
            protected void sample() {
                this.setValue(AbstractMasterStats.this.masterCreateCount.get());
            }
        });
        t.addCounter("masterActiveCount", new Instrument<Integer>(){

            @Override
            protected void sample() {
                this.setValue(AbstractMasterStats.this.getMasterActiveCount());
            }
        });
        t.addCounter("subtaskStartCount", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(AbstractMasterStats.this.subtaskStartCount.get());
            }
        });
        t.addCounter("subtaskEndCount", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(AbstractMasterStats.this.subtaskEndCount.get());
            }
        });
        t.addCounter("subtaskIdleTimeout", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(AbstractMasterStats.this.subtaskIdleTimeoutCount.get());
            }
        });
        t.addCounter("maximumPartitionCount", new Instrument<Integer>(){

            @Override
            protected void sample() {
                this.setValue(AbstractMasterStats.this.maximumPartitionCount.get());
            }
        });
        t.addCounter("activePartitionCount", new Instrument<Integer>(){

            @Override
            protected void sample() {
                this.setValue(AbstractMasterStats.this.sinkStats.size());
            }
        });
        t.addCounter("redirectCount", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(AbstractMasterStats.this.redirectCount.get());
            }
        });
        t.addCounter("elapsedRedirectNanos", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(AbstractMasterStats.this.elapsedRedirectNanos);
            }
        });
        t.addCounter("chunksIn", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(AbstractMasterStats.this.chunksIn.get());
            }
        });
        t.addCounter("elementsIn", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(AbstractMasterStats.this.elementsIn.get());
            }
        });
        t.addCounter("chunksOut", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(AbstractMasterStats.this.chunksOut.get());
            }
        });
        t.addCounter("elementsOut", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(AbstractMasterStats.this.elementsOut.get());
            }
        });
        t.addCounter("chunksTransferred", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(AbstractMasterStats.this.chunksTransferred.get());
            }
        });
        t.addCounter("elementsTransferred", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(AbstractMasterStats.this.elementsTransferred.get());
            }
        });
        t.addCounter("elapsedSinkOfferNanos", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(AbstractMasterStats.this.elapsedSinkOfferNanos);
            }
        });
        t.addCounter("elapsedChunkWaitingNanos", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(AbstractMasterStats.this.elapsedSinkChunkWaitingNanos);
            }
        });
        t.addCounter("elapsedChunkWritingNanos", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(AbstractMasterStats.this.elapsedSinkChunkWritingNanos);
            }
        });
        return t;
    }

    public String toString() {
        return this.getClass().getName() + "{subtaskStartCount=" + this.subtaskStartCount + ", subtaskEndCount=" + this.subtaskEndCount + ", subtaskIdleTimeout=" + this.subtaskIdleTimeoutCount + ", partitionCount=" + this.maximumPartitionCount + ", activePartitionCount=" + this.getActiveSinkCount() + ", redirectCount=" + this.redirectCount + ", chunkIn=" + this.chunksIn + ", elementIn=" + this.elementsIn + ", chunksOut=" + this.chunksOut + ", elementsOut=" + this.elementsOut + ", elementsOnSinkQueues=" + this.elementsOnSinkQueues + ", chunksTransferred=" + this.chunksTransferred + ", elementsTransferred=" + this.elementsTransferred + ", elapsedChunkWaitingNanos=" + this.elapsedSinkChunkWaitingNanos + ", elapsedChunkWritingNanos=" + this.elapsedSinkChunkWritingNanos + "}";
    }
}

