/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.geospatial;

import com.bigdata.rdf.internal.impl.extensions.InvalidGeoSpatialDatatypeConfigurationError;
import com.bigdata.service.geospatial.GeoSpatialDatatypeFieldConfiguration;
import com.bigdata.service.geospatial.GeoSpatialDefaultLiteralSerializer;
import com.bigdata.service.geospatial.IGeoSpatialLiteralSerializer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public class GeoSpatialDatatypeConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(GeoSpatialDatatypeConfiguration.class);
    private final URI uri;
    private final IGeoSpatialLiteralSerializer literalSerializer;
    private List<GeoSpatialDatatypeFieldConfiguration> fields;
    private boolean hasLat = false;
    private boolean hasLon = false;
    private boolean hasTime = false;
    private boolean hasCoordSystem = false;
    private Map<String, Integer> customFieldsIdxs = new HashMap<String, Integer>();

    public GeoSpatialDatatypeConfiguration(String uriStr, String literalSerializerClass, JSONArray fieldsJson) {
        if (uriStr == null || uriStr.isEmpty()) {
            throw new InvalidGeoSpatialDatatypeConfigurationError("URI parameter must not be null or empty");
        }
        try {
            this.uri = new URIImpl(uriStr);
        }
        catch (Exception e) {
            throw new InvalidGeoSpatialDatatypeConfigurationError("Invalid URI in geospatial datatype config: " + uriStr);
        }
        if (literalSerializerClass == null || literalSerializerClass.isEmpty()) {
            this.literalSerializer = new GeoSpatialDefaultLiteralSerializer();
        } else {
            try {
                Class<?> literalSerializerClazz = Class.forName(literalSerializerClass);
                try {
                    Object instance = literalSerializerClazz.newInstance();
                    if (!(instance instanceof IGeoSpatialLiteralSerializer)) {
                        throw new InvalidGeoSpatialDatatypeConfigurationError("Literal serializer class " + literalSerializerClass + " does not implement GeoSpatialLiteralSerializer interface.");
                    }
                    this.literalSerializer = (IGeoSpatialLiteralSerializer)instance;
                }
                catch (Exception e) {
                    throw new InvalidGeoSpatialDatatypeConfigurationError("Literal serializer class " + literalSerializerClass + " could not be instantiated: " + e.getMessage());
                }
            }
            catch (ClassNotFoundException e) {
                throw new InvalidGeoSpatialDatatypeConfigurationError("Literal serializer class not found: " + literalSerializerClass);
            }
        }
        this.fields = new ArrayList<GeoSpatialDatatypeFieldConfiguration>();
        for (int i = 0; i < fieldsJson.length(); ++i) {
            try {
                JSONObject fieldJson = fieldsJson.getJSONObject(i);
                this.fields.add(new GeoSpatialDatatypeFieldConfiguration(fieldJson));
                continue;
            }
            catch (JSONException e) {
                log.warn((Object)("Invalid JSON for field description: " + e.getMessage()));
                throw new InvalidGeoSpatialDatatypeConfigurationError(e.getMessage());
            }
        }
        if (this.fields.isEmpty()) {
            throw new InvalidGeoSpatialDatatypeConfigurationError("Geospatial datatype config for datatype " + this.uri + " must have at least one field, but has none.");
        }
        HashSet<GeoSpatialDatatypeFieldConfiguration.ServiceMapping> serviceMappings = new HashSet<GeoSpatialDatatypeFieldConfiguration.ServiceMapping>();
        HashSet<String> customServiceMappings = new HashSet<String>();
        for (int i = 0; i < this.fields.size(); ++i) {
            GeoSpatialDatatypeFieldConfiguration field = this.fields.get(i);
            GeoSpatialDatatypeFieldConfiguration.ServiceMapping curServiceMapping = field.getServiceMapping();
            if (GeoSpatialDatatypeFieldConfiguration.ServiceMapping.CUSTOM.equals((Object)curServiceMapping)) {
                String customServiceMapping = field.getCustomServiceMapping();
                if (customServiceMappings.contains(customServiceMapping)) {
                    throw new InvalidGeoSpatialDatatypeConfigurationError("Duplicate custom service mapping used for geospatial datatype config: " + customServiceMapping);
                }
                customServiceMappings.add(customServiceMapping);
            } else if (serviceMappings.contains((Object)curServiceMapping)) {
                throw new InvalidGeoSpatialDatatypeConfigurationError("Duplicate service mapping used for geospatial datatype config: " + (Object)((Object)curServiceMapping));
            }
            serviceMappings.add(curServiceMapping);
        }
        this.initDerivedMembers();
    }

    public GeoSpatialDatatypeConfiguration(String uriString, IGeoSpatialLiteralSerializer literalSerializer, List<GeoSpatialDatatypeFieldConfiguration> fields) {
        if (uriString == null || uriString.isEmpty()) {
            throw new InvalidGeoSpatialDatatypeConfigurationError("URI string must not be null or empty.");
        }
        if (literalSerializer == null) {
            throw new InvalidGeoSpatialDatatypeConfigurationError("Literal serializer must not be null.");
        }
        if (fields == null) {
            throw new InvalidGeoSpatialDatatypeConfigurationError("Fields must not be null.");
        }
        this.uri = new URIImpl(uriString);
        this.literalSerializer = literalSerializer;
        this.fields = fields;
        this.initDerivedMembers();
    }

    public URI getUri() {
        return this.uri;
    }

    public IGeoSpatialLiteralSerializer getLiteralSerializer() {
        return this.literalSerializer;
    }

    public List<GeoSpatialDatatypeFieldConfiguration> getFields() {
        return this.fields;
    }

    public int idxOfField(GeoSpatialDatatypeFieldConfiguration.ServiceMapping mapping) {
        if (mapping != null) {
            for (int i = 0; i < this.getFields().size(); ++i) {
                if (mapping != this.fields.get(i).getServiceMapping()) continue;
                return i;
            }
        }
        return -1;
    }

    public int[] idxsOfCustomFields(Set<String> customFields) {
        if (customFields == null) {
            return new int[0];
        }
        int[] ret = new int[customFields.size()];
        Arrays.fill(ret, -1);
        int ctr = 0;
        for (int i = 0; i < this.getFields().size(); ++i) {
            GeoSpatialDatatypeFieldConfiguration field = this.fields.get(i);
            for (String customField : customFields) {
                if (GeoSpatialDatatypeFieldConfiguration.ServiceMapping.CUSTOM != field.getServiceMapping() || customField == null || !customField.equals(field.getCustomServiceMapping())) continue;
                ret[ctr++] = i;
            }
        }
        return ret;
    }

    public int getNumDimensions() {
        return this.fields.size();
    }

    public boolean hasLat() {
        return this.hasLat;
    }

    public boolean hasLon() {
        return this.hasLon;
    }

    public boolean hasTime() {
        return this.hasTime;
    }

    public boolean hasCoordSystem() {
        return this.hasCoordSystem;
    }

    public Map<String, Integer> getCustomFieldsIdxs() {
        return this.customFieldsIdxs;
    }

    public boolean hasCustomFields() {
        return !this.customFieldsIdxs.keySet().isEmpty();
    }

    public boolean hasCustomField(String field) {
        return this.customFieldsIdxs.keySet().contains(field);
    }

    public Integer getCustomFieldIdx(String customField) {
        return this.customFieldsIdxs.get(customField);
    }

    public GeoSpatialDatatypeFieldConfiguration.ValueType getValueTypeOfCustomField(String customField) {
        Integer idx = this.getCustomFieldIdx(customField);
        return idx == null ? null : this.fields.get(idx).getValueType();
    }

    void initDerivedMembers() {
        block7: for (int i = 0; i < this.fields.size(); ++i) {
            GeoSpatialDatatypeFieldConfiguration field = this.fields.get(i);
            switch (field.getServiceMapping()) {
                case LATITUDE: {
                    this.hasLat = true;
                    continue block7;
                }
                case LONGITUDE: {
                    this.hasLon = true;
                    continue block7;
                }
                case COORD_SYSTEM: {
                    this.hasCoordSystem = true;
                    continue block7;
                }
                case TIME: {
                    this.hasTime = true;
                    continue block7;
                }
                case CUSTOM: {
                    this.customFieldsIdxs.put(field.getCustomServiceMapping(), i);
                    continue block7;
                }
                default: {
                    throw new InvalidGeoSpatialDatatypeConfigurationError("Unhandled field type: " + (Object)((Object)field.getServiceMapping()));
                }
            }
        }
    }
}

