/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.search;

import com.bigdata.search.ITermMetadata;
import com.bigdata.search.TermMetadata;
import java.util.LinkedHashMap;
import java.util.Map;

public class TermFrequencyData<V extends Comparable<V>> {
    public final V docId;
    public final int fieldId;
    private int totalTermCount = 0;
    public final LinkedHashMap<String, ITermMetadata> terms = new LinkedHashMap();

    public TermFrequencyData(V docId, int fieldId, String token) {
        this.docId = docId;
        this.fieldId = fieldId;
        this.add(token);
    }

    public boolean add(String token) {
        boolean newTerm;
        ITermMetadata termMetadata = this.terms.get(token);
        if (termMetadata == null) {
            termMetadata = new TermMetadata();
            this.terms.put(token, termMetadata);
            newTerm = true;
        } else {
            newTerm = false;
        }
        termMetadata.add();
        ++this.totalTermCount;
        return newTerm;
    }

    public int distinctTermCount() {
        return this.terms.size();
    }

    public int totalTermCount() {
        return this.totalTermCount;
    }

    public double normalize() {
        double termFreq;
        double magnitude = 0.0;
        for (ITermMetadata md : this.terms.values()) {
            termFreq = md.termFreq();
            magnitude += termFreq * termFreq;
        }
        magnitude = Math.sqrt(magnitude);
        for (ITermMetadata md : this.terms.values()) {
            termFreq = md.termFreq();
            md.setLocalTermWeight(termFreq / magnitude);
        }
        return magnitude;
    }

    public Map.Entry<String, ITermMetadata> getSingletonEntry() {
        if (this.terms.size() != 1) {
            throw new RuntimeException("not a singleton");
        }
        return this.terms.entrySet().iterator().next();
    }
}

